/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.sql.Timestamp;
import java.util.Properties;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.eclipse.persistence.annotations.Index;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.NoteType;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBaseAdapter;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.UrlFactory;

@Entity
@Table(name="KRNS_NTE_T", uniqueConstraints={@UniqueConstraint(name="KRNS_NTE_TC0", columnNames={"OBJ_ID"})})
public class Note
extends PersistableBusinessObjectBaseAdapter
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -7647166354016356770L;
    @Id
    @GeneratedValue(generator="KRNS_NTE_S")
    @PortableSequenceGenerator(name="KRNS_NTE_S")
    @Column(name="NTE_ID", length=14, precision=0, updatable=false)
    private Long noteIdentifier;
    @Index(name="KRNS_NTE_TI1")
    @Column(name="RMT_OBJ_ID", length=36, nullable=false)
    private String remoteObjectIdentifier;
    @Column(name="AUTH_PRNCPL_ID", length=40, nullable=false)
    private String authorUniversalIdentifier;
    @Column(name="POST_TS")
    private Timestamp notePostedTimestamp;
    @Column(name="NTE_TYP_CD", length=4, nullable=false)
    private String noteTypeCode;
    @Column(name="TXT", length=800)
    private String noteText;
    @Column(name="TPC_TXT", length=40)
    private String noteTopicText;
    @Column(name="PRG_CD", length=1)
    private String notePurgeCode;
    @Transient
    private String attachmentIdentifier;
    @ManyToOne(targetEntity=NoteType.class, fetch=FetchType.EAGER)
    @JoinColumn(name="NTE_TYP_CD", referencedColumnName="NTE_TYP_CD", updatable=false, insertable=false)
    private NoteType noteType;
    @Transient
    private transient Person authorUniversal;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="NTE_ID", updatable=false, insertable=false)
    private Attachment attachment;
    @Transient
    private AdHocRouteRecipient adHocRouteRecipient;

    public Note() {
        this.setNoteText("");
        this.setNoteTypeCode("DH");
        this.setAdHocRouteRecipient(new AdHocRoutePerson());
    }

    public void setNotePostedTimestampToCurrent() {
        Timestamp now = CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp();
        this.setNotePostedTimestamp(now);
    }

    public Long getNoteIdentifier() {
        return this._persistence_get_noteIdentifier();
    }

    public void setNoteIdentifier(Long noteIdentifier) {
        this._persistence_set_noteIdentifier(noteIdentifier);
    }

    public String getRemoteObjectIdentifier() {
        return this._persistence_get_remoteObjectIdentifier();
    }

    public void setRemoteObjectIdentifier(String remoteObjectIdentifier) {
        this._persistence_set_remoteObjectIdentifier(remoteObjectIdentifier);
    }

    public String getAuthorUniversalIdentifier() {
        return this._persistence_get_authorUniversalIdentifier();
    }

    public void setAuthorUniversalIdentifier(String noteAuthorIdentifier) {
        this._persistence_set_authorUniversalIdentifier(noteAuthorIdentifier);
    }

    public Timestamp getNotePostedTimestamp() {
        return this._persistence_get_notePostedTimestamp();
    }

    public void setNotePostedTimestamp(Timestamp notePostedTimestamp) {
        this._persistence_set_notePostedTimestamp(notePostedTimestamp);
    }

    public String getNoteTypeCode() {
        return this._persistence_get_noteTypeCode();
    }

    public void setNoteTypeCode(String noteTypeCode) {
        this._persistence_set_noteTypeCode(noteTypeCode);
    }

    public String getNoteText() {
        return this._persistence_get_noteText();
    }

    public void setNoteText(String noteText) {
        this._persistence_set_noteText(noteText);
    }

    public String getNoteTopicText() {
        return this._persistence_get_noteTopicText();
    }

    public void setNoteTopicText(String noteTopicText) {
        this._persistence_set_noteTopicText(noteTopicText);
    }

    public String getNotePurgeCode() {
        return this._persistence_get_notePurgeCode();
    }

    public void setNotePurgeCode(String notePurgeCode) {
        this._persistence_set_notePurgeCode(notePurgeCode);
    }

    public NoteType getNoteType() {
        return this._persistence_get_noteType();
    }

    @Deprecated
    public void setNoteType(NoteType noteType) {
        this._persistence_set_noteType(noteType);
    }

    public Person getAuthorUniversal() {
        this.authorUniversal = KimApiServiceLocator.getPersonService().updatePersonIfNecessary(this._persistence_get_authorUniversalIdentifier(), this.authorUniversal);
        return this.authorUniversal;
    }

    @Deprecated
    public void setAuthorUniversal(Person authorUniversal) {
        this.authorUniversal = authorUniversal;
    }

    public Attachment getAttachment() {
        return this._persistence_get_attachment();
    }

    public void setAttachment(Attachment attachment) {
        this._persistence_set_attachment(attachment);
    }

    public String getAttachmentIdentifier() {
        return this.attachmentIdentifier;
    }

    public void setAttachmentIdentifier(String attachmentIdentifier) {
        this.attachmentIdentifier = attachmentIdentifier;
    }

    public void addAttachment(Attachment attachment) {
        this.setAttachmentIdentifier(attachment.getAttachmentIdentifier());
        this.setAttachment(attachment);
        attachment.setNoteIdentifier(this._persistence_get_noteIdentifier());
        attachment.setNote(this);
    }

    public void removeAttachment() {
        this.setAttachment(null);
        this.setAttachmentIdentifier(null);
    }

    public AdHocRouteRecipient getAdHocRouteRecipient() {
        return this.adHocRouteRecipient;
    }

    public void setAdHocRouteRecipient(AdHocRouteRecipient adHocRouteRecipient) {
        this.adHocRouteRecipient = adHocRouteRecipient;
    }

    public String getAttachmentLink() {
        Attachment attachment = KRADServiceLocator.getAttachmentService().getAttachmentByNoteId(this.getNoteIdentifier());
        if (attachment == null) {
            return "";
        }
        Properties params = new Properties();
        params.put("methodToCall", "downloadBOAttachment");
        params.put("docFormKey", "88888888");
        params.put("noteIdentifier", this.getNoteIdentifier().toString());
        return UrlFactory.parameterizeUrl("inquiry.do", params);
    }

    @Override
    public void refresh() {
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Note();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "notePostedTimestamp") {
            return this.notePostedTimestamp;
        }
        if (string == "noteText") {
            return this.noteText;
        }
        if (string == "notePurgeCode") {
            return this.notePurgeCode;
        }
        if (string == "noteType") {
            return this.noteType;
        }
        if (string == "noteTypeCode") {
            return this.noteTypeCode;
        }
        if (string == "attachment") {
            return this.attachment;
        }
        if (string == "remoteObjectIdentifier") {
            return this.remoteObjectIdentifier;
        }
        if (string == "authorUniversalIdentifier") {
            return this.authorUniversalIdentifier;
        }
        if (string == "noteIdentifier") {
            return this.noteIdentifier;
        }
        if (string == "noteTopicText") {
            return this.noteTopicText;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "notePostedTimestamp") {
            this.notePostedTimestamp = (Timestamp)object;
            return;
        }
        if (string == "noteText") {
            this.noteText = (String)object;
            return;
        }
        if (string == "notePurgeCode") {
            this.notePurgeCode = (String)object;
            return;
        }
        if (string == "noteType") {
            this.noteType = (NoteType)object;
            return;
        }
        if (string == "noteTypeCode") {
            this.noteTypeCode = (String)object;
            return;
        }
        if (string == "attachment") {
            this.attachment = (Attachment)object;
            return;
        }
        if (string == "remoteObjectIdentifier") {
            this.remoteObjectIdentifier = (String)object;
            return;
        }
        if (string == "authorUniversalIdentifier") {
            this.authorUniversalIdentifier = (String)object;
            return;
        }
        if (string == "noteIdentifier") {
            this.noteIdentifier = (Long)object;
            return;
        }
        if (string == "noteTopicText") {
            this.noteTopicText = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Timestamp _persistence_get_notePostedTimestamp() {
        this._persistence_checkFetched("notePostedTimestamp");
        return this.notePostedTimestamp;
    }

    public void _persistence_set_notePostedTimestamp(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("notePostedTimestamp");
        this._persistence_propertyChange("notePostedTimestamp", this.notePostedTimestamp, timestamp);
        this.notePostedTimestamp = timestamp;
    }

    public String _persistence_get_noteText() {
        this._persistence_checkFetched("noteText");
        return this.noteText;
    }

    public void _persistence_set_noteText(String string) {
        this._persistence_checkFetchedForSet("noteText");
        this._persistence_propertyChange("noteText", this.noteText, string);
        this.noteText = string;
    }

    public String _persistence_get_notePurgeCode() {
        this._persistence_checkFetched("notePurgeCode");
        return this.notePurgeCode;
    }

    public void _persistence_set_notePurgeCode(String string) {
        this._persistence_checkFetchedForSet("notePurgeCode");
        this._persistence_propertyChange("notePurgeCode", this.notePurgeCode, string);
        this.notePurgeCode = string;
    }

    public NoteType _persistence_get_noteType() {
        this._persistence_checkFetched("noteType");
        return this.noteType;
    }

    public void _persistence_set_noteType(NoteType noteType) {
        this._persistence_checkFetchedForSet("noteType");
        this._persistence_propertyChange("noteType", this.noteType, noteType);
        this.noteType = noteType;
    }

    public String _persistence_get_noteTypeCode() {
        this._persistence_checkFetched("noteTypeCode");
        return this.noteTypeCode;
    }

    public void _persistence_set_noteTypeCode(String string) {
        this._persistence_checkFetchedForSet("noteTypeCode");
        this._persistence_propertyChange("noteTypeCode", this.noteTypeCode, string);
        this.noteTypeCode = string;
    }

    public Attachment _persistence_get_attachment() {
        this._persistence_checkFetched("attachment");
        return this.attachment;
    }

    public void _persistence_set_attachment(Attachment attachment) {
        this._persistence_checkFetchedForSet("attachment");
        this._persistence_propertyChange("attachment", this.attachment, attachment);
        this.attachment = attachment;
    }

    public String _persistence_get_remoteObjectIdentifier() {
        this._persistence_checkFetched("remoteObjectIdentifier");
        return this.remoteObjectIdentifier;
    }

    public void _persistence_set_remoteObjectIdentifier(String string) {
        this._persistence_checkFetchedForSet("remoteObjectIdentifier");
        this._persistence_propertyChange("remoteObjectIdentifier", this.remoteObjectIdentifier, string);
        this.remoteObjectIdentifier = string;
    }

    public String _persistence_get_authorUniversalIdentifier() {
        this._persistence_checkFetched("authorUniversalIdentifier");
        return this.authorUniversalIdentifier;
    }

    public void _persistence_set_authorUniversalIdentifier(String string) {
        this._persistence_checkFetchedForSet("authorUniversalIdentifier");
        this._persistence_propertyChange("authorUniversalIdentifier", this.authorUniversalIdentifier, string);
        this.authorUniversalIdentifier = string;
    }

    public Long _persistence_get_noteIdentifier() {
        this._persistence_checkFetched("noteIdentifier");
        return this.noteIdentifier;
    }

    public void _persistence_set_noteIdentifier(Long l) {
        this._persistence_checkFetchedForSet("noteIdentifier");
        this._persistence_propertyChange("noteIdentifier", this.noteIdentifier, l);
        this.noteIdentifier = l;
    }

    public String _persistence_get_noteTopicText() {
        this._persistence_checkFetched("noteTopicText");
        return this.noteTopicText;
    }

    public void _persistence_set_noteTopicText(String string) {
        this._persistence_checkFetchedForSet("noteTopicText");
        this._persistence_propertyChange("noteTopicText", this.noteTopicText, string);
        this.noteTopicText = string;
    }
}

