/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.comparator;

import java.io.Serializable;
import java.util.Comparator;

public final class StringValueComparator implements Serializable, Comparator<String> {
    private static final StringValueComparator INSTANCE = new StringValueComparator();
    
    private StringValueComparator() {
    	//private
    }

    public static StringValueComparator getInstance() {
        return INSTANCE;
    }
    
    @Override
	public int compare(String o1, String o2) {
        // null guard. non-null value is greater. equal if both are null
        if (null == o1 || null == o2) {
            return (null == o1 && null == o2) ? 0 : ((null == o1) ? -1 : 1);
        }

        return String.CASE_INSENSITIVE_ORDER.compare(o1, o2);
    }
}
