/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;

@Entity
@Table(name="KRNS_ADHOC_RTE_ACTN_RECIP_T")
public class AdHocRoutePerson
extends AdHocRouteRecipient
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @Transient
    private transient Person person;

    public AdHocRoutePerson() {
        this.setType(PERSON_TYPE);
    }

    @Override
    public void setType(Integer type) {
        if (!PERSON_TYPE.equals(type)) {
            throw new IllegalArgumentException("cannot change type to " + type);
        }
        super.setType(type);
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (StringUtils.isNotBlank((String)id)) {
            this.person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(id);
            this.setPerson(this.person);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (StringUtils.isNotBlank((String)name) && this.getId() != null && this.person != null && !StringUtils.equals((String)this.person.getName(), (String)name)) {
            this.person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(this.getId());
            this.setPerson(this.person);
        }
    }

    public Person getPerson() {
        if (this.person == null || !StringUtils.equals((String)this.person.getPrincipalName(), (String)this.getId())) {
            this.person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(this.getId());
            if (this.person == null) {
                try {
                    this.person = (Person)KimApiServiceLocator.getPersonService().getPersonImplementationClass().newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
        if (person != null) {
            this._persistence_set_id(person.getPrincipalName());
            this.name = person.getName();
        }
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AdHocRoutePerson();
    }

    @Override
    public Object _persistence_get(String string) {
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        super._persistence_set(string, object);
    }
}

