/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.jpa.converters;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

import org.kuali.rice.core.api.util.type.KualiInteger;

/**
 * Converts the custom {@link KualiInteger} objects for OJB by converting them to/from {@link Long}.
 */
@Converter(
		autoApply = true)
public class KualiIntegerConverter implements AttributeConverter<KualiInteger, Long> {

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a {@link KualiInteger} to a {@link Long}.
     */
	@Override
	public Long convertToDatabaseColumn(KualiInteger objectValue) {
		if (objectValue == null) {
			return null;
		}
		return objectValue.longValue();
	}

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a {@link Long} to a {@link KualiInteger}.
     */
	@Override
	public KualiInteger convertToEntityAttribute(Long dataValue) {
		if (dataValue == null) {
			return null;
		}
		return new KualiInteger(dataValue);
	}

}
