/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.metadata;

import java.io.Serializable;

/**
* Parent and child attribute relationship.
*
* <p>
* Represents a relationship between a parent and child attribute. Used in the context of a {@link MetadataChild}
* object.
* </p>
*
* @author Kuali Rice Team (rice.collab@kuali.org)
*/
public interface DataObjectAttributeRelationship extends Serializable {

    /**
    * Gets attribute name of parent.
    *
    * <p>
    * The property on the "parent" data object.
    * </p>
    *
    * @return attribute name of parent
    */
    String getParentAttributeName();

    /**
    * Gets matching child property.
    *
    * <p>
    * The matching property on the "child", usually part of the child data object's primary key.
    * </p>
    *
    * @return matching child property
    */
    String getChildAttributeName();
}
