/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.provider;

import java.util.List;

/**
 * This metadata provider forms the main provider for the krad-data module.
 *
 * <p>It's responsible for merging the provided list of metadata providers.</p>
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */
public interface CompositeMetadataProvider extends MetadataProvider {

	/**
	 * The list of providers this provider will use.
     *
     * <p>They must be in the necessary order for processing. Later providers in the list.</p>
	 * 
	 * @return a list of all metadata providers contained within this composite provider
	 */
	List<MetadataProvider> getProviders();

}
