/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;


/**
 * PersistenceOption is used when saving through the data object service to configure how the data will be stored.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PersistenceOption implements Serializable {
	private static final long serialVersionUID = 1L;

    /**
     * Used to link references and synchronize foreign keys in the data object.
     */
    public static PersistenceOption LINK_KEYS = new PersistenceOption("org.kuali.rice.krad.data.LINK_KEYS");

    /**
     * Used to synchronize the data object with the database.
     */
    public static PersistenceOption FLUSH = new PersistenceOption("org.kuali.rice.krad.data.FLUSH");

    private final String optionId;

    /**
    * Sets the option Id
    *
    * @param optionId cannot be null or blank.
    */
    public PersistenceOption(String optionId) {
        if (StringUtils.isBlank(optionId)) {
            throw new IllegalArgumentException("optionId must not be a null or blank value");
        }
        this.optionId = optionId;
    }

    /**
    * Gets the option id.
    *
    * @return not null or blank.
    */
    public String getOptionId() {
        return this.optionId;
    }

}
