/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.jpa.converters;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

/**
 * Converts true/false represented by the characters "T" and "F" to and from true and false.
 *
 * <p>The conversion treats the values as follows: "T" is true and "F" is false.</p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Converter
public class BooleanTFConverter implements AttributeConverter<Boolean, String> {

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a false or true value to an "F" or "T" value.
     */
	@Override
	public String convertToDatabaseColumn(Boolean objectValue) {
		if (objectValue == null) {
			return "F";
		}
		return objectValue ? "T" : "F";
	}

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a "F" or "T" value to a false or true.
     */
	@Override
	public Boolean convertToEntityAttribute(String dataValue) {
		if (dataValue == null) {
			return false;
		}
		return dataValue.equals("T");
	}
}
