/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.jpa.converters;

import java.math.BigDecimal;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

import org.kuali.rice.core.api.util.type.KualiPercent;

/**
 * Converts the custom {@link KualiPercent} objects for OJB by converting them to/from {@link BigDecimal}.
 */
@Converter(
		autoApply = true)
public class KualiPercentConverter implements AttributeConverter<KualiPercent, BigDecimal> {

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a {@link KualiPercent} to a {@link BigDecimal}.
     */
	@Override
	public BigDecimal convertToDatabaseColumn(KualiPercent objectValue) {
		if (objectValue == null) {
			return null;
		}
		return objectValue.bigDecimalValue();
	}

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a {@link BigDecimal} to a {@link KualiPercent}.
     */
	@Override
	public KualiPercent convertToEntityAttribute(BigDecimal dataValue) {
		if (dataValue == null) {
			return null;
		}
		return new KualiPercent(dataValue);
	}
}
