/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.metadata.impl;

import org.kuali.rice.krad.data.metadata.DataObjectMetadata;


/**
 * Additional methods which are needed to support the linking between embedded metadata objects but that we don't want
 * to expose on our public interfaces.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DataObjectMetadataInternal extends DataObjectMetadata {
	/**
	 * The embedded DataObjectMetadata which will be used to fill in values not specified by this DataObjectMetadata.
	 * 
	 * @return the embedded metadata, or no if no metadata is embedded
	 */
	DataObjectMetadataInternal getEmbedded();

    /**
    * Sets the embedded DataObjectMetadata.
    *
    * @param embedded or null
    */
	void setEmbedded(DataObjectMetadataInternal embedded);
}
