/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.provider.annotation;

/**
 * Defines different context(s) for serialization in Rice.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public enum SerializationContext {

    /**
     * Matches all the other contexts defined in {@link SerializationContext}.
     */
    ALL,

    /**
     * The context for serializing within the maintenance document framework.
     */
    MAINTENANCE;

// TODO: implement respect for @Serialized in workflow doc serialization
//    /**
//     * The context for serializing to workflow document contents.
//     */
//    WORKFLOW;

    /**
     * Does the given array of serializationContexts match this one?
     *
     * <p>Either an exact match, or SerializationContext.ALL will suffice</p>
     *
     * @param serializationContexts the serializationContexts to test against
     * @return true if there is a matching context
     */
    public boolean matches(SerializationContext [] serializationContexts) {
        if (serializationContexts != null) for (SerializationContext serializationContext : serializationContexts) {
            if (serializationContext == this || serializationContext == SerializationContext.ALL) {
                return true;
            }
        }

        return false;
    }
}
