/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.List;
import java.util.Objects;
import javax.persistence.Query;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.jpa.CriteriaQuery;
import org.kuali.rice.krad.data.jpa.QueryTranslator;

abstract class DataObjectCriteriaQueryBase<C, Q, QC>
implements CriteriaQuery {
    DataObjectCriteriaQueryBase() {
    }

    protected abstract QueryTranslator<C, Q, QC> getQueryTranslator();

    protected abstract int getRowCount(QC var1);

    protected abstract int getIncludedRowCount(QC var1);

    protected abstract <T> List<T> getResults(Q var1);

    protected abstract int executeUpdate(Query var1);

    @Override
    public <T> void deleteMatching(Class<T> type, QueryByCriteria criteria) {
        if (type == null) {
            throw new IllegalArgumentException("class type is null");
        }
        if (criteria == null || criteria.getPredicate() == null) {
            throw new IllegalArgumentException("criteria is null");
        }
        C parent = this.getQueryTranslator().translateCriteria(type, criteria);
        Query query = this.getQueryTranslator().createDeletionQuery(type, parent);
        this.executeUpdate(query);
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("class type is null");
        }
        C parent = this.getQueryTranslator().translateCriteria(type, QueryByCriteria.Builder.create().build());
        Query query = this.getQueryTranslator().createDeletionQuery(type, parent);
        this.executeUpdate(query);
    }

    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, QueryByCriteria criteria) {
        if (queryClass == null) {
            throw new IllegalArgumentException("queryClass is null");
        }
        if (criteria == null) {
            throw new IllegalArgumentException("criteria is null");
        }
        C resultsCriteria = this.getQueryTranslator().translateCriteria(queryClass, criteria);
        C countCriteria = this.getQueryTranslator().translateCriteriaForCount(queryClass, criteria);
        switch (Objects.requireNonNull(criteria.getCountFlag())) {
            case ONLY: {
                return this.forCountOnly(queryClass, criteria, countCriteria);
            }
            case NONE: {
                return this.forRowResults(queryClass, criteria, resultsCriteria);
            }
            case INCLUDE: {
                return this.forRowResultsWithCount(queryClass, criteria, resultsCriteria, countCriteria);
            }
        }
        throw new UnsupportedCountFlagException(criteria.getCountFlag());
    }

    protected <T> GenericQueryResults<T> forRowResults(Class<T> queryClass, QueryByCriteria criteria, C resultsCriteria) {
        GenericQueryResults.Builder results = GenericQueryResults.Builder.create();
        this.addResults(queryClass, criteria, resultsCriteria, results);
        return results.build();
    }

    protected <T> GenericQueryResults<T> forRowResultsWithCount(Class<T> queryClass, QueryByCriteria criteria, C resultsCriteria, C countCriteria) {
        GenericQueryResults.Builder results = GenericQueryResults.Builder.create();
        QC queryForCount = this.getQueryTranslator().createQueryForCount(queryClass, countCriteria);
        results.setTotalRowCount(Integer.valueOf(this.getIncludedRowCount(queryForCount)));
        this.addResults(queryClass, criteria, resultsCriteria, results);
        return results.build();
    }

    private <T> void addResults(Class<T> queryClass, QueryByCriteria criteria, C ojbCriteria, GenericQueryResults.Builder<T> results) {
        Q query = this.getQueryTranslator().createQuery(queryClass, ojbCriteria);
        this.getQueryTranslator().convertQueryFlags(criteria, query);
        List<T> rows = this.getResults(query);
        if (criteria.getMaxResults() != null && rows.size() > criteria.getMaxResults()) {
            results.setMoreResultsAvailable(true);
            rows.remove(criteria.getMaxResults());
        }
        results.setResults(rows);
    }

    protected <T> GenericQueryResults<T> forCountOnly(Class<T> queryClass, QueryByCriteria criteria, C platformCriteria) {
        QC queryForCount = this.getQueryTranslator().createQueryForCount(queryClass, platformCriteria);
        GenericQueryResults.Builder results = GenericQueryResults.Builder.create();
        results.setTotalRowCount(Integer.valueOf(this.getRowCount(queryForCount)));
        return results.build();
    }

    protected static class UnsupportedCountFlagException
    extends RuntimeException {
        protected UnsupportedCountFlagException(CountFlag flag) {
            super("Unsupported predicate [" + flag + "]");
        }
    }
}

