/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.provider.annotation;

import org.kuali.rice.krad.data.metadata.SortDirection;

/**
 * Defines an attribute on which to sort a collection.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public @interface CollectionSortAttribute {

    /**
     * Gets the attribute name to sort on.
     *
     * @return the attribute name to sort on.
     */
	String value();

    /**
     * Gets the direction which to sort.
     *
     * @return the direction which to sort.
     */
	SortDirection sortDirection() default SortDirection.ASCENDING;
}
