/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Converter;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.weaving.LoadTimeWeaverAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.util.ClassUtils;

public class KradEntityManagerFactoryBean
implements FactoryBean<EntityManagerFactory>,
BeanClassLoaderAware,
BeanFactoryAware,
BeanNameAware,
InitializingBean,
DisposableBean,
EntityManagerFactoryInfo,
PersistenceExceptionTranslator,
ResourceLoaderAware,
LoadTimeWeaverAware {
    private static final Logger LOG = LogManager.getLogger(KradEntityManagerFactoryBean.class);
    private static final String JPA_VENDOR_ADAPTER_CLASS = "jpa.vendor.adapter.class";
    public static final String JPA_PROPERTY_PREFIX = "rice.krad.jpa.";
    public static final String GLOBAL_JPA_PROPERTY_PREFIX = "rice.krad.jpa.global.";
    private static final boolean DEFAULT_EXCLUDE_UNLISTED_CLASSES = true;
    private static final String DEFAULT_CONVERTERS_PACKAGE = BooleanYNConverter.class.getPackage().getName();
    private final DefaultPersistenceUnitManager persistenceUnitManager;
    private final LocalContainerEntityManagerFactoryBean internalFactoryBean;
    private List<PersistenceUnitPostProcessor> persistenceUnitPostProcessors = new ArrayList<PersistenceUnitPostProcessor>();
    private List<String> managedClassNames = new ArrayList<String>();
    private List<String> converterPackageNames = new ArrayList<String>();

    public KradEntityManagerFactoryBean() throws Exception {
        this.converterPackageNames.add(DEFAULT_CONVERTERS_PACKAGE);
        this.persistenceUnitManager = this.createPersistenceUnitManager();
        this.internalFactoryBean = this.createInternalFactoryBean((PersistenceUnitManager)this.persistenceUnitManager);
        this.internalFactoryBean.setJpaPropertyMap(this.createDefaultJpaProperties());
        Object jpaVendorAdapterClass = this.getJpaPropertyMap().get(JPA_VENDOR_ADAPTER_CLASS);
        if (jpaVendorAdapterClass != null) {
            this.setJpaVendorAdapter((JpaVendorAdapter)Class.forName((String)jpaVendorAdapterClass).newInstance());
        }
    }

    protected LocalContainerEntityManagerFactoryBean getInternalFactoryBean() {
        return this.internalFactoryBean;
    }

    protected DefaultPersistenceUnitManager createPersistenceUnitManager() {
        DefaultPersistenceUnitManager pum = new DefaultPersistenceUnitManager();
        pum.setPersistenceXmlLocations(new String[0]);
        pum.setMappingResources(new String[0]);
        pum.setPackagesToScan(new String[0]);
        return pum;
    }

    protected LocalContainerEntityManagerFactoryBean createInternalFactoryBean(PersistenceUnitManager manager) {
        LocalContainerEntityManagerFactoryBean delegate = new LocalContainerEntityManagerFactoryBean();
        delegate.setPersistenceUnitManager(manager);
        return delegate;
    }

    public void afterPropertiesSet() throws PersistenceException {
        if (this.persistenceUnitManager.getDefaultJtaDataSource() != null && this.persistenceUnitManager.getDefaultDataSource() != null) {
            throw new IllegalStateException(this.getPersistenceUnitName() + ": " + this.getClass().getSimpleName() + " was configured with both a JTA and Non-JTA  datasource. Must configure one or the other, but not both.");
        }
        this.internalFactoryBean.setJpaPropertyMap(this.defaultAndMergeJpaProperties());
        this.persistenceUnitManager.setPersistenceUnitPostProcessors(this.assemblePersistenceUnitPostProcessors());
        this.persistenceUnitManager.afterPropertiesSet();
        this.internalFactoryBean.afterPropertiesSet();
    }

    private Map<String, ?> createDefaultJpaProperties() {
        HashMap<String, String> jpaProperties = new HashMap<String, String>();
        this.loadGlobalJpaDefaults(jpaProperties);
        this.loadPersistenceUnitJpaDefaults(jpaProperties);
        this.loadCustomJpaDefaults(jpaProperties);
        return jpaProperties;
    }

    private Map<String, ?> defaultAndMergeJpaProperties() {
        HashMap jpaProperties = new HashMap(this.createDefaultJpaProperties());
        Map configuredJpaPropertyMap = this.internalFactoryBean.getJpaPropertyMap();
        jpaProperties.putAll(configuredJpaPropertyMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getPersistenceUnitName() + ": JPA Properties Set:\n" + String.valueOf(jpaProperties));
        }
        return jpaProperties;
    }

    protected void loadCustomJpaDefaults(Map<String, String> jpaProperties) {
    }

    protected void loadGlobalJpaDefaults(Map<String, String> jpaProperties) {
        jpaProperties.putAll(ConfigContext.getCurrentContextConfig().getPropertiesWithPrefix(GLOBAL_JPA_PROPERTY_PREFIX, true));
    }

    protected void loadPersistenceUnitJpaDefaults(Map<String, String> jpaProperties) {
        jpaProperties.putAll(ConfigContext.getCurrentContextConfig().getPropertiesWithPrefix(this.constructPersistenceUnitJpaPropertyPrefix(), true));
    }

    protected String constructPersistenceUnitJpaPropertyPrefix() {
        return JPA_PROPERTY_PREFIX + this.getPersistenceUnitName() + ".";
    }

    protected PersistenceUnitPostProcessor[] assemblePersistenceUnitPostProcessors() {
        this.persistenceUnitPostProcessors = new ArrayList<PersistenceUnitPostProcessor>(this.persistenceUnitPostProcessors);
        this.persistenceUnitPostProcessors.add(new InternalPersistenceUnitPostProcessor());
        return this.persistenceUnitPostProcessors.toArray(new PersistenceUnitPostProcessor[0]);
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public PersistenceUnitPostProcessor[] getPersistenceUnitPostProcessors() {
        return this.persistenceUnitPostProcessors.toArray(new PersistenceUnitPostProcessor[0]);
    }

    protected DefaultPersistenceUnitManager getPersistenceUnitManager() {
        return this.persistenceUnitManager;
    }

    public void destroy() {
        this.internalFactoryBean.destroy();
    }

    public Class<? extends EntityManagerFactory> getObjectType() {
        return this.internalFactoryBean.getObjectType();
    }

    public boolean isSingleton() {
        return this.internalFactoryBean.isSingleton();
    }

    public EntityManagerFactory getObject() {
        return this.internalFactoryBean.getObject();
    }

    public EntityManagerFactory getNativeEntityManagerFactory() {
        return this.internalFactoryBean.getNativeEntityManagerFactory();
    }

    public EntityManager createNativeEntityManager(Map<?, ?> map) {
        return this.internalFactoryBean.createNativeEntityManager(map);
    }

    public void setBeanName(String name) {
        this.internalFactoryBean.setBeanName(name);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.internalFactoryBean.setBeanFactory(beanFactory);
    }

    public ClassLoader getBeanClassLoader() {
        return this.internalFactoryBean.getBeanClassLoader();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.internalFactoryBean.setBeanClassLoader(classLoader);
    }

    public Class<? extends EntityManager> getEntityManagerInterface() {
        return this.internalFactoryBean.getEntityManagerInterface();
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.persistenceUnitManager.setLoadTimeWeaver(loadTimeWeaver);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.persistenceUnitManager.setResourceLoader(resourceLoader);
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.internalFactoryBean.getPersistenceUnitInfo();
    }

    public String getPersistenceUnitName() {
        return this.internalFactoryBean.getPersistenceUnitName();
    }

    public DataSource getDataSource() {
        PersistenceUnitInfo pui = this.internalFactoryBean.getPersistenceUnitInfo();
        if (this.internalFactoryBean.getPersistenceUnitInfo() != null) {
            return pui.getJtaDataSource() != null ? pui.getJtaDataSource() : pui.getNonJtaDataSource();
        }
        return this.persistenceUnitManager.getDefaultJtaDataSource() != null ? this.persistenceUnitManager.getDefaultJtaDataSource() : this.persistenceUnitManager.getDefaultDataSource();
    }

    public JpaDialect getJpaDialect() {
        return this.internalFactoryBean.getJpaDialect();
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.internalFactoryBean.getPersistenceProvider();
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.internalFactoryBean.translateExceptionIfPossible(ex);
    }

    public void setManagedClassNames(List<String> managedClassNames) {
        if (managedClassNames == null) {
            managedClassNames = new ArrayList<String>();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(this.getPersistenceUnitName() + ": Setting Managed Class Names JPA:\n" + String.valueOf(managedClassNames));
        }
        this.managedClassNames = managedClassNames;
    }

    public void setEntityManagerInterface(Class<? extends EntityManager> emInterface) {
        this.internalFactoryBean.setEntityManagerInterface(emInterface);
    }

    public void setEntityManagerFactoryInterface(Class<? extends EntityManagerFactory> emfInterface) {
        this.internalFactoryBean.setEntityManagerFactoryInterface(emfInterface);
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.internalFactoryBean.getJpaPropertyMap();
    }

    public void setJpaPropertyMap(Map<String, ?> jpaProperties) {
        this.internalFactoryBean.setJpaPropertyMap(jpaProperties);
    }

    public void setJpaProperties(Properties jpaProperties) {
        this.internalFactoryBean.setJpaProperties(jpaProperties);
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.internalFactoryBean.setPersistenceUnitName(persistenceUnitName);
        this.persistenceUnitManager.setDefaultPersistenceUnitName(persistenceUnitName);
    }

    public void setPackagesToScan(String ... packagesToScan) {
        if (LOG.isInfoEnabled()) {
            LOG.info(this.getPersistenceUnitName() + ": Setting Packages to Scan for JPA Annotations:\n" + Arrays.deepToString(packagesToScan));
        }
        this.persistenceUnitManager.setPackagesToScan(packagesToScan);
        this.converterPackageNames = Arrays.asList(packagesToScan);
    }

    public void setMappingResources(String ... mappingResources) {
        this.persistenceUnitManager.setMappingResources(mappingResources);
    }

    public void setDataSource(DataSource dataSource) {
        this.persistenceUnitManager.setDefaultDataSource(dataSource);
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.persistenceUnitManager.setDefaultJtaDataSource(jtaDataSource);
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.internalFactoryBean.setPersistenceProvider(persistenceProvider);
    }

    public void setJpaDialect(JpaDialect jpaDialect) {
        this.internalFactoryBean.setJpaDialect(jpaDialect);
    }

    public void setJpaVendorAdapter(JpaVendorAdapter jpaVendorAdapter) {
        this.internalFactoryBean.setJpaVendorAdapter(jpaVendorAdapter);
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor ... postProcessors) {
        this.persistenceUnitPostProcessors = new ArrayList<PersistenceUnitPostProcessor>(Arrays.asList(postProcessors));
    }

    private final class InternalPersistenceUnitPostProcessor
    implements PersistenceUnitPostProcessor {
        private final TypeFilter converterAnnotationTypeFilter = new AnnotationTypeFilter(Converter.class);
        private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        private static final String ENTITY_CLASS_RESOURCE_PATTERN = "/**/*.class";

        private InternalPersistenceUnitPostProcessor() {
        }

        public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
            pui.setExcludeUnlistedClasses(true);
            this.processConverterPackages(pui);
            for (String managedClassName : KradEntityManagerFactoryBean.this.getManagedClassNames()) {
                pui.addManagedClassName(managedClassName);
            }
        }

        private void processConverterPackages(MutablePersistenceUnitInfo pui) {
            if (KradEntityManagerFactoryBean.this.converterPackageNames != null) {
                for (String converterPackage : KradEntityManagerFactoryBean.this.converterPackageNames) {
                    try {
                        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)converterPackage) + ENTITY_CLASS_RESOURCE_PATTERN;
                        if (LOG.isInfoEnabled()) {
                            LOG.info(KradEntityManagerFactoryBean.this.getPersistenceUnitName() + ": Scanning for JPA @Converter annotations in: " + pattern);
                        }
                        Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                        CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                        for (Resource resource : resources) {
                            if (!resource.isReadable()) continue;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(KradEntityManagerFactoryBean.this.getPersistenceUnitName() + ": Found Matching Resource: " + String.valueOf(resource));
                            }
                            MetadataReader reader = readerFactory.getMetadataReader(resource);
                            String className = reader.getClassMetadata().getClassName();
                            if (pui.getManagedClassNames().contains(className) || !this.converterAnnotationTypeFilter.match(reader, (MetadataReaderFactory)readerFactory)) continue;
                            pui.addManagedClassName(className);
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug(KradEntityManagerFactoryBean.this.getPersistenceUnitName() + ": Registering Converter in JPA Persistence Unit: " + className);
                        }
                    }
                    catch (IOException ex) {
                        throw new PersistenceException("Failed to scan classpath converters in package: " + converterPackage, (Throwable)ex);
                    }
                }
            }
        }
    }
}

