/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.impl;

import com.google.common.collect.Sets;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.MaterializeOption;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.metadata.MetadataChild;
import org.kuali.rice.krad.data.util.ReferenceLinker;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;

public abstract class DataObjectWrapperBase<T>
implements DataObjectWrapper<T> {
    private static final Logger LOG = LogManager.getLogger(DataObjectWrapperBase.class);
    private final T dataObject;
    private final DataObjectMetadata metadata;
    private final BeanWrapper wrapper;
    private final DataObjectService dataObjectService;
    private final ReferenceLinker referenceLinker;

    protected DataObjectWrapperBase(T dataObject, DataObjectMetadata metadata, DataObjectService dataObjectService, ReferenceLinker referenceLinker) {
        this.dataObject = dataObject;
        this.metadata = metadata;
        this.dataObjectService = dataObjectService;
        this.referenceLinker = referenceLinker;
        this.wrapper = PropertyAccessorFactory.forBeanPropertyAccess(dataObject);
    }

    @Override
    public DataObjectMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public T getWrappedInstance() {
        return this.dataObject;
    }

    @Override
    public Object getPropertyValueNullSafe(String propertyName) throws BeansException {
        try {
            return this.getPropertyValue(propertyName);
        }
        catch (NullValueInNestedPathException e) {
            return null;
        }
    }

    @Override
    public Class<T> getWrappedClass() {
        return this.wrapper.getWrappedClass();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.wrapper.getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws InvalidPropertyException {
        return this.wrapper.getPropertyDescriptor(propertyName);
    }

    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
        this.wrapper.setAutoGrowNestedPaths(autoGrowNestedPaths);
    }

    public boolean isAutoGrowNestedPaths() {
        return this.wrapper.isAutoGrowNestedPaths();
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        this.wrapper.setAutoGrowCollectionLimit(autoGrowCollectionLimit);
    }

    public int getAutoGrowCollectionLimit() {
        return this.wrapper.getAutoGrowCollectionLimit();
    }

    public void setConversionService(ConversionService conversionService) {
        this.wrapper.setConversionService(conversionService);
    }

    public ConversionService getConversionService() {
        return this.wrapper.getConversionService();
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.wrapper.setExtractOldValueForEditor(extractOldValueForEditor);
    }

    public boolean isExtractOldValueForEditor() {
        return this.wrapper.isExtractOldValueForEditor();
    }

    public boolean isReadableProperty(String propertyName) {
        return this.wrapper.isReadableProperty(propertyName);
    }

    public boolean isWritableProperty(String propertyName) {
        return this.wrapper.isWritableProperty(propertyName);
    }

    public Class<?> getPropertyType(String propertyName) throws BeansException {
        return this.wrapper.getPropertyType(propertyName);
    }

    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        return this.wrapper.getPropertyTypeDescriptor(propertyName);
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        return this.wrapper.getPropertyValue(propertyName);
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        this.wrapper.setPropertyValue(propertyName, value);
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.wrapper.setPropertyValue(pv);
    }

    public void setPropertyValues(Map<?, ?> map) throws BeansException {
        this.wrapper.setPropertyValues(map);
    }

    public void setPropertyValues(PropertyValues pvs) throws BeansException {
        this.wrapper.setPropertyValues(pvs);
    }

    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown) throws BeansException {
        this.wrapper.setPropertyValues(pvs, ignoreUnknown);
    }

    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown, boolean ignoreInvalid) throws BeansException {
        this.wrapper.setPropertyValues(pvs, ignoreUnknown, ignoreInvalid);
    }

    public void registerCustomEditor(Class<?> requiredType, PropertyEditor propertyEditor) {
        this.wrapper.registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(Class<?> requiredType, String propertyPath, PropertyEditor propertyEditor) {
        this.wrapper.registerCustomEditor(requiredType, propertyPath, propertyEditor);
    }

    public PropertyEditor findCustomEditor(Class<?> requiredType, String propertyPath) {
        return this.wrapper.findCustomEditor(requiredType, propertyPath);
    }

    public <Y> Y convertIfNecessary(Object value, Class<Y> requiredType) throws TypeMismatchException {
        return (Y)this.wrapper.convertIfNecessary(value, requiredType);
    }

    public <Y> Y convertIfNecessary(Object value, Class<Y> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return (Y)this.wrapper.convertIfNecessary(value, requiredType, methodParam);
    }

    public <Y> Y convertIfNecessary(Object value, Class<Y> requiredType, Field field) throws TypeMismatchException {
        return (Y)this.wrapper.convertIfNecessary(value, requiredType, field);
    }

    @Override
    public Map<String, Object> getPrimaryKeyValues() {
        HashMap<String, Object> primaryKeyValues = new HashMap<String, Object>();
        if (this.metadata != null) {
            List<String> primaryKeyAttributeNames = this.metadata.getPrimaryKeyAttributeNames();
            if (primaryKeyAttributeNames != null) {
                for (String primaryKeyAttributeName : primaryKeyAttributeNames) {
                    primaryKeyValues.put(primaryKeyAttributeName, this.getPropertyValue(primaryKeyAttributeName));
                }
            }
        } else {
            LOG.warn("Attempt to retrieve PK fields on object with no metadata: " + this.dataObject.getClass().getName());
        }
        return primaryKeyValues;
    }

    @Override
    public Object getPrimaryKeyValue() {
        if (!this.areAllPrimaryKeyAttributesPopulated()) {
            return null;
        }
        Map<String, Object> primaryKeyValues = this.getPrimaryKeyValues();
        if (primaryKeyValues.size() == 1) {
            return primaryKeyValues.values().iterator().next();
        }
        return new CompoundKey(primaryKeyValues);
    }

    @Override
    public boolean areAllPrimaryKeyAttributesPopulated() {
        if (this.metadata != null) {
            List<String> primaryKeyAttributeNames = this.metadata.getPrimaryKeyAttributeNames();
            if (primaryKeyAttributeNames != null) {
                for (String primaryKeyAttributeName : primaryKeyAttributeNames) {
                    Object propValue = this.getPropertyValue(primaryKeyAttributeName);
                    if (propValue != null && (!(propValue instanceof String) || !StringUtils.isBlank((String)((String)propValue)))) continue;
                    return false;
                }
            }
            return true;
        }
        LOG.warn("Attempt to check areAllPrimaryKeyAttributesPopulated on object with no metadata: " + this.dataObject.getClass().getName());
        return true;
    }

    @Override
    public boolean areAnyPrimaryKeyAttributesPopulated() {
        if (this.metadata != null) {
            List<String> primaryKeyAttributeNames = this.metadata.getPrimaryKeyAttributeNames();
            if (primaryKeyAttributeNames != null) {
                for (String primaryKeyAttributeName : primaryKeyAttributeNames) {
                    Object propValue = this.getPropertyValue(primaryKeyAttributeName);
                    if (propValue instanceof String && StringUtils.isNotBlank((String)((String)propValue))) {
                        return true;
                    }
                    if (propValue == null) continue;
                    return true;
                }
            }
            return false;
        }
        LOG.warn("Attempt to check areAnyPrimaryKeyAttributesPopulated on object with no metadata: " + this.dataObject.getClass().getName());
        return true;
    }

    @Override
    public List<String> getUnpopulatedPrimaryKeyAttributeNames() {
        ArrayList<String> emptyKeys = new ArrayList<String>();
        if (this.metadata != null) {
            List<String> primaryKeyAttributeNames = this.metadata.getPrimaryKeyAttributeNames();
            if (primaryKeyAttributeNames != null) {
                for (String primaryKeyAttributeName : primaryKeyAttributeNames) {
                    Object propValue = this.getPropertyValue(primaryKeyAttributeName);
                    if (propValue != null && (!(propValue instanceof String) || !StringUtils.isBlank((String)((String)propValue)))) continue;
                    emptyKeys.add(primaryKeyAttributeName);
                }
            }
        } else {
            LOG.warn("Attempt to check getUnpopulatedPrimaryKeyAttributeNames on object with no metadata: " + this.dataObject.getClass().getName());
        }
        return emptyKeys;
    }

    @Override
    public boolean equalsByPrimaryKey(T object) {
        if (object == null) {
            return false;
        }
        DataObjectWrapper<T> wrap = this.dataObjectService.wrap(object);
        if (!this.getWrappedClass().isAssignableFrom(wrap.getWrappedClass())) {
            throw new IllegalArgumentException("The type of the given data object does not match the type of this data object. Given: " + String.valueOf(wrap.getWrappedClass()) + ", but expected: " + String.valueOf(this.getWrappedClass()));
        }
        Map<String, Object> localPks = this.getPrimaryKeyValues();
        Map<String, Object> givenPks = wrap.getPrimaryKeyValues();
        for (String localPk : localPks.keySet()) {
            Object localPkValue = localPks.get(localPk);
            if (localPkValue != null && localPkValue.equals(givenPks.get(localPk))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getForeignKeyValue(String relationshipName) {
        Object foreignKeyAttributeValue = this.getForeignKeyAttributeValue(relationshipName);
        if (foreignKeyAttributeValue != null) {
            return foreignKeyAttributeValue;
        }
        Object relationshipObject = this.getPropertyValue(relationshipName);
        if (relationshipObject == null) {
            return null;
        }
        return this.dataObjectService.wrap(relationshipObject).getPrimaryKeyValue();
    }

    @Override
    public Object getForeignKeyAttributeValue(String relationshipName) {
        Map<String, Object> attributeMap = this.getForeignKeyAttributeMap(relationshipName);
        if (attributeMap == null) {
            return null;
        }
        return this.asSingleKey(attributeMap);
    }

    public Map<String, Object> getForeignKeyAttributeMap(String relationshipName) {
        MetadataChild relationship = this.findAndValidateRelationship(relationshipName);
        List<DataObjectAttributeRelationship> attributeRelationships = relationship.getAttributeRelationships();
        if (!attributeRelationships.isEmpty()) {
            LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>();
            for (DataObjectAttributeRelationship attributeRelationship : attributeRelationships) {
                String parentAttributeName = attributeRelationship.getParentAttributeName();
                Object parentAttributeValue = null;
                try {
                    parentAttributeValue = this.getPropertyValue(parentAttributeName);
                }
                catch (BeansException beansException) {
                    // empty catch block
                }
                if (parentAttributeValue == null) {
                    return null;
                }
                String childAttributeName = attributeRelationship.getChildAttributeName();
                if (childAttributeName == null) continue;
                attributeMap.put(childAttributeName, parentAttributeValue);
            }
            return attributeMap;
        }
        return null;
    }

    private Object asSingleKey(Map<String, Object> keyValues) {
        if (keyValues.size() == 1) {
            return keyValues.values().iterator().next();
        }
        return new CompoundKey(keyValues);
    }

    @Override
    public Class<?> getPropertyTypeNullSafe(Class<?> objectType, String propertyName) {
        DataObjectMetadata objectMetadata = this.dataObjectService.getMetadataRepository().getMetadata(objectType);
        return this.getPropertyTypeChild(objectMetadata, propertyName);
    }

    private Class<?> getPropertyTypeChild(DataObjectMetadata objectMetadata, String propertyName) {
        if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)propertyName)) {
            Class<?> propertyType;
            String attributePrefix = StringUtils.substringBefore((String)propertyName, (String)".");
            String attributeName = StringUtils.substringAfter((String)propertyName, (String)".");
            if (StringUtils.isNotBlank((String)attributePrefix) && StringUtils.isNotBlank((String)attributeName) && objectMetadata != null && (propertyType = this.traverseRelationship(objectMetadata, attributePrefix, attributeName)) != null) {
                return propertyType;
            }
        }
        return this.getPropertyType(propertyName);
    }

    private Class<?> traverseRelationship(DataObjectMetadata objectMetadata, String attributePrefix, String attributeName) {
        DataObjectMetadata relatedObjectMetadata;
        DataObjectRelationship rd = objectMetadata.getRelationship(attributePrefix);
        if (rd != null && (relatedObjectMetadata = this.dataObjectService.getMetadataRepository().getMetadata(rd.getRelatedType())) != null) {
            if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)attributeName)) {
                return this.getPropertyTypeChild(relatedObjectMetadata, attributeName);
            }
            if (relatedObjectMetadata.getAttribute(attributeName) == null && relatedObjectMetadata.getRelationship(attributeName) != null) {
                DataObjectRelationship relationship = relatedObjectMetadata.getRelationship(attributeName);
                return relationship.getRelatedType();
            }
            return relatedObjectMetadata.getAttribute(attributeName).getDataType().getType();
        }
        return null;
    }

    @Override
    public void linkChanges(Set<String> changedPropertyPaths) {
        this.referenceLinker.linkChanges(this.getWrappedInstance(), changedPropertyPaths);
    }

    @Override
    public void linkForeignKeys(boolean onlyLinkReadOnly) {
        this.linkForeignKeysInternalWrapped(this, onlyLinkReadOnly, Sets.newHashSet());
    }

    protected void linkForeignKeysInternal(Object object, boolean onlyLinkReadOnly, Set<Object> linked) {
        if (object == null || linked.contains(object) || !this.dataObjectService.supports(object.getClass())) {
            return;
        }
        linked.add(object);
        DataObjectWrapper<Object> wrapped = this.dataObjectService.wrap(object);
        this.linkForeignKeysInternalWrapped(wrapped, onlyLinkReadOnly, linked);
    }

    protected void linkForeignKeysInternalWrapped(DataObjectWrapper<?> wrapped, boolean onlyLinkReadOnly, Set<Object> linked) {
        List<DataObjectRelationship> relationships = wrapped.getMetadata().getRelationships();
        for (DataObjectRelationship relationship : relationships) {
            String relationshipName = relationship.getName();
            Object relationshipValue = wrapped.getPropertyValue(relationshipName);
            if (relationship.isSavedWithParent()) {
                this.linkForeignKeysInternal(relationshipValue, onlyLinkReadOnly, linked);
            }
            this.linkForeignKeysInternal(wrapped, relationship, relationshipValue, onlyLinkReadOnly);
        }
        List<DataObjectCollection> collections = wrapped.getMetadata().getCollections();
        for (DataObjectCollection collection : collections) {
            Collection collectionValue;
            String relationshipName = collection.getName();
            if (!collection.isSavedWithParent() || (collectionValue = (Collection)wrapped.getPropertyValue(relationshipName)) == null) continue;
            for (Object object : collectionValue) {
                this.linkForeignKeysInternal(object, onlyLinkReadOnly, linked);
            }
        }
    }

    @Override
    public void fetchRelationship(String relationshipName) {
        this.fetchRelationship(relationshipName, true, true);
    }

    @Override
    public void fetchRelationship(String relationshipName, boolean useForeignKeyAttribute, boolean nullifyDanglingRelationship) {
        this.fetchRelationship(this.findAndValidateRelationship(relationshipName), useForeignKeyAttribute, nullifyDanglingRelationship);
    }

    protected void fetchRelationship(MetadataChild relationship, boolean useForeignKeyAttribute, boolean nullifyDanglingRelationship) {
        Class<?> relatedType = relationship.getRelatedType();
        if (!this.dataObjectService.supports(relatedType)) {
            LOG.warn("Encountered a related type that is not supported by DataObjectService, fetch relationship will do nothing: " + String.valueOf(relatedType));
            return;
        }
        if (useForeignKeyAttribute) {
            this.fetchRelationshipUsingAttributes(relationship, nullifyDanglingRelationship);
        } else {
            this.fetchRelationshipUsingIdentity(relationship, nullifyDanglingRelationship);
        }
    }

    protected void fetchRelationshipUsingAttributes(MetadataChild relationship, boolean nullifyDanglingRelationship) {
        Class<?> relatedType = relationship.getRelatedType();
        if (relationship.getAttributeRelationships().isEmpty()) {
            LOG.warn("Attempted to fetch a relationship using a foreign key attribute when one does not exist: " + relationship.getName());
        } else {
            List fetchedValue = null;
            if (relationship instanceof DataObjectRelationship) {
                Object foreignKey = this.getForeignKeyAttributeValue(relationship.getName());
                if (foreignKey != null) {
                    fetchedValue = (List)this.dataObjectService.find(relatedType, foreignKey);
                }
            } else if (relationship instanceof DataObjectCollection) {
                Map<String, Object> foreignKeyAttributeMap = this.getForeignKeyAttributeMap(relationship.getName());
                fetchedValue = this.dataObjectService.findMatching(relatedType, QueryByCriteria.Builder.andAttributes(foreignKeyAttributeMap).build()).getResults();
            }
            if (fetchedValue != null || nullifyDanglingRelationship) {
                this.setPropertyValue(relationship.getName(), fetchedValue);
            }
        }
    }

    protected void fetchRelationshipUsingIdentity(MetadataChild relationship, boolean nullifyDanglingRelationship) {
        Object propertyValue = this.getPropertyValue(relationship.getName());
        if (propertyValue != null) {
            if (!this.dataObjectService.supports(propertyValue.getClass())) {
                throw new IllegalArgumentException("Attempting to fetch an invalid relationship, must be aDataObjectRelationship when fetching without a foreign key");
            }
            DataObjectWrapper<Object> wrappedRelationship = this.dataObjectService.wrap(propertyValue);
            Map<String, Object> primaryKeyValues = wrappedRelationship.getPrimaryKeyValues();
            Object newPropertyValue = this.dataObjectService.find(wrappedRelationship.getWrappedClass(), new CompoundKey(primaryKeyValues));
            if (newPropertyValue != null || nullifyDanglingRelationship) {
                propertyValue = newPropertyValue;
                this.setPropertyValue(relationship.getName(), propertyValue);
            }
        }
        this.linkForeignKeysInternal(this, relationship, propertyValue, false);
        this.populateInverseRelationship(relationship, propertyValue);
    }

    @Override
    public void linkForeignKeys(String relationshipName, boolean onlyLinkReadOnly) {
        MetadataChild relationship = this.findAndValidateRelationship(relationshipName);
        Object propertyValue = this.getPropertyValue(relationshipName);
        this.linkForeignKeysInternal(this, relationship, propertyValue, onlyLinkReadOnly);
    }

    @Override
    public void materializeReferencedObjects(MaterializeOption ... options) {
        this.materializeReferencedObjectsToDepth(1, options);
    }

    @Override
    public void materializeReferencedObjectsToDepth(int maxDepth, MaterializeOption ... options) {
        boolean setInvalidRefsToNull = ArrayUtils.contains((Object[])options, (Object)MaterializeOption.NULL_INVALID_REFS);
        Collection<MetadataChild> matchingChildRelationships = this.getChildrenMatchingOptions(options);
        for (MetadataChild child : matchingChildRelationships) {
            Object childValue;
            this.fetchRelationship(child, true, setInvalidRefsToNull);
            if (maxDepth <= 1 || (childValue = this.getPropertyValue(child.getName())) == null) continue;
            if (!(childValue instanceof Collection)) {
                DataObjectWrapper<Object> childWrapper = this.dataObjectService.wrap(childValue);
                if (childWrapper.getMetadata() == null) continue;
                childWrapper.materializeReferencedObjectsToDepth(maxDepth - 1, options);
                continue;
            }
            for (Object collectionElement : (Collection)childValue) {
                DataObjectWrapper childWrapper = this.dataObjectService.wrap(collectionElement);
                if (childWrapper.getMetadata() == null) continue;
                childWrapper.materializeReferencedObjectsToDepth(maxDepth - 1, options);
            }
        }
    }

    public Collection<MetadataChild> getChildrenMatchingOptions(MaterializeOption ... options) {
        boolean includeCollections;
        ArrayList<MetadataChild> matchingChildren = new ArrayList<MetadataChild>();
        if (this.metadata == null) {
            return matchingChildren;
        }
        boolean materializeUpdatable = ArrayUtils.contains((Object[])options, (Object)MaterializeOption.UPDATE_UPDATABLE_REFS);
        boolean rematerializeEagerRefs = ArrayUtils.contains((Object[])options, (Object)MaterializeOption.INCLUDE_EAGER_REFS);
        boolean includeRelationships = ArrayUtils.contains((Object[])options, (Object)MaterializeOption.REFERENCES) || !ArrayUtils.contains((Object[])options, (Object)MaterializeOption.COLLECTIONS);
        boolean bl = includeCollections = ArrayUtils.contains((Object[])options, (Object)MaterializeOption.COLLECTIONS) || !ArrayUtils.contains((Object[])options, (Object)MaterializeOption.REFERENCES);
        if (includeRelationships) {
            for (DataObjectRelationship dataObjectRelationship : this.metadata.getRelationships()) {
                if (dataObjectRelationship.isSavedWithParent() && !materializeUpdatable || dataObjectRelationship.isLoadedAtParentLoadTime() && !rematerializeEagerRefs) continue;
                matchingChildren.add(dataObjectRelationship);
            }
        }
        if (includeCollections) {
            for (DataObjectCollection dataObjectCollection : this.metadata.getCollections()) {
                if (dataObjectCollection.isSavedWithParent() && !materializeUpdatable || dataObjectCollection.isLoadedAtParentLoadTime() && !rematerializeEagerRefs) continue;
                matchingChildren.add(dataObjectCollection);
            }
        }
        return matchingChildren;
    }

    protected void linkForeignKeysInternal(DataObjectWrapper<?> wrapped, MetadataChild relationship, Object relationshipValue, boolean onlyLinkReadOnly) {
        if (!relationship.getAttributeRelationships().isEmpty()) {
            DataObjectWrapper<Object> wrappedRelationship = null;
            if (relationshipValue != null) {
                wrappedRelationship = this.dataObjectService.wrap(relationshipValue);
            }
            for (DataObjectAttributeRelationship attributeRelationship : relationship.getAttributeRelationships()) {
                String parentAttributeName = attributeRelationship.getParentAttributeName();
                Object childAttributeValue = null;
                if (wrappedRelationship != null) {
                    childAttributeValue = wrappedRelationship.getPropertyValue(attributeRelationship.getChildAttributeName());
                }
                if (onlyLinkReadOnly) {
                    DataObjectAttribute attribute = wrapped.getMetadata().getAttribute(parentAttributeName);
                    if (!attribute.isReadOnly()) continue;
                    wrapped.setPropertyValue(parentAttributeName, childAttributeValue);
                    continue;
                }
                wrapped.setPropertyValue(parentAttributeName, childAttributeValue);
            }
        }
    }

    protected void populateInverseRelationship(MetadataChild relationship, Object propertyValue) {
        MetadataChild inverseRelationship;
        if (propertyValue != null && (inverseRelationship = relationship.getInverseRelationship()) != null) {
            DataObjectWrapper<Object> wrappedRelationship = this.dataObjectService.wrap(propertyValue);
            if (inverseRelationship instanceof DataObjectCollection) {
                DataObjectCollection collectionRelationship = (DataObjectCollection)inverseRelationship;
                String colRelName = inverseRelationship.getName();
                Collection collection = (Collection)wrappedRelationship.getPropertyValue(colRelName);
                if (collection == null) {
                    collection = CollectionFactory.createCollection((Class)wrappedRelationship.getPropertyType(colRelName), (int)1);
                    wrappedRelationship.setPropertyValue(colRelName, collection);
                }
                collection.add(this.getWrappedInstance());
            }
        }
    }

    private MetadataChild findAndValidateRelationship(String relationshipName) {
        if (StringUtils.isBlank((String)relationshipName)) {
            throw new IllegalArgumentException("The relationshipName must not be null or blank");
        }
        MetadataChild relationship = this.getMetadata().getRelationship(relationshipName);
        if (relationship == null && (relationship = this.getMetadata().getCollection(relationshipName)) == null) {
            throw new IllegalArgumentException("Failed to locate a valid relationship from " + String.valueOf(this.getWrappedClass()) + " with the given relationship name '" + relationshipName + "'");
        }
        return relationship;
    }
}

