/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.metadata;

/**
 * Sorting orders used for collection definitions and lookup generation.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public enum SortDirection {
	ASCENDING,
	DESCENDING,
	// These latter are Oracle options on table sorting. However, recent ANSI
	// standards have extended them as requiring to be understood by all databases.
	// (Though not all support the style of sorting.)
	ASCENDING_NULLS_FIRST,
	ASCENDING_NULLS_LAST,
	DESCENDING_NULLS_FIRST,
	DESCENDING_NULLS_LAST
}
