/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.maintainablexml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.common.delegate.DelegateMemberContract;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleMemberContract;
import org.kuali.rice.kim.api.role.RoleMemberQueryResults;
import org.kuali.rice.kim.api.role.RoleResponsibilityAction;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.framework.group.GroupEbo;
import org.kuali.rice.kim.framework.role.RoleEbo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

public class TestReviewRole
extends PersistableBusinessObjectBase
implements MutableInactivatable {
    protected static final String ORR_INQUIRY_TITLE_PROPERTY = "message.inquiry.org.review.role.title";
    protected static String INQUIRY_TITLE_VALUE = null;
    protected String organizationTypeCode = "99";
    private static final long serialVersionUID = 1L;
    public static final String REVIEW_ROLES_INDICATOR_FIELD_NAME = "reviewRolesIndicator";
    public static final String ROLE_NAME_FIELD_NAMESPACE_CODE = "roleMemberRoleNamespaceCode";
    public static final String ROLE_NAME_FIELD_NAME = "roleMemberRoleName";
    public static final String GROUP_NAME_FIELD_NAMESPACE_CODE = "groupMemberGroupNamespaceCode";
    public static final String GROUP_NAME_FIELD_NAME = "groupMemberGroupName";
    public static final String PRINCIPAL_NAME_FIELD_NAME = "principalMemberPrincipalName";
    public static final String DOC_TYPE_NAME_FIELD_NAME = "financialSystemDocumentTypeCode";
    public static final String DELEGATE_FIELD_NAME = "delegate";
    public static final String DELEGATION_TYPE_CODE = "delegationTypeCode";
    public static final String FROM_AMOUNT_FIELD_NAME = "fromAmount";
    public static final String TO_AMOUNT_FIELD_NAME = "toAmount";
    public static final String ACTION_TYPE_CODE_FIELD_NAME = "actionTypeCode";
    public static final String PRIORITY_CODE_FIELD_NAME = "priorityNumber";
    public static final String ACTION_POLICY_CODE_FIELD_NAME = "actionPolicyCode";
    public static final String FORCE_ACTION_FIELD_NAME = "forceAction";
    public static final String ACTIVE_FROM_DATE = "activeFromDate";
    public static final String ACTIVE_TO_DATE = "activeToDate";
    public static final String ORIGINAL_DELEGATION_MEMBER_ID_TO_MODIFY = "ODelMId";
    public static final String ORIGINAL_ROLE_MEMBER_ID_TO_MODIFY = "ORMId";
    public static final String NEW_DELEGATION_ID_KEY_VALUE = "New";
    protected String methodToCall;
    protected String kimTypeId;
    protected String orgReviewRoleMemberId;
    protected boolean edit;
    protected boolean copy;
    protected RoleEbo role;
    protected GroupEbo group;
    protected Person person;
    protected List<RoleResponsibilityAction> roleRspActions = new ArrayList<RoleResponsibilityAction>();
    protected String roleMemberRoleId;
    protected String roleMemberRoleNamespaceCode;
    protected String roleMemberRoleName;
    protected String groupMemberGroupId;
    protected String groupMemberGroupNamespaceCode;
    protected String groupMemberGroupName;
    protected String principalMemberPrincipalId;
    protected String principalMemberPrincipalName;
    protected String principalMemberName;
    protected String roleId;
    protected String namespaceCode;
    protected String roleName;
    protected String memberTypeCode;
    protected String delegationTypeCode;
    protected String delegationMemberId;
    protected String roleMemberId;
    protected String oDelMId;
    protected String oRMId;
    protected String financialSystemDocumentTypeCode;
    protected DocumentTypeEBO financialSystemDocumentType;
    protected List<String> roleNamesToConsider;
    protected String reviewRolesIndicator;
    protected String actionTypeCode;
    protected String priorityNumber;
    protected String actionPolicyCode;
    protected boolean forceAction;
    protected String chartOfAccountsCode;
    protected String organizationCode;
    protected KualiDecimal fromAmount;
    protected KualiDecimal toAmount;
    protected String overrideCode;
    protected boolean active = true;
    protected boolean delegate;
    protected Date activeFromDate;
    protected Date activeToDate;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public String getGroupMemberGroupId() {
        if (StringUtils.isBlank((String)this.groupMemberGroupId) && StringUtils.isNotBlank((String)this.groupMemberGroupNamespaceCode) && StringUtils.isNotBlank((String)this.groupMemberGroupName)) {
            this.getGroup();
        }
        return this.groupMemberGroupId;
    }

    public void setGroupMemberGroupId(String groupMemberGroupId) {
        this.groupMemberGroupId = groupMemberGroupId;
    }

    public String getGroupMemberGroupName() {
        return this.groupMemberGroupName;
    }

    public void setGroupMemberGroupName(String groupMemberGroupName) {
        this.groupMemberGroupName = groupMemberGroupName;
    }

    public String getGroupMemberGroupNamespaceCode() {
        return this.groupMemberGroupNamespaceCode;
    }

    public void setGroupMemberGroupNamespaceCode(String groupMemberGroupNamespaceCode) {
        this.groupMemberGroupNamespaceCode = groupMemberGroupNamespaceCode;
    }

    public String getPrincipalMemberPrincipalId() {
        if (StringUtils.isBlank((String)this.principalMemberPrincipalId) && StringUtils.isNotBlank((String)this.principalMemberPrincipalName)) {
            this.getPerson();
        }
        return this.principalMemberPrincipalId;
    }

    public void setPrincipalMemberPrincipalId(String principalMemberPrincipalId) {
        this.principalMemberPrincipalId = principalMemberPrincipalId;
    }

    public String getPrincipalMemberPrincipalName() {
        if (StringUtils.isBlank((String)this.principalMemberPrincipalName)) {
            this.getPerson();
        }
        return this.principalMemberPrincipalName;
    }

    public String getPrincipalMemberName() {
        if (StringUtils.isBlank((String)this.principalMemberName)) {
            this.getPerson();
        }
        return this.principalMemberName;
    }

    public void setPrincipalMemberPrincipalName(String principalMemberPrincipalName) {
        this.principalMemberPrincipalName = principalMemberPrincipalName;
    }

    public String getRoleMemberRoleId() {
        if (StringUtils.isBlank((String)this.roleMemberRoleId) && StringUtils.isNotBlank((String)this.roleMemberRoleNamespaceCode) && StringUtils.isNotBlank((String)this.roleMemberRoleName)) {
            this.getRole();
        }
        return this.roleMemberRoleId;
    }

    public void setRoleMemberRoleId(String roleMemberRoleId) {
        this.roleMemberRoleId = roleMemberRoleId;
    }

    public String getRoleMemberRoleName() {
        return this.roleMemberRoleName;
    }

    public void setRoleMemberRoleName(String roleMemberRoleName) {
        this.roleMemberRoleName = roleMemberRoleName;
    }

    public String getRoleMemberRoleNamespaceCode() {
        return this.roleMemberRoleNamespaceCode;
    }

    public void setRoleMemberRoleNamespaceCode(String roleMemberRoleNamespaceCode) {
        this.roleMemberRoleNamespaceCode = roleMemberRoleNamespaceCode;
    }

    public String getOverrideCode() {
        return this.overrideCode;
    }

    public void setOverrideCode(String overrideCode) {
        this.overrideCode = overrideCode;
    }

    public KualiDecimal getFromAmount() {
        return this.fromAmount;
    }

    public String getFromAmountStr() {
        return this.fromAmount == null ? null : this.fromAmount.toString();
    }

    public void setFromAmount(KualiDecimal fromAmount) {
        this.fromAmount = fromAmount;
    }

    public void setFromAmount(String fromAmount) {
        this.fromAmount = StringUtils.isNotEmpty((String)fromAmount) && NumberUtils.isNumber((String)fromAmount) ? new KualiDecimal(fromAmount) : null;
    }

    public KualiDecimal getToAmount() {
        return this.toAmount;
    }

    public String getToAmountStr() {
        return this.toAmount == null ? null : this.toAmount.toString();
    }

    public void setToAmount(KualiDecimal toAmount) {
        this.toAmount = toAmount;
    }

    public void setToAmount(String toAmount) {
        this.toAmount = StringUtils.isNotEmpty((String)toAmount) && NumberUtils.isNumber((String)toAmount) ? new KualiDecimal(toAmount) : null;
    }

    public Date getActiveFromDate() {
        return this.activeFromDate;
    }

    public void setActiveFromDate(Date activeFromDate) {
        this.activeFromDate = activeFromDate;
    }

    public Date getActiveToDate() {
        return this.activeToDate;
    }

    public void setActiveToDate(Date activeToDate) {
        this.activeToDate = activeToDate;
    }

    public String getOrgReviewRoleMemberId() {
        return this.orgReviewRoleMemberId;
    }

    public void setOrgReviewRoleMemberId(String orgReviewRoleMemberId) {
        this.orgReviewRoleMemberId = orgReviewRoleMemberId;
    }

    public void refresh() {
    }

    public String getFinancialSystemDocumentTypeCode() {
        return this.financialSystemDocumentTypeCode;
    }

    public void setFinancialSystemDocumentType(DocumentTypeEBO financialSystemDocumentType) {
        this.financialSystemDocumentType = financialSystemDocumentType;
    }

    public String getDelegationTypeCode() {
        return this.delegationTypeCode;
    }

    public String getDelegationTypeCodeDescription() {
        if (this.getDelegationType() != null) {
            return this.getDelegationType().getLabel();
        }
        return "";
    }

    public DelegationType getDelegationType() {
        return DelegationType.parseCode((String)this.delegationTypeCode);
    }

    public void setDelegationTypeCode(String delegationTypeCode) {
        this.delegationTypeCode = delegationTypeCode;
    }

    public String getMemberTypeCodeDescription() {
        return (String)KimConstants.KimUIConstants.KIM_MEMBER_TYPES_MAP.get(this.memberTypeCode);
    }

    public void setMemberTypeCode(String memberTypeCode) {
        this.memberTypeCode = memberTypeCode;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public String getOrganizationCode() {
        return this.organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public List<String> getRoleNamesToConsider() {
        if (this.roleNamesToConsider != null || this.getFinancialSystemDocumentTypeCode() != null) {
            // empty if block
        }
        return this.roleNamesToConsider;
    }

    public void setRoleNamesToConsider(List<String> narrowedDownRoleNames) {
        this.roleNamesToConsider = new ArrayList<String>(narrowedDownRoleNames);
    }

    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    public String getActionTypeCodeToDisplay() {
        if (this.roleRspActions == null || this.roleRspActions.isEmpty()) {
            return "";
        }
        return this.roleRspActions.get(0).getActionTypeCode();
    }

    public String getActionTypeCodeDescription() {
        ActionType at = ActionType.fromCode((String)this.getActionTypeCodeToDisplay(), (boolean)true);
        return at == null ? "" : at.getLabel();
    }

    public void setActionTypeCode(String actionTypeCode) {
        this.actionTypeCode = actionTypeCode;
    }

    public String getPriorityNumber() {
        return this.priorityNumber;
    }

    public String getPriorityNumberToDisplay() {
        if (this.roleRspActions == null || this.roleRspActions.isEmpty()) {
            return "";
        }
        return this.roleRspActions.get(0).getPriorityNumber() == null ? "" : this.roleRspActions.get(0).getPriorityNumber() + "";
    }

    public void setPriorityNumber(String priorityNumber) {
        this.priorityNumber = priorityNumber;
    }

    public String getActionPolicyCode() {
        return this.actionPolicyCode;
    }

    public void setActionPolicyCode(String actionPolicyCode) {
        this.actionPolicyCode = actionPolicyCode;
    }

    public boolean isForceAction() {
        return this.forceAction;
    }

    public void setForceAction(boolean forceAction) {
        this.forceAction = forceAction;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        Role roleInfo = KimApiServiceLocator.getRoleService().getRole(roleId);
        if (roleInfo != null) {
            this.setNamespaceCode(roleInfo.getNamespaceCode());
            this.setRoleName(roleInfo.getName());
            this.setKimTypeId(roleInfo.getKimTypeId());
        }
        this.roleId = roleId;
    }

    public String getReviewRolesIndicator() {
        return this.reviewRolesIndicator;
    }

    public void setReviewRolesIndicator(String reviewRolesIndicator) {
        this.reviewRolesIndicator = reviewRolesIndicator;
    }

    private void setReviewRolesIndicatorOnDocTypeChange(String reviewRolesIndicator) {
        this.reviewRolesIndicator = reviewRolesIndicator;
    }

    public boolean hasRole() {
        this.getRole();
        return StringUtils.isNotBlank((String)this.roleMemberRoleName);
    }

    public boolean hasGroup() {
        this.getGroup();
        return StringUtils.isNotBlank((String)this.groupMemberGroupName);
    }

    public boolean hasPrincipal() {
        this.getPerson();
        return StringUtils.isNotBlank((String)this.principalMemberPrincipalName);
    }

    public boolean hasAnyMember() {
        return this.hasRole() || this.hasGroup() || this.hasPrincipal();
    }

    public void setRoleMember(RoleMemberContract roleMember) {
        this.memberTypeCode = roleMember.getType().getCode();
        if (MemberType.ROLE.equals((Object)roleMember.getType())) {
            this.roleMemberRoleId = roleMember.getMemberId();
            this.roleMemberRoleNamespaceCode = roleMember.getMemberNamespaceCode();
            this.roleMemberRoleName = roleMember.getMemberName();
        } else if (MemberType.GROUP.equals((Object)roleMember.getType())) {
            this.groupMemberGroupId = roleMember.getMemberId();
            this.groupMemberGroupNamespaceCode = roleMember.getMemberNamespaceCode();
            this.groupMemberGroupName = roleMember.getMemberName();
        } else if (MemberType.PRINCIPAL.equals((Object)roleMember.getType())) {
            this.principalMemberPrincipalId = roleMember.getMemberId();
            this.principalMemberPrincipalName = roleMember.getMemberName();
        }
        if (roleMember.getActiveFromDate() != null) {
            this.setActiveFromDate(roleMember.getActiveFromDate().toDate());
        } else {
            this.setActiveFromDate(null);
        }
        if (roleMember.getActiveToDate() != null) {
            this.setActiveToDate(roleMember.getActiveToDate().toDate());
        } else {
            this.setActiveToDate(null);
        }
        this.setActive(roleMember.isActive());
        this.setRoleMemberId(roleMember.getId());
        this.setDelegate(false);
        this.setRoleId(roleMember.getRoleId());
        this.setRoleRspActions(KimApiServiceLocator.getRoleService().getRoleMemberResponsibilityActions(roleMember.getId()));
    }

    public void setDelegateMember(RoleMemberContract roleMember, DelegateMemberContract delegateMember) {
        if (roleMember == null) {
            roleMember = this.getRoleMemberFromKimRoleService(delegateMember.getRoleMemberId());
        }
        this.setRoleId(roleMember.getRoleId());
        this.memberTypeCode = delegateMember.getType().getCode();
        if (MemberType.ROLE.equals((Object)delegateMember.getType())) {
            this.roleMemberRoleId = delegateMember.getMemberId();
            this.getRole();
        } else if (MemberType.GROUP.equals((Object)delegateMember.getType())) {
            this.groupMemberGroupId = delegateMember.getMemberId();
            this.getGroup();
        } else if (MemberType.PRINCIPAL.equals((Object)delegateMember.getType())) {
            this.principalMemberPrincipalId = delegateMember.getMemberId();
            this.getPerson();
        }
        if (delegateMember.getActiveFromDate() != null) {
            this.setActiveFromDate(delegateMember.getActiveFromDate().toDate());
        }
        if (delegateMember.getActiveToDate() != null) {
            this.setActiveToDate(delegateMember.getActiveToDate().toDate());
        }
        this.setActive(delegateMember.isActive());
        this.setDelegate(true);
        this.setDelegationMemberId(delegateMember.getDelegationMemberId());
        this.setRoleMemberId(roleMember.getId());
    }

    protected RoleMember getRoleMemberFromKimRoleService(String roleMemberId) {
        RoleMemberQueryResults roleMembers = KimApiServiceLocator.getRoleService().findRoleMembers(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateUtils.convertMapToPredicate(Collections.singletonMap("id", roleMemberId))}));
        if (roleMembers == null || roleMembers.getResults() == null || roleMembers.getResults().isEmpty()) {
            throw new IllegalArgumentException("Unknown role member ID passed in - nothing returned from KIM RoleService: " + roleMemberId);
        }
        return (RoleMember)roleMembers.getResults().get(0);
    }

    public String getMemberId() {
        if (MemberType.ROLE.getCode().equals(this.memberTypeCode)) {
            return this.getRoleMemberRoleId();
        }
        if (MemberType.GROUP.getCode().equals(this.memberTypeCode)) {
            return this.getGroupMemberGroupId();
        }
        if (MemberType.PRINCIPAL.getCode().equals(this.memberTypeCode)) {
            return this.getPrincipalMemberPrincipalId();
        }
        return "";
    }

    public String getMemberName() {
        if (MemberType.ROLE.getCode().equals(this.memberTypeCode)) {
            return this.getRoleMemberRoleName();
        }
        if (MemberType.GROUP.getCode().equals(this.memberTypeCode)) {
            return this.getGroupMemberGroupName();
        }
        if (MemberType.PRINCIPAL.getCode().equals(this.memberTypeCode)) {
            return this.getPrincipalMemberName();
        }
        return "";
    }

    public String getMemberNamespaceCode() {
        if (MemberType.ROLE.getCode().equals(this.memberTypeCode)) {
            return this.getRoleMemberRoleNamespaceCode();
        }
        if (MemberType.GROUP.getCode().equals(this.memberTypeCode)) {
            return this.getGroupMemberGroupNamespaceCode();
        }
        if (MemberType.PRINCIPAL.getCode().equals(this.memberTypeCode)) {
            return "";
        }
        return "";
    }

    public String getMemberFieldName() {
        if (MemberType.ROLE.equals((Object)this.getMemberType())) {
            return ROLE_NAME_FIELD_NAME;
        }
        if (MemberType.GROUP.equals((Object)this.getMemberType())) {
            return GROUP_NAME_FIELD_NAME;
        }
        if (MemberType.PRINCIPAL.equals((Object)this.getMemberType())) {
            return PRINCIPAL_NAME_FIELD_NAME;
        }
        return null;
    }

    public String getMemberTypeCode() {
        return this.memberTypeCode;
    }

    public MemberType getMemberType() {
        if (StringUtils.isBlank((String)this.memberTypeCode)) {
            return null;
        }
        return MemberType.fromCode((String)this.memberTypeCode);
    }

    public GroupEbo getGroup() {
        return this.group;
    }

    public void setGroup(GroupEbo group) {
        this.group = group;
        if (group != null) {
            this.groupMemberGroupNamespaceCode = group.getNamespaceCode();
            this.groupMemberGroupName = group.getName();
            this.groupMemberGroupId = group.getId();
        } else {
            this.groupMemberGroupNamespaceCode = "";
            this.groupMemberGroupName = "";
            this.groupMemberGroupId = "";
        }
    }

    public Person getPerson() {
        if (!(!StringUtils.isNotEmpty((String)this.principalMemberPrincipalId) && !StringUtils.isNotEmpty((String)this.principalMemberPrincipalName) || this.person != null && StringUtils.equals((String)this.person.getPrincipalId(), (String)this.principalMemberPrincipalId))) {
            this.person = StringUtils.isNotEmpty((String)this.principalMemberPrincipalId) ? KimApiServiceLocator.getPersonService().getPerson(this.principalMemberPrincipalId) : (StringUtils.isNotEmpty((String)this.principalMemberPrincipalName) ? KimApiServiceLocator.getPersonService().getPersonByPrincipalName(this.principalMemberPrincipalName) : null);
            if (this.person != null) {
                this.principalMemberPrincipalId = this.person.getPrincipalId();
                this.principalMemberPrincipalName = this.person.getPrincipalName();
                this.principalMemberName = this.person.getName();
            } else {
                this.principalMemberPrincipalId = "";
                this.principalMemberName = "";
            }
        }
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
        if (person != null) {
            this.principalMemberPrincipalName = person.getPrincipalName();
            this.principalMemberPrincipalId = person.getPrincipalId();
            this.principalMemberName = person.getName();
        } else {
            this.principalMemberPrincipalId = "";
            this.principalMemberPrincipalName = "";
            this.principalMemberName = "";
        }
    }

    public RoleEbo getRole() {
        return this.role;
    }

    public void setRole(RoleEbo role) {
        this.role = role;
        if (role != null) {
            this.roleMemberRoleNamespaceCode = role.getNamespaceCode();
            this.roleMemberRoleName = role.getName();
            this.roleMemberRoleId = role.getId();
        } else {
            this.roleMemberRoleNamespaceCode = "";
            this.roleMemberRoleName = "";
            this.roleMemberRoleId = "";
        }
    }

    public boolean isCopy() {
        return this.copy || "copy".equalsIgnoreCase(this.methodToCall);
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public boolean isEdit() {
        return this.edit || "edit".equalsIgnoreCase(this.methodToCall);
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public String getODelMId() {
        return this.oDelMId;
    }

    public void setODelMId(String delMId) {
        this.oDelMId = delMId;
    }

    public String getORMId() {
        return this.oRMId;
    }

    public void setORMId(String id) {
        this.oRMId = id;
    }

    public String getDelegationMemberId() {
        return this.delegationMemberId;
    }

    public void setDelegationMemberId(String delegationMemberId) {
        this.delegationMemberId = delegationMemberId;
    }

    public String getRoleMemberId() {
        return this.roleMemberId;
    }

    public void setRoleMemberId(String roleMemberId) {
        this.roleMemberId = roleMemberId;
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public boolean isEditDelegation() {
        return this.isEdit() && this.isDelegate();
    }

    public boolean isEditRoleMember() {
        return this.isEdit() && !this.isDelegate();
    }

    public boolean isCopyDelegation() {
        return this.isCopy() && this.isDelegate();
    }

    public boolean isCopyRoleMember() {
        return this.isCopy() && !this.isDelegate();
    }

    public boolean isCreateDelegation() {
        return NEW_DELEGATION_ID_KEY_VALUE.equals(this.getODelMId()) || this.isEditDelegation() && StringUtils.isBlank((String)this.getDelegationMemberId());
    }

    public boolean isCreateRoleMember() {
        return StringUtils.isEmpty((String)this.methodToCall);
    }

    public String getOrganizationTypeCode() {
        return "99";
    }

    public void setOrganizationTypeCode(String organizationTypeCode) {
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
        this.setRoleNamesToConsider(Collections.singletonList(roleName));
    }

    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    public Long getVersionNumber() {
        return 1L;
    }

    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public void setKimTypeId(String kimTypeId) {
        this.kimTypeId = kimTypeId;
    }

    public List<RoleResponsibilityAction> getRoleRspActions() {
        if (this.roleRspActions == null) {
            this.roleRspActions = new ArrayList<RoleResponsibilityAction>(1);
        }
        return this.roleRspActions;
    }

    public void setRoleRspActions(List<RoleResponsibilityAction> roleRspActions) {
        this.roleRspActions = roleRspActions;
    }

    public String getOrgReviewRoleInquiryTitle() {
        if (INQUIRY_TITLE_VALUE == null) {
            // empty if block
        }
        return INQUIRY_TITLE_VALUE;
    }

    public void refreshNonUpdateableReferences() {
    }

    public void refreshReferenceObject(String referenceObjectName) {
    }
}

