/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.criteria;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.LookupCustomizer;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.criteria.CriteriaLookupDao;
import org.kuali.rice.krad.criteria.CriteriaLookupDaoJpa;
import org.kuali.rice.krad.criteria.CriteriaLookupDaoOjb;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;

public class CriteriaLookupDaoProxy
implements CriteriaLookupDao {
    CriteriaLookupDao criteriaLookupDaoOjb;
    CriteriaLookupDao criteriaLookupDaoJpa;
    private static KualiModuleService kualiModuleService;
    private static Map<String, CriteriaLookupDao> lookupDaoValues;

    public void setCriteriaLookupDaoJpa(CriteriaLookupDao lookupDaoJpa) {
        this.criteriaLookupDaoJpa = lookupDaoJpa;
    }

    public void setCriteriaLookupDaoOjb(CriteriaLookupDao lookupDaoOjb) {
        this.criteriaLookupDaoOjb = lookupDaoOjb;
    }

    private CriteriaLookupDao getDao(Class clazz) {
        ModuleService moduleService = CriteriaLookupDaoProxy.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService != null) {
            ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
            String dataSourceName = "";
            EntityManager entityManager = null;
            if (moduleConfig != null) {
                dataSourceName = moduleConfig.getDataSourceName();
                entityManager = moduleConfig.getEntityManager();
            }
            if (StringUtils.isNotEmpty((String)dataSourceName)) {
                if (lookupDaoValues.get(dataSourceName) != null) {
                    return lookupDaoValues.get(dataSourceName);
                }
                if (OrmUtils.isJpaAnnotated((Class)clazz) && OrmUtils.isJpaEnabled()) {
                    CriteriaLookupDaoJpa classSpecificLookupDaoJpa = new CriteriaLookupDaoJpa();
                    if (entityManager != null) {
                        classSpecificLookupDaoJpa.setEntityManager(entityManager);
                        lookupDaoValues.put(dataSourceName, classSpecificLookupDaoJpa);
                        return classSpecificLookupDaoJpa;
                    }
                    throw new ConfigurationException("EntityManager is null. EntityManager must be set in the Module Configuration bean in the appropriate spring beans xml. (see nested exception for details).");
                }
                CriteriaLookupDaoOjb classSpecificLookupDaoOjb = new CriteriaLookupDaoOjb();
                classSpecificLookupDaoOjb.setJcdAlias(dataSourceName);
                lookupDaoValues.put(dataSourceName, classSpecificLookupDaoOjb);
                return classSpecificLookupDaoOjb;
            }
        }
        return OrmUtils.isJpaAnnotated((Class)clazz) && OrmUtils.isJpaEnabled() ? this.criteriaLookupDaoJpa : this.criteriaLookupDaoOjb;
    }

    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, QueryByCriteria criteria) {
        return this.getDao(queryClass).lookup(queryClass, criteria);
    }

    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, QueryByCriteria criteria, LookupCustomizer<T> customizer) {
        return this.getDao(queryClass).lookup(queryClass, criteria, customizer);
    }

    private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    static {
        lookupDaoValues = Collections.synchronizedMap(new HashMap());
    }
}

