/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.datadictionary.BeanOverride;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryException;
import org.kuali.rice.krad.datadictionary.DataDictionaryIndex;
import org.kuali.rice.krad.datadictionary.DataDictionaryIndexMapper;
import org.kuali.rice.krad.datadictionary.DataDictionaryMapper;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.DefaultListableBeanFactory;
import org.kuali.rice.krad.datadictionary.DictionaryBeanFactoryPostProcessor;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.rice.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.parse.StringListConverter;
import org.kuali.rice.krad.datadictionary.parse.StringMapConverter;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryIndex;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.util.ComponentBeanPostProcessor;
import org.kuali.rice.krad.uif.util.UifBeanFactoryPostProcessor;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class DataDictionary {
    private static final Log LOG = LogFactory.getLog(DataDictionary.class);
    protected static boolean validateEBOs = true;
    protected DefaultListableBeanFactory ddBeans = new DefaultListableBeanFactory();
    protected XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.ddBeans);
    protected DataDictionaryIndex ddIndex = new DataDictionaryIndex(this.ddBeans);
    protected UifDictionaryIndex uifIndex = new UifDictionaryIndex(this.ddBeans);
    protected DataDictionaryMapper ddMapper = new DataDictionaryIndexMapper();
    protected Map<String, List<String>> moduleDictionaryFiles = new HashMap<String, List<String>>();
    protected List<String> moduleLoadOrder = new ArrayList<String>();
    protected ArrayList<String> beanValidationFiles = new ArrayList();
    public static PersistenceStructureService persistenceStructureService;
    private static Map<String, Map<String, PropertyDescriptor>> cache;

    public void parseDataDictionaryConfigurationFiles(boolean allowConcurrentValidation) {
        DataDictionary.setupProcessor(this.ddBeans);
        this.loadDictionaryBeans(this.ddBeans, this.moduleDictionaryFiles, this.ddIndex, this.beanValidationFiles);
        this.performDictionaryPostProcessing(allowConcurrentValidation);
    }

    public static void setupProcessor(DefaultListableBeanFactory beans) {
        try {
            BeanPostProcessor idPostProcessor = (BeanPostProcessor)ComponentBeanPostProcessor.class.newInstance();
            beans.addBeanPostProcessor(idPostProcessor);
            beans.setBeanExpressionResolver((BeanExpressionResolver)new StandardBeanExpressionResolver());
            GenericConversionService conversionService = new GenericConversionService();
            conversionService.addConverter((GenericConverter)new StringMapConverter());
            conversionService.addConverter((GenericConverter)new StringListConverter());
            beans.setConversionService((ConversionService)conversionService);
        }
        catch (Exception e1) {
            throw new DataDictionaryException("Cannot create component decorator post processor: " + e1.getMessage(), e1);
        }
    }

    public void loadDictionaryBeans(DefaultListableBeanFactory beans, Map<String, List<String>> moduleDictionaryFiles, DataDictionaryIndex index, ArrayList<String> validationFiles) {
        LOG.info((Object)"Starting DD XML File Load");
        ArrayList allBeanNames = new ArrayList();
        for (String namespaceCode : this.moduleLoadOrder) {
            List<String> moduleDictionaryLocations = moduleDictionaryFiles.get(namespaceCode);
            if (moduleDictionaryLocations == null) continue;
            XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beans);
            String[] configFileLocationsArray = new String[moduleDictionaryLocations.size()];
            configFileLocationsArray = moduleDictionaryLocations.toArray(configFileLocationsArray);
            for (int i = 0; i < configFileLocationsArray.length; ++i) {
                validationFiles.add(configFileLocationsArray[i]);
            }
            try {
                xmlReader.loadBeanDefinitions(configFileLocationsArray);
                List addedBeanNames = Arrays.asList(beans.getBeanDefinitionNames());
                addedBeanNames = ListUtils.removeAll(addedBeanNames, allBeanNames);
                index.addBeanNamesToNamespace(namespaceCode, addedBeanNames);
                allBeanNames.addAll(addedBeanNames);
            }
            catch (Exception e) {
                throw new DataDictionaryException("Error loading bean definitions: " + e.getLocalizedMessage());
            }
        }
        LOG.info((Object)"Completed DD XML File Load");
    }

    public void performDictionaryPostProcessing(boolean allowConcurrentValidation) {
        PropertyPlaceholderConfigurer propertyPlaceholderConfigurer = new PropertyPlaceholderConfigurer();
        propertyPlaceholderConfigurer.setProperties(ConfigContext.getCurrentContextConfig().getProperties());
        propertyPlaceholderConfigurer.postProcessBeanFactory((ConfigurableListableBeanFactory)this.ddBeans);
        DictionaryBeanFactoryPostProcessor dictionaryBeanPostProcessor = new DictionaryBeanFactoryPostProcessor(this, this.ddBeans);
        dictionaryBeanPostProcessor.postProcessBeanFactory();
        UifBeanFactoryPostProcessor factoryPostProcessor = new UifBeanFactoryPostProcessor();
        factoryPostProcessor.postProcessBeanFactory(this.ddBeans);
        if (allowConcurrentValidation) {
            Thread t = new Thread(this.ddIndex);
            t.start();
            Thread t2 = new Thread(this.uifIndex);
            t2.start();
        } else {
            this.ddIndex.run();
            this.uifIndex.run();
        }
    }

    public void validateDD(boolean validateEbos) {
        validateEBOs = validateEbos;
        Map<String, DataObjectEntry> doBeans = this.ddBeans.getBeansOfType(DataObjectEntry.class);
        for (DataObjectEntry entry : doBeans.values()) {
            entry.completeValidation();
        }
        Map<String, DocumentEntry> docBeans = this.ddBeans.getBeansOfType(DocumentEntry.class);
        for (DocumentEntry entry : docBeans.values()) {
            entry.completeValidation();
        }
    }

    public void validateDD() {
        this.validateDD(true);
    }

    public void addConfigFileLocation(String namespaceCode, String location) throws IOException {
        if (!this.moduleLoadOrder.contains(namespaceCode)) {
            this.moduleLoadOrder.add(namespaceCode);
        }
        this.indexSource(namespaceCode, location);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void indexSource(String namespaceCode, String sourceName) throws IOException {
        Resource resource;
        if (sourceName == null) {
            throw new DataDictionaryException("Source Name given is null");
        }
        if (!sourceName.endsWith(".xml")) {
            Resource resource2 = this.getFileResource(sourceName);
            if (!resource2.exists()) {
                LOG.warn((Object)("Could not find " + sourceName));
                throw new DataDictionaryException("DD Resource " + sourceName + " not found");
            }
            try {
                this.indexSource(namespaceCode, resource2.getFile());
                return;
            }
            catch (IOException e) {
                LOG.debug((Object)"Skipped existing resource without absolute file path");
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding sourceName " + sourceName + " "));
        }
        if (!(resource = this.getFileResource(sourceName)).exists()) {
            throw new DataDictionaryException("DD Resource " + sourceName + " not found");
        }
        this.addModuleDictionaryFile(namespaceCode, sourceName);
    }

    protected Resource getFileResource(String sourceName) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
        return resourceLoader.getResource(sourceName);
    }

    protected void indexSource(String namespaceCode, File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.indexSource(namespaceCode, file);
                continue;
            }
            if (file.getName().endsWith(".xml")) {
                this.addModuleDictionaryFile(namespaceCode, "file:" + file.getAbsolutePath());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipping non xml file " + file.getAbsolutePath() + " in DD load"));
        }
    }

    protected void addModuleDictionaryFile(String namespaceCode, String location) {
        List<String> moduleFileLocations = new ArrayList<String>();
        if (this.moduleDictionaryFiles.containsKey(namespaceCode)) {
            moduleFileLocations = this.moduleDictionaryFiles.get(namespaceCode);
        }
        moduleFileLocations.add(location);
        this.moduleDictionaryFiles.put(namespaceCode, moduleFileLocations);
    }

    public Map<String, List<String>> getModuleDictionaryFiles() {
        return this.moduleDictionaryFiles;
    }

    public void setModuleDictionaryFiles(Map<String, List<String>> moduleDictionaryFiles) {
        this.moduleDictionaryFiles = moduleDictionaryFiles;
    }

    public List<String> getModuleLoadOrder() {
        return this.moduleLoadOrder;
    }

    public void setModuleLoadOrder(List<String> moduleLoadOrder) {
        this.moduleLoadOrder = moduleLoadOrder;
    }

    public void setDataDictionaryMapper(DataDictionaryMapper mapper) {
        this.ddMapper = mapper;
    }

    @Deprecated
    public BusinessObjectEntry getBusinessObjectEntry(String className) {
        return this.ddMapper.getBusinessObjectEntry(this.ddIndex, className);
    }

    public DataObjectEntry getDataObjectEntry(String className) {
        return this.ddMapper.getDataObjectEntry(this.ddIndex, className);
    }

    public BusinessObjectEntry getBusinessObjectEntryForConcreteClass(String className) {
        return this.ddMapper.getBusinessObjectEntryForConcreteClass(this.ddIndex, className);
    }

    public List<String> getBusinessObjectClassNames() {
        return this.ddMapper.getBusinessObjectClassNames(this.ddIndex);
    }

    public Map<String, BusinessObjectEntry> getBusinessObjectEntries() {
        return this.ddMapper.getBusinessObjectEntries(this.ddIndex);
    }

    public DataDictionaryEntry getDictionaryObjectEntry(String className) {
        return this.ddMapper.getDictionaryObjectEntry(this.ddIndex, className);
    }

    public DocumentEntry getDocumentEntry(String documentTypeDDKey) {
        return this.ddMapper.getDocumentEntry(this.ddIndex, documentTypeDDKey);
    }

    public MaintenanceDocumentEntry getMaintenanceDocumentEntryForBusinessObjectClass(Class<?> businessObjectClass) {
        return this.ddMapper.getMaintenanceDocumentEntryForBusinessObjectClass(this.ddIndex, businessObjectClass);
    }

    public Map<String, DocumentEntry> getDocumentEntries() {
        return this.ddMapper.getDocumentEntries(this.ddIndex);
    }

    public View getViewById(String viewId) {
        return this.ddMapper.getViewById(this.uifIndex, viewId);
    }

    public View getImmutableViewById(String viewId) {
        return this.ddMapper.getImmutableViewById(this.uifIndex, viewId);
    }

    public View getViewByTypeIndex(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.getViewByTypeIndex(this.uifIndex, viewTypeName, indexKey);
    }

    public String getViewIdByTypeIndex(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.getViewIdByTypeIndex(this.uifIndex, viewTypeName, indexKey);
    }

    public boolean viewByTypeExist(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.viewByTypeExist(this.uifIndex, viewTypeName, indexKey);
    }

    public List<View> getViewsForType(UifConstants.ViewType viewTypeName) {
        return this.ddMapper.getViewsForType(this.uifIndex, viewTypeName);
    }

    public Object getDictionaryObject(String beanName) {
        return this.ddBeans.getBean(beanName);
    }

    public boolean containsDictionaryObject(String id) {
        return this.ddBeans.containsBean(id);
    }

    public PropertyValues getViewPropertiesById(String viewId) {
        return this.ddMapper.getViewPropertiesById(this.uifIndex, viewId);
    }

    public PropertyValues getViewPropertiesByType(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.getViewPropertiesByType(this.uifIndex, viewTypeName, indexKey);
    }

    public List<String> getBeanNamesForNamespace(String namespaceCode) {
        List<String> namespaceBeans = new ArrayList<String>();
        Map<String, List<String>> dictionaryBeansByNamespace = this.ddIndex.getDictionaryBeansByNamespace();
        if (dictionaryBeansByNamespace.containsKey(namespaceCode)) {
            namespaceBeans = dictionaryBeansByNamespace.get(namespaceCode);
        }
        return namespaceBeans;
    }

    public String getNamespaceForBeanDefinition(String beanName) {
        String beanNamespace = null;
        Map<String, List<String>> dictionaryBeansByNamespace = this.ddIndex.getDictionaryBeansByNamespace();
        for (Map.Entry<String, List<String>> moduleDefinitions : dictionaryBeansByNamespace.entrySet()) {
            List<String> namespaceBeans = moduleDefinitions.getValue();
            if (!namespaceBeans.contains(beanName)) continue;
            beanNamespace = moduleDefinitions.getKey();
            break;
        }
        return beanNamespace;
    }

    public static boolean isPropertyOf(Class targetClass, String propertyName) {
        if (targetClass == null) {
            throw new IllegalArgumentException("invalid (null) targetClass");
        }
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        PropertyDescriptor propertyDescriptor = DataDictionary.buildReadDescriptor(targetClass, propertyName);
        boolean isPropertyOf = propertyDescriptor != null;
        return isPropertyOf;
    }

    public static boolean isCollectionPropertyOf(Class targetClass, String propertyName) {
        Class<?> clazz;
        boolean isCollectionPropertyOf = false;
        PropertyDescriptor propertyDescriptor = DataDictionary.buildReadDescriptor(targetClass, propertyName);
        if (propertyDescriptor != null && (clazz = propertyDescriptor.getPropertyType()) != null && Collection.class.isAssignableFrom(clazz)) {
            isCollectionPropertyOf = true;
        }
        return isCollectionPropertyOf;
    }

    public static PersistenceStructureService getPersistenceStructureService() {
        if (persistenceStructureService == null) {
            persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return persistenceStructureService;
    }

    public static Class getAttributeClass(Class boClass, String attributeName) {
        if (!DataDictionary.isPropertyOf(boClass, attributeName)) {
            throw new AttributeValidationException("unable to find attribute '" + attributeName + "' in rootClass '" + boClass.getName() + "'");
        }
        if (boClass.isInterface()) {
            return DataDictionary.getAttributeClassWhenBOIsInterface(boClass, attributeName);
        }
        return DataDictionary.getAttributeClassWhenBOIsClass(boClass, attributeName);
    }

    private static Class getAttributeClassWhenBOIsClass(Class boClass, String attributeName) {
        Object boInstance;
        try {
            boInstance = boClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate Data Object: " + boClass, e);
        }
        try {
            return ObjectUtils.getPropertyType(boInstance, attributeName, DataDictionary.getPersistenceStructureService());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to determine property type for: " + boClass.getName() + "." + attributeName, e);
        }
    }

    private static Class getAttributeClassWhenBOIsInterface(Class boClass, String attributeName) {
        if (boClass == null) {
            throw new IllegalArgumentException("invalid (null) boClass");
        }
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        PropertyDescriptor propertyDescriptor = null;
        String[] intermediateProperties = attributeName.split("\\.");
        int lastLevel = intermediateProperties.length - 1;
        Class currentClass = boClass;
        for (int i = 0; i <= lastLevel; ++i) {
            Class propertyType;
            String currentPropertyName = intermediateProperties[i];
            propertyDescriptor = DataDictionary.buildSimpleReadDescriptor(currentClass, currentPropertyName);
            if (propertyDescriptor != null) {
                propertyType = propertyDescriptor.getPropertyType();
                if (propertyType.equals(PersistableBusinessObjectExtension.class)) {
                    propertyType = DataDictionary.getPersistenceStructureService().getBusinessObjectAttributeClass(currentClass, currentPropertyName);
                }
                if (Collection.class.isAssignableFrom(propertyType)) {
                    throw new AttributeValidationException("Can't determine the Class of Collection elements because when the business object is an (possibly ExternalizableBusinessObject) interface.");
                }
            } else {
                throw new AttributeValidationException("Can't find getter method of " + boClass.getName() + " for property " + attributeName);
            }
            currentClass = propertyType;
        }
        return currentClass;
    }

    public static Class getCollectionElementClass(Class boClass, String collectionName) {
        if (boClass == null) {
            throw new IllegalArgumentException("invalid (null) boClass");
        }
        if (StringUtils.isBlank((String)collectionName)) {
            throw new IllegalArgumentException("invalid (blank) collectionName");
        }
        PropertyDescriptor propertyDescriptor = null;
        String[] intermediateProperties = collectionName.split("\\.");
        Class currentClass = boClass;
        for (int i = 0; i < intermediateProperties.length; ++i) {
            String currentPropertyName = intermediateProperties[i];
            propertyDescriptor = DataDictionary.buildSimpleReadDescriptor(currentClass, currentPropertyName);
            if (propertyDescriptor == null) continue;
            Class<?> type = propertyDescriptor.getPropertyType();
            if (Collection.class.isAssignableFrom(type)) {
                if (DataDictionary.getPersistenceStructureService().isPersistable(currentClass)) {
                    Map collectionClasses = new HashMap();
                    collectionClasses = DataDictionary.getPersistenceStructureService().listCollectionObjectTypes(currentClass);
                    currentClass = (Class)collectionClasses.get(currentPropertyName);
                    continue;
                }
                throw new RuntimeException("Can't determine the Class of Collection elements because persistenceStructureService.isPersistable(" + currentClass.getName() + ") returns false.");
            }
            currentClass = propertyDescriptor.getPropertyType();
        }
        return currentClass;
    }

    public static PropertyDescriptor buildReadDescriptor(Class propertyClass, String propertyName) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("invalid (null) propertyClass");
        }
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        PropertyDescriptor propertyDescriptor = null;
        String[] intermediateProperties = propertyName.split("\\.");
        int lastLevel = intermediateProperties.length - 1;
        Class currentClass = propertyClass;
        for (int i = 0; i <= lastLevel; ++i) {
            String currentPropertyName = intermediateProperties[i];
            propertyDescriptor = DataDictionary.buildSimpleReadDescriptor(currentClass, currentPropertyName);
            if (i >= lastLevel || propertyDescriptor == null) continue;
            Class propertyType = propertyDescriptor.getPropertyType();
            if (propertyType.equals(PersistableBusinessObjectExtension.class)) {
                propertyType = DataDictionary.getPersistenceStructureService().getBusinessObjectAttributeClass(currentClass, currentPropertyName);
            }
            if (Collection.class.isAssignableFrom(propertyType)) {
                if (DataDictionary.getPersistenceStructureService().isPersistable(currentClass)) {
                    Map collectionClasses = new HashMap();
                    collectionClasses = DataDictionary.getPersistenceStructureService().listCollectionObjectTypes(currentClass);
                    currentClass = (Class)collectionClasses.get(currentPropertyName);
                    continue;
                }
                throw new RuntimeException("Can't determine the Class of Collection elements because persistenceStructureService.isPersistable(" + currentClass.getName() + ") returns false.");
            }
            currentClass = propertyType;
        }
        return propertyDescriptor;
    }

    public static PropertyDescriptor buildSimpleReadDescriptor(Class propertyClass, String propertyName) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("invalid (null) propertyClass");
        }
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        Object p = null;
        String propertyClassName = propertyClass.getName();
        Map<String, PropertyDescriptor> m = cache.get(propertyClassName);
        if (null != m && null != (p = m.get(propertyName))) {
            return p;
        }
        Object[] descriptors = PropertyUtils.getPropertyDescriptors((Class)propertyClass);
        if (ArrayUtils.isNotEmpty((Object[])descriptors)) {
            for (Object descriptor : descriptors) {
                if (!((FeatureDescriptor)descriptor).getName().equals(propertyName)) continue;
                p = descriptor;
            }
        }
        if (p != null) {
            if (m == null) {
                m = new TreeMap<String, PropertyDescriptor>();
                cache.put(propertyClassName, m);
            }
            m.put(propertyName, (PropertyDescriptor)p);
        }
        return p;
    }

    public Set<InactivationBlockingMetadata> getAllInactivationBlockingMetadatas(Class blockedClass) {
        return this.ddMapper.getAllInactivationBlockingMetadatas(this.ddIndex, blockedClass);
    }

    public void performBeanOverrides() {
        Collection<BeanOverride> beanOverrides = this.ddBeans.getBeansOfType(BeanOverride.class).values();
        if (beanOverrides.isEmpty()) {
            LOG.info((Object)"DataDictionary.performOverrides(): No beans to override");
        }
        for (BeanOverride beanOverride : beanOverrides) {
            Object bean = this.ddBeans.getBean(beanOverride.getBeanName());
            beanOverride.performOverride(bean);
            LOG.info((Object)("DataDictionary.performOverrides(): Performing override on bean: " + bean.toString()));
        }
    }

    static {
        cache = new TreeMap<String, Map<String, PropertyDescriptor>>();
    }
}

