/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.datadictionary.HelpDefinition;
import org.kuali.rice.krad.datadictionary.InactivationBlockingDefinition;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="dataObjectEntry-bean")
public class DataObjectEntry
extends DataDictionaryEntryBase
implements MustOccurConstrainable {
    protected String name;
    protected Class<?> dataObjectClass;
    protected String titleAttribute;
    protected String objectLabel;
    protected String objectDescription;
    protected List<String> primaryKeys;
    protected Class<? extends Exporter> exporterClass;
    protected List<MustOccurConstraint> mustOccurConstraints;
    protected List<String> groupByAttributesForEffectiveDating;
    protected HelpDefinition helpDefinition;
    protected boolean boNotesEnabled = false;
    protected List<InactivationBlockingDefinition> inactivationBlockingDefinitions;

    @Override
    public void completeValidation() {
        if (StringUtils.isBlank((String)this.getObjectLabel())) {
            throw new AttributeValidationException("Object label cannot be blank for class " + this.dataObjectClass.getName());
        }
        super.completeValidation();
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this.getClass().getSimpleName(), this.dataObjectClass.getSimpleName());
        if (StringUtils.isBlank((String)this.getObjectLabel())) {
            String[] currentValues = new String[]{"objectLabel = " + this.getObjectLabel()};
            tracer.createError("Object Label is not set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    public String getJstlKey() {
        if (this.dataObjectClass == null) {
            throw new IllegalStateException("cannot generate JSTL key: dataObjectClass is null");
        }
        return this.dataObjectClass != null ? this.dataObjectClass.getSimpleName() : this.dataObjectClass.getSimpleName();
    }

    @Override
    public String getFullClassName() {
        return this.dataObjectClass.getName();
    }

    @Override
    public Class<?> getEntryClass() {
        return this.dataObjectClass;
    }

    @BeanTagAttribute(name="dataObjectClass")
    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    @Override
    @BeanTagAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @BeanTagAttribute(name="objectLabel")
    public String getObjectLabel() {
        return this.objectLabel;
    }

    public void setObjectLabel(String objectLabel) {
        this.objectLabel = objectLabel;
    }

    @BeanTagAttribute(name="objectDescription")
    public String getObjectDescription() {
        return this.objectDescription;
    }

    public void setObjectDescription(String objectDescription) {
        this.objectDescription = objectDescription;
    }

    @BeanTagAttribute(name="helpDefintion", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public HelpDefinition getHelpDefinition() {
        return this.helpDefinition;
    }

    public void setHelpDefinition(HelpDefinition helpDefinition) {
        this.helpDefinition = helpDefinition;
    }

    public String toString() {
        return "DataObjectEntry for " + this.getDataObjectClass();
    }

    @Override
    @BeanTagAttribute(name="mustOccurConstraints", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    @BeanTagAttribute(name="titleAttribute")
    public String getTitleAttribute() {
        return this.titleAttribute;
    }

    public void setTitleAttribute(String titleAttribute) {
        this.titleAttribute = titleAttribute;
    }

    @BeanTagAttribute(name="primaryKeys", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    @BeanTagAttribute(name="exporterClass")
    public Class<? extends Exporter> getExporterClass() {
        return this.exporterClass;
    }

    public void setExporterClass(Class<? extends Exporter> exporterClass) {
        this.exporterClass = exporterClass;
    }

    @BeanTagAttribute(name="groupByAttributesForEffectiveDating", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getGroupByAttributesForEffectiveDating() {
        return this.groupByAttributesForEffectiveDating;
    }

    public void setGroupByAttributesForEffectiveDating(List<String> groupByAttributesForEffectiveDating) {
        this.groupByAttributesForEffectiveDating = groupByAttributesForEffectiveDating;
    }

    @BeanTagAttribute(name="boNotesEnabled")
    public boolean isBoNotesEnabled() {
        return this.boNotesEnabled;
    }

    public void setBoNotesEnabled(boolean boNotesEnabled) {
        this.boNotesEnabled = boNotesEnabled;
    }

    @BeanTagAttribute(name="inactivationBlockingDefinitions", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<InactivationBlockingDefinition> getInactivationBlockingDefinitions() {
        return this.inactivationBlockingDefinitions;
    }

    public void setInactivationBlockingDefinitions(List<InactivationBlockingDefinition> inactivationBlockingDefinitions) {
        this.inactivationBlockingDefinitions = inactivationBlockingDefinitions;
    }
}

