/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.mask;

import java.io.Serializable;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

@BeanTag(name="mask-bean")
public class Mask
implements Serializable {
    private static final long serialVersionUID = 4035984416568235531L;
    protected MaskFormatter maskFormatter;
    protected Class<? extends MaskFormatter> maskFormatterClass;

    public String maskValue(Object value) {
        if (this.maskFormatter == null) {
            if (this.maskFormatterClass != null) {
                try {
                    this.maskFormatter = this.maskFormatterClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create instance of mask formatter class: " + this.maskFormatterClass.getName());
                }
            } else {
                throw new RuntimeException("Mask formatter not set for secure field.");
            }
        }
        return this.maskFormatter.maskValue(value);
    }

    @BeanTagAttribute(name="maskFormater", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public MaskFormatter getMaskFormatter() {
        return this.maskFormatter;
    }

    public void setMaskFormatter(MaskFormatter maskFormatter) {
        this.maskFormatter = maskFormatter;
    }

    @BeanTagAttribute(name="maskFormatterClass", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Class<? extends MaskFormatter> getMaskFormatterClass() {
        return this.maskFormatterClass;
    }

    public void setMaskFormatterClass(Class<? extends MaskFormatter> maskFormatterClass) {
        this.maskFormatterClass = maskFormatterClass;
    }
}

