/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.parse;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttributeInfo;
import org.kuali.rice.krad.datadictionary.parse.BeanTagInfo;
import org.kuali.rice.krad.datadictionary.parse.CustomTagAnnotations;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CustomSchemaParser
extends AbstractSingleBeanDefinitionParser {
    private static final Log LOG = LogFactory.getLog(CustomSchemaParser.class);
    private static int beanNumber = 0;

    protected Class getBeanClass(Element bean) {
        Map<String, BeanTagInfo> beanType = null;
        try {
            beanType = CustomTagAnnotations.getBeanTags();
        }
        catch (Exception e) {
            LOG.error((Object)"Error retrieving bean tag information", (Throwable)e);
        }
        Class<?> beanTag = null;
        try {
            beanTag = beanType.get(bean.getLocalName()).getBeanClass();
        }
        catch (Exception e) {
            LOG.error((Object)"Error in retrieved bean tag information", (Throwable)e);
        }
        return beanTag;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder bean) {
        BeanTagInfo tagInfo;
        Map<String, Map<String, BeanTagAttributeInfo>> attributeProperties = CustomTagAnnotations.getAttributeProperties();
        Map<String, BeanTagAttributeInfo> entries = attributeProperties.get(element.getLocalName());
        if (entries == null) {
            LOG.error((Object)("Bean Tag not found " + element.getLocalName()));
        }
        if ((tagInfo = CustomTagAnnotations.getBeanTags().get(element.getLocalName())).getParent().compareTo("none") != 0) {
            bean.setParentName(tagInfo.getParent());
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.processSingleValue(attributes.item(i).getNodeName(), attributes.item(i).getNodeValue(), entries, bean);
        }
        ArrayList children = (ArrayList)DomUtils.getChildElements((Element)element);
        for (int i = 0; i < children.size(); ++i) {
            BeanTagAttribute.AttributeType type;
            String propertyName;
            String tag = ((Element)children.get(i)).getLocalName();
            BeanTagAttributeInfo info = entries.get(tag);
            if (((Element)children.get(i)).getTagName().equals("spring:property")) {
                BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
                delegate.parsePropertyElement((Element)children.get(i), (BeanDefinition)bean.getBeanDefinition());
                continue;
            }
            if (info == null) {
                propertyName = tag;
                type = this.findBeanType((Element)children.get(i));
            } else {
                propertyName = info.getName();
                type = info.getType();
            }
            ArrayList grandChildren = (ArrayList)DomUtils.getChildElements((Element)((Element)children.get(i)));
            if (type == BeanTagAttribute.AttributeType.SINGLEBEAN) {
                bean.addPropertyValue(propertyName, this.parseBean((Element)grandChildren.get(0), bean, parserContext));
                continue;
            }
            if (type == BeanTagAttribute.AttributeType.LISTBEAN) {
                bean.addPropertyValue(propertyName, (Object)this.parseList(grandChildren, (Element)children.get(i), bean, parserContext));
                continue;
            }
            if (type == BeanTagAttribute.AttributeType.LISTVALUE) {
                bean.addPropertyValue(propertyName, (Object)this.parseList(grandChildren, (Element)children.get(i), bean, parserContext));
                continue;
            }
            if (type == BeanTagAttribute.AttributeType.MAPVALUE) {
                bean.addPropertyValue(propertyName, (Object)this.parseMap(grandChildren, (Element)children.get(i), bean, parserContext));
                continue;
            }
            if (type == BeanTagAttribute.AttributeType.MAPBEAN) {
                bean.addPropertyValue(propertyName, (Object)this.parseMap(grandChildren, (Element)children.get(i), bean, parserContext));
                continue;
            }
            if (type == BeanTagAttribute.AttributeType.SETVALUE) {
                bean.addPropertyValue(propertyName, (Object)this.parseSet(grandChildren, (Element)children.get(i), bean, parserContext));
                continue;
            }
            if (type != BeanTagAttribute.AttributeType.SETBEAN) continue;
            bean.addPropertyValue(propertyName, (Object)this.parseSet(grandChildren, (Element)children.get(i), bean, parserContext));
        }
    }

    private void processSingleValue(String name, String value, Map<String, BeanTagAttributeInfo> entries, BeanDefinitionBuilder bean) {
        if (name.toLowerCase().compareTo("parent") == 0) {
            bean.setParentName(value);
        } else if (name.toLowerCase().compareTo("abstract") == 0) {
            bean.setAbstract(Boolean.valueOf(value).booleanValue());
        } else if (name.toLowerCase().compareTo("id") == 0) {
            if (value.contains("Demo-CollectionGrouping-Section1")) {
                System.out.println();
            }
        } else if (name.contains("-ref")) {
            bean.addPropertyValue(name.substring(0, name.length() - 4), (Object)new RuntimeBeanReference(value));
        } else {
            BeanTagAttributeInfo info = entries.get(name);
            String propertyName = info == null ? name : info.getName();
            bean.addPropertyValue(propertyName, (Object)value);
        }
    }

    private Object findKey(Element grandchild) {
        String key = grandchild.getAttribute("key");
        if (!key.isEmpty()) {
            return key;
        }
        Element keyTag = DomUtils.getChildElementByTagName((Element)grandchild, (String)"spring:key");
        if (DomUtils.getChildElements((Element)keyTag).size() == 0) {
            return keyTag.getTextContent();
        }
        return DomUtils.getChildElements((Element)keyTag).get(0);
    }

    private Object findValue(Element grandchild) {
        String value = grandchild.getAttribute("value");
        if (!value.isEmpty()) {
            return value;
        }
        Element valueTag = DomUtils.getChildElementByTagName((Element)grandchild, (String)"spring:value");
        if (DomUtils.getChildElements((Element)valueTag).size() == 0) {
            return valueTag.getTextContent();
        }
        return DomUtils.getChildElements((Element)valueTag).get(0);
    }

    private BeanTagAttribute.AttributeType findBeanType(Element tag) {
        int numberChildren = 0;
        String overrideType = tag.getAttribute("overrideBeanType");
        if (!StringUtils.isEmpty((String)overrideType)) {
            if (overrideType.toLowerCase().compareTo("singlebean") == 0) {
                return BeanTagAttribute.AttributeType.SINGLEBEAN;
            }
            if (overrideType.toLowerCase().compareTo("singlevalue") == 0) {
                return BeanTagAttribute.AttributeType.SINGLEVALUE;
            }
            if (overrideType.toLowerCase().compareTo("listbean") == 0) {
                return BeanTagAttribute.AttributeType.LISTBEAN;
            }
            if (overrideType.toLowerCase().compareTo("listvalue") == 0) {
                return BeanTagAttribute.AttributeType.LISTVALUE;
            }
            if (overrideType.toLowerCase().compareTo("mapbean") == 0) {
                return BeanTagAttribute.AttributeType.MAPBEAN;
            }
            if (overrideType.toLowerCase().compareTo("mapvalue") == 0) {
                return BeanTagAttribute.AttributeType.MAPVALUE;
            }
            if (overrideType.toLowerCase().compareTo("setbean") == 0) {
                return BeanTagAttribute.AttributeType.SETBEAN;
            }
            if (overrideType.toLowerCase().compareTo("setvalue") == 0) {
                return BeanTagAttribute.AttributeType.SETVALUE;
            }
        }
        if ((numberChildren = DomUtils.getChildElementsByTagName((Element)tag, (String)"spring:value").size()) > 0) {
            return BeanTagAttribute.AttributeType.LISTVALUE;
        }
        numberChildren = DomUtils.getChildElementsByTagName((Element)tag, (String)"spring:list").size();
        if (numberChildren > 0) {
            return BeanTagAttribute.AttributeType.LISTBEAN;
        }
        numberChildren = DomUtils.getChildElementsByTagName((Element)tag, (String)"spring:set").size();
        if (numberChildren > 0) {
            return BeanTagAttribute.AttributeType.SETBEAN;
        }
        numberChildren = DomUtils.getChildElementsByTagName((Element)tag, (String)"spring:entry").size();
        if (numberChildren > 0) {
            return BeanTagAttribute.AttributeType.MAPVALUE;
        }
        numberChildren = DomUtils.getChildElementsByTagName((Element)tag, (String)"spring:map").size();
        if (numberChildren > 0) {
            return BeanTagAttribute.AttributeType.MAPBEAN;
        }
        numberChildren = DomUtils.getChildElements((Element)tag).size();
        if (numberChildren > 1) {
            return BeanTagAttribute.AttributeType.LISTBEAN;
        }
        return BeanTagAttribute.AttributeType.SINGLEBEAN;
    }

    private Object parseBean(Element tag, BeanDefinitionBuilder parent, ParserContext parserContext) {
        if (tag.getNamespaceURI().compareTo("http://www.springframework.org/schema/beans") == 0) {
            return this.parseSpringBean(tag, parserContext);
        }
        return this.parseCustomBean(tag, parent, parserContext);
    }

    private Object parseSpringBean(Element tag, ParserContext parserContext) {
        String name;
        if (tag.getLocalName().compareTo("ref") == 0) {
            Element temp = tag.getOwnerDocument().createElement("bean");
            temp.setAttribute("parent", tag.getAttribute("bean"));
            tag = temp;
            return new RuntimeBeanReference(tag.getAttribute("parent"));
        }
        Document document = tag.getOwnerDocument();
        NamedNodeMap attributes = tag.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            name = attribute.getNodeName();
            if (!name.startsWith("p:")) continue;
            Element property = document.createElement("property");
            property.setAttribute("name", StringUtils.removeStart((String)name, (String)"p:"));
            property.setAttribute("value", attribute.getTextContent());
            if (tag.getFirstChild() != null) {
                tag.insertBefore(property, tag.getFirstChild());
                continue;
            }
            tag.appendChild(property);
        }
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        BeanDefinitionHolder bean = delegate.parseBeanDefinitionElement(tag);
        name = bean.getBeanDefinition().getParentName() + "$Customchild" + beanNumber;
        if (tag.getAttribute("id") != null && !StringUtils.isEmpty((String)tag.getAttribute("id"))) {
            name = tag.getAttribute("id");
        } else {
            ++beanNumber;
        }
        return new BeanDefinitionHolder(bean.getBeanDefinition(), name);
    }

    private Object parseCustomBean(Element tag, BeanDefinitionBuilder parent, ParserContext parserContext) {
        if (tag.getLocalName().compareTo("ref") == 0) {
            return new RuntimeBeanReference(tag.getAttribute("bean"));
        }
        BeanDefinition beanDefinition = parserContext.getDelegate().parseCustomElement(tag, (BeanDefinition)parent.getBeanDefinition());
        String name = beanDefinition.getParentName() + "$Customchild" + beanNumber;
        if (tag.getAttribute("id") != null && !StringUtils.isEmpty((String)tag.getAttribute("id"))) {
            name = tag.getAttribute("id");
        } else {
            ++beanNumber;
        }
        BeanDefinitionHolder bean = new BeanDefinitionHolder(beanDefinition, name);
        return bean;
    }

    private ManagedList parseList(ArrayList<Element> grandChildren, Element child, BeanDefinitionBuilder parent, ParserContext parserContext) {
        ArrayList<Object> listItems = new ArrayList<Object>();
        for (int i = 0; i < grandChildren.size(); ++i) {
            Element grandChild = grandChildren.get(i);
            if (grandChild.getTagName().compareTo("spring:value") == 0) {
                listItems.add(grandChild.getTextContent());
                continue;
            }
            listItems.add(this.parseBean(grandChild, parent, parserContext));
        }
        String merge = child.getAttribute("merge");
        ManagedList beans = new ManagedList(listItems.size());
        if (merge != null) {
            beans.setMergeEnabled(Boolean.valueOf(merge).booleanValue());
        }
        beans.addAll(listItems);
        return beans;
    }

    private ManagedSet parseSet(ArrayList<Element> grandChildren, Element child, BeanDefinitionBuilder parent, ParserContext parserContext) {
        ManagedSet setItems = new ManagedSet();
        for (int i = 0; i < grandChildren.size(); ++i) {
            Element grandChild = grandChildren.get(i);
            if (child.getTagName().compareTo("spring:value") == 0) {
                setItems.add((Object)grandChild.getTextContent());
                continue;
            }
            setItems.add(this.parseBean(grandChild, parent, parserContext));
        }
        String merge = child.getAttribute("merge");
        if (merge != null) {
            setItems.setMergeEnabled(Boolean.valueOf(merge).booleanValue());
        }
        return setItems;
    }

    private ManagedMap parseMap(ArrayList<Element> grandChildren, Element child, BeanDefinitionBuilder parent, ParserContext parserContext) {
        ManagedMap map = new ManagedMap();
        String merge = child.getAttribute("merge");
        for (int j = 0; j < grandChildren.size(); ++j) {
            Object key = this.findKey(grandChildren.get(j));
            Object value = this.findValue(grandChildren.get(j));
            map.put(key, value);
        }
        if (merge != null) {
            map.setMergeEnabled(Boolean.valueOf(merge).booleanValue());
        }
        return map;
    }
}

