/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validation.constraint.AllowCharacterConstraint;

@BeanTags(value={@BeanTag(name="alphaNumericPatternConstraint-bean", parent="AlphaNumericPatternConstraint"), @BeanTag(name="alphaNumericWithBasicPunc-bean", parent="AlphaNumericWithBasicPunc")})
public class AlphaNumericPatternConstraint
extends AllowCharacterConstraint {
    protected boolean lowerCase = false;
    protected boolean upperCase = false;

    @Override
    public String getMessageKey() {
        if (StringUtils.isEmpty((String)this.messageKey)) {
            StringBuilder key = new StringBuilder("");
            if (this.lowerCase) {
                return "validation.alphanumericPatternLowerCase";
            }
            if (this.upperCase) {
                return "validation.alphanumericPatternUpperCase";
            }
            return "validation.alphanumericPattern";
        }
        return this.messageKey;
    }

    @Override
    protected String getRegexString() {
        StringBuilder regexString = new StringBuilder("[A-Za-z0-9");
        if (this.lowerCase) {
            regexString = new StringBuilder("[a-z0-9");
        } else if (this.upperCase) {
            regexString = new StringBuilder("[A-Z0-9");
        }
        regexString.append(this.getAllowedCharacterRegex());
        regexString.append("]");
        return regexString.toString();
    }

    @BeanTagAttribute(name="lowerCase")
    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    @BeanTagAttribute(name="upperCase")
    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }
}

