/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidDataPatternConstraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

@BeanTag(name="fixedPointPatternConstraint-bean", parent="FixedPointPatternConstraint")
public class FixedPointPatternConstraint
extends ValidDataPatternConstraint {
    protected boolean allowNegative;
    protected int precision;
    protected int scale;

    @Override
    protected String getRegexString() {
        StringBuilder regex = new StringBuilder();
        if (this.getPrecision() < 0 || this.getScale() < 0 || this.getPrecision() - this.getScale() < 0) {
            throw new RuntimeException("Precision and scale cannot be negative AND scale cannot be greater than precision for FixedPointPatternConstraints!");
        }
        if (this.isAllowNegative()) {
            regex.append("-?");
        }
        regex.append("(");
        if (this.getPrecision() - this.getScale() > 0) {
            regex.append("[0-9]{0," + (this.getPrecision() - this.getScale()) + "}");
        }
        regex.append("\\.");
        regex.append("[0-9]{1," + this.getScale() + "}");
        if (this.getPrecision() - this.getScale() > 0) {
            regex.append("|[0-9]{1," + (this.getPrecision() - this.getScale()) + "}");
        }
        regex.append(")");
        return regex.toString();
    }

    @BeanTagAttribute(name="allowNegative")
    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    @BeanTagAttribute(name="precision")
    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @BeanTagAttribute(name="scale")
    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public List<String> getValidationMessageParams() {
        if (this.validationMessageParams == null) {
            this.validationMessageParams = new ArrayList();
            MessageService messageService = KRADServiceLocatorWeb.getMessageService();
            if (this.allowNegative) {
                this.validationMessageParams.add(messageService.getMessageText("validation.positiveOrNegative"));
            } else {
                this.validationMessageParams.add(messageService.getMessageText("validation.positive"));
            }
            this.validationMessageParams.add(Integer.toString(this.precision));
            this.validationMessageParams.add(Integer.toString(this.scale));
        }
        return this.validationMessageParams;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean("FixedPointPatternConstraint", this.getMessageKey());
        if (this.getPrecision() <= this.getScale()) {
            String[] currentValues = new String[]{"precision =" + this.getPrecision(), "scale = " + this.getScale()};
            tracer.createError("Precision should greater than Scale", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

