/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.exception.KualiException;
import org.kuali.rice.krad.exception.KualiExceptionIncident;

public class ExceptionIncident
implements KualiExceptionIncident {
    private static final Logger LOG = Logger.getLogger(ExceptionIncident.class);
    public static final String GENERIC_SYSTEM_ERROR_MESSAGE = "The system has encountered an error and is unable to complete your request at this time. Please provide more information regarding this error by completing this Incident Report.";
    protected Map<String, String> properties = new HashMap<String, String>();

    public ExceptionIncident(Exception exception, Map<String, String> properties) {
        String message;
        if (LOG.isTraceEnabled()) {
            message = String.format("ENTRY %s%n%s", exception == null ? "null" : exception.toString(), properties == null ? "" : properties.toString());
            LOG.trace((Object)message);
        }
        this.initialize(exception, properties);
        if (LOG.isTraceEnabled()) {
            message = String.format("EXIT %s", this.properties);
            LOG.trace((Object)message);
        }
    }

    public ExceptionIncident(Map<String, String> inputs) {
        this.properties = inputs;
    }

    private void initialize(Exception thrownException, Map<String, String> inputs) {
        String lm;
        if (LOG.isTraceEnabled()) {
            lm = String.format("ENTRY %s%n%s", thrownException.getMessage(), inputs == null ? "null" : inputs.toString());
            LOG.trace((Object)lm);
        }
        this.properties = new HashMap<String, String>();
        if (inputs != null) {
            this.properties.putAll(inputs);
        }
        this.properties.putAll(this.getExceptionInfo(thrownException));
        if (LOG.isTraceEnabled()) {
            lm = String.format("EXIT %s", this.properties.toString());
            LOG.trace((Object)lm);
        }
    }

    private Map<String, String> getExceptionInfo(Exception exception) {
        if (LOG.isTraceEnabled()) {
            String message = String.format("ENTRY", new Object[0]);
            LOG.trace((Object)message);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("exceptionReportSubject", this.createReportSubject(exception));
        map.put("exceptionMessage", exception.getMessage());
        map.put("displayMessage", this.getDisplayMessage(exception));
        map.put("stackTrace", this.getExceptionStackTrace(exception));
        if (exception instanceof KualiException) {
            boolean hideIncidentReport = ((KualiException)exception).isHideIncidentReport();
            map.put("exceptionHideIncidentReport", String.valueOf(hideIncidentReport));
        } else {
            map.put("exceptionHideIncidentReport", String.valueOf(false));
        }
        if (LOG.isTraceEnabled()) {
            String message = String.format("ENTRY %s", ((Object)map).toString());
            LOG.trace((Object)message);
        }
        return map;
    }

    private String createReportSubject(Exception exception) {
        if (LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY", new Object[0]);
            LOG.trace((Object)lm);
        }
        String app = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.id");
        String env = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("environment");
        String format = "%s:%s:%s:%s";
        String componentName = this.properties.get("componentName");
        String subject = String.format(format, app, env, componentName == null ? "" : componentName, exception.getMessage());
        if (LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", subject);
            LOG.trace((Object)lm);
        }
        return subject;
    }

    private String createReportMessage() {
        if (LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY", new Object[0]);
            LOG.trace((Object)lm);
        }
        String documentId = this.properties.get("documentId");
        String userEmail = this.properties.get("userEmail");
        String uuid = this.properties.get("principalName");
        String description = this.properties.get("description");
        String component = this.properties.get("componentName");
        String exceptionMessage = this.properties.get("exceptionMessage");
        String stackTrace = this.properties.get("stackTrace");
        String format = "Document Id: %s%nUser Email: %s%nPerson User Identifier: %s%nUser Input: %s%ncomponent: %s%nerrorMessage: %s%n%s%n";
        String message = String.format(format, documentId == null ? "" : documentId, userEmail == null ? "" : userEmail, uuid == null ? "" : uuid, description == null ? "" : description, component == null ? "" : component, exceptionMessage == null ? "" : exceptionMessage, stackTrace == null ? "" : stackTrace);
        if (LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", message);
            LOG.trace((Object)lm);
        }
        return message;
    }

    public String getExceptionStackTrace(Exception thrownException) {
        if (LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY", new Object[0]);
            LOG.trace((Object)lm);
        }
        StringWriter wrt = new StringWriter();
        PrintWriter pw = new PrintWriter(wrt);
        thrownException.printStackTrace(pw);
        pw.flush();
        String stackTrace = wrt.toString();
        try {
            wrt.close();
            pw.close();
        }
        catch (Exception e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", stackTrace);
            LOG.trace((Object)lm);
        }
        return stackTrace;
    }

    @Override
    public String getDisplayMessage(Exception exception) {
        if (LOG.isTraceEnabled()) {
            String message = String.format("ENTRY %s", exception.getMessage());
            LOG.trace((Object)message);
        }
        String displayMessage = exception instanceof KualiException ? exception.getMessage() : GENERIC_SYSTEM_ERROR_MESSAGE;
        if (LOG.isTraceEnabled()) {
            String message = String.format("EXIT %s", displayMessage);
            LOG.trace((Object)message);
        }
        return displayMessage;
    }

    @Override
    public String getProperty(String key) {
        String value;
        if (LOG.isTraceEnabled()) {
            String message = String.format("ENTRY %s", key);
            LOG.trace((Object)message);
        }
        if (key.equals("exceptionReportMessage") && !this.properties.containsKey(key)) {
            value = this.createReportMessage();
            this.properties.put("exceptionReportMessage", value);
        } else {
            value = this.properties.get(key);
        }
        if (LOG.isTraceEnabled()) {
            String message = String.format("EXIT %s", value);
            LOG.trace((Object)message);
        }
        return value;
    }

    @Override
    public Map<String, String> toProperties() {
        String message;
        if (LOG.isTraceEnabled()) {
            message = String.format("ENTRY", new Object[0]);
            LOG.trace((Object)message);
        }
        if (LOG.isTraceEnabled()) {
            message = String.format("EXIT %s", this.properties.toString());
            LOG.trace((Object)message);
        }
        return this.properties;
    }
}

