/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.krad.messages.Message;
import org.kuali.rice.krad.messages.MessageProvider;
import org.kuali.rice.krad.messages.MessageService;

public class MessageServiceImpl
implements MessageService {
    private static Logger LOG = Logger.getLogger(MessageServiceImpl.class);
    private List<MessageProvider> messageProviders;

    @Override
    public Message getMessage(String namespace, String component, String key) {
        return this.getMessage(namespace, component, key, this.getDefaultLocaleCode());
    }

    @Override
    public Message getMessage(String namespace, String component, String key, String locale) {
        MessageProvider provider;
        Message message = null;
        if (StringUtils.isBlank((String)namespace)) {
            namespace = "KUALI";
        }
        if (StringUtils.isBlank((String)component)) {
            component = "All";
        }
        if (StringUtils.isBlank((String)locale)) {
            locale = this.getDefaultLocaleCode();
        }
        Iterator<MessageProvider> i$ = this.messageProviders.iterator();
        while (i$.hasNext() && (message = (provider = i$.next()).getMessage(namespace, component, key, locale)) == null) {
        }
        return message;
    }

    @Override
    public String getMessageText(String namespace, String component, String key) {
        return this.getMessageText(namespace, component, key, this.getDefaultLocaleCode());
    }

    @Override
    public String getMessageText(String namespace, String component, String key, String locale) {
        Message message = this.getMessage(namespace, component, key, locale);
        if (message != null) {
            return message.getText();
        }
        return null;
    }

    @Override
    public String getMessageText(String key) {
        return this.getMessageText(key, this.getDefaultLocaleCode());
    }

    @Override
    public String getMessageText(String key, String locale) {
        Message message = this.getMessage(null, null, key, locale);
        if (message != null) {
            return message.getText();
        }
        return null;
    }

    @Override
    public Collection<Message> getAllMessagesForComponent(String namespace, String component) {
        return this.getAllMessagesForComponent(namespace, component, this.getDefaultLocaleCode());
    }

    @Override
    public Collection<Message> getAllMessagesForComponent(String namespace, String component, String locale) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (StringUtils.isBlank((String)locale)) {
            locale = this.getDefaultLocaleCode();
        }
        for (MessageProvider provider : this.messageProviders) {
            Collection<Message> providerMessages = provider.getAllMessagesForComponent(namespace, component, locale);
            this.mergeMessages(messages, providerMessages);
        }
        return messages;
    }

    protected void mergeMessages(Collection<Message> messages, Collection<Message> messagesToMerge) {
        for (Message message : messagesToMerge) {
            if (messages.contains((Object)message)) continue;
            messages.add(message);
        }
    }

    protected String getDefaultLocaleCode() {
        String localeCode = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-NS", "All", "DEFAULT_LOCALE_CODE");
        if (StringUtils.isBlank((String)localeCode)) {
            localeCode = "en-US";
        }
        return localeCode;
    }

    protected List<MessageProvider> getMessageProviders() {
        return this.messageProviders;
    }

    public void setMessageProviders(List<MessageProvider> messageProviders) {
        this.messageProviders = messageProviders;
    }
}

