/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.util.CloneUtils;

@BeanTags(value={@BeanTag(name="propertyReplacer-bean", parent="Uif-ConditionalBeanPropertyReplacer"), @BeanTag(name="conditionalBeanPropertyReplacer-bean", parent="Uif-ConditionalBeanPropertyReplacer")})
public class PropertyReplacer
extends UifDictionaryBeanBase
implements Serializable {
    private static final long serialVersionUID = -8405429643299461398L;
    private String propertyName;
    @KeepExpression
    private String condition;
    private Object replacement;

    public List<Component> getNestedComponents() {
        ArrayList<Component> nestedComponents;
        block3: {
            block4: {
                block2: {
                    nestedComponents = new ArrayList<Component>();
                    if (!(this.replacement instanceof Component)) break block2;
                    nestedComponents.add((Component)this.replacement);
                    break block3;
                }
                if (!(this.replacement instanceof List)) break block4;
                for (Object replacementItem : (List)this.replacement) {
                    if (!(replacementItem instanceof Component)) continue;
                    nestedComponents.add((Component)replacementItem);
                }
                break block3;
            }
            if (!(this.replacement instanceof Map)) break block3;
            for (Object replacementItem : ((Map)this.replacement).values()) {
                if (!(replacementItem instanceof Component)) continue;
                nestedComponents.add((Component)replacementItem);
            }
        }
        return nestedComponents;
    }

    @BeanTagAttribute(name="propertyName")
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @BeanTagAttribute(name="condition")
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @BeanTagAttribute(name="replacement", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Object getReplacement() {
        return this.replacement;
    }

    public void setReplacement(Object replacement) {
        this.replacement = replacement;
    }

    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean("PropertyReplacer", this.getPropertyName());
        if (this.getPropertyName() == null || this.getCondition() == null || this.getReplacement() == null) {
            currentValues = new String[]{"propertyName =" + this.getPropertyName(), "condition =" + this.getCondition(), "replacement =" + this.getReplacement()};
            tracer.createWarning("PropertyName, condition and replacement should be set", currentValues);
        }
        if (!Validator.validateSpringEL(this.getCondition())) {
            currentValues = new String[]{"condition =" + this.getCondition()};
            tracer.createError("Invalid Spring Expression Language", currentValues);
        }
    }

    @Override
    public <T> T copy() {
        T copiedClass = null;
        try {
            copiedClass = (T)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        this.copyProperties(copiedClass);
        return copiedClass;
    }

    @Override
    protected <T> void copyProperties(T propertyReplacer) {
        super.copyProperties(propertyReplacer);
        PropertyReplacer propertyReplacerCopy = (PropertyReplacer)propertyReplacer;
        propertyReplacerCopy.setCondition(this.condition);
        propertyReplacerCopy.setPropertyName(this.propertyName);
        if (this.replacement != null) {
            Object replacementCopy = null;
            replacementCopy = this.replacement instanceof Component ? (Object)((Component)this.replacement).copy() : (this.replacement instanceof LayoutManager ? ((LayoutManager)this.replacement).copy() : CloneUtils.deepClone(this.replacement));
            propertyReplacerCopy.setReplacement(replacementCopy);
        }
    }
}

