/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.ClientSideState;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.ActiveCollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionGroupBuilder;
import org.kuali.rice.krad.uif.container.CollectionGroupSecurity;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.QuickFinder;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="collectionGroup-bean", parent="Uif-CollectionGroupBase"), @BeanTag(name="stackedCollectionGroup-bean", parent="Uif-StackedCollectionGroup"), @BeanTag(name="stackedCollectionSection-bean", parent="Uif-StackedCollectionSection"), @BeanTag(name="stackedCollectionSubSection-bean", parent="Uif-StackedCollectionSubSection"), @BeanTag(name="stackedSubCollection-withinSection-bean", parent="Uif-StackedSubCollection-WithinSection"), @BeanTag(name="stackedSubCollection-withinSubSection-bean", parent="Uif-StackedSubCollection-WithinSubSection"), @BeanTag(name="disclosure-stackedCollectionSection-bean", parent="Uif-Disclosure-StackedCollectionSection"), @BeanTag(name="disclosure-stackedCollectionSubSection-bean", parent="Uif-Disclosure-StackedCollectionSubSection"), @BeanTag(name="disclosure-stackedSubCollection-withinSection-bean", parent="Uif-Disclosure-StackedSubCollection-WithinSection"), @BeanTag(name="disclosure-stackedSubCollection-withinSubSection-bean", parent="Uif-Disclosure-StackedSubCollection-WithinSubSection"), @BeanTag(name="tableCollectionGroup-bean", parent="Uif-TableCollectionGroup"), @BeanTag(name="tableCollectionSection-bean", parent="Uif-TableCollectionSection"), @BeanTag(name="tableCollectionSubSection-bean", parent="Uif-TableCollectionSubSection"), @BeanTag(name="tableSubCollection-withinSection-bean", parent="Uif-TableSubCollection-WithinSection"), @BeanTag(name="tableSubCollection-withinSubSection-bean", parent="Uif-TableSubCollection-WithinSubSection"), @BeanTag(name="disclosure-tableCollectionSection-bean", parent="Uif-Disclosure-TableCollectionSection"), @BeanTag(name="disclosure-tableCollectionSubSection-bean", parent="Uif-Disclosure-TableCollectionSubSection"), @BeanTag(name="disclosure-tableSubCollection-withinSection-bean", parent="Uif-Disclosure-TableSubCollection-WithinSection"), @BeanTag(name="disclosure-tableSubCollection-withinSubSection-bean", parent="Uif-Disclosure-TableSubCollection-WithinSubSection"), @BeanTag(name="listCollectionGroup-bean", parent="Uif-ListCollectionGroup"), @BeanTag(name="listCollectionSection-bean", parent="Uif-ListCollectionSection"), @BeanTag(name="listCollectionSubSection-bean", parent="Uif-ListCollectionSubSection"), @BeanTag(name="documentNotesSection-bean", parent="Uif-DocumentNotesSection"), @BeanTag(name="lookupResultsCollectionSection-bean", parent="Uif-LookupResultsCollectionSection"), @BeanTag(name="maintenanceStackedCollectionSection-bean", parent="Uif-MaintenanceStackedCollectionSection"), @BeanTag(name="maintenanceStackedSubCollection-withinSection-bean", parent="Uif-MaintenanceStackedSubCollection-WithinSection"), @BeanTag(name="maintenanceTableCollectionSection-bean", parent="Uif-MaintenanceTableCollectionSection"), @BeanTag(name="maintenanceTableSubCollection-withinSection-bean", parent="Uif-MaintenanceTableSubCollection-withinSection")})
public class CollectionGroup
extends Group
implements DataBinding {
    private static final long serialVersionUID = -6496712566071542452L;
    private Class<?> collectionObjectClass;
    private String propertyName;
    private BindingInfo bindingInfo;
    private boolean renderAddLine = true;
    private String addLinePropertyName;
    private BindingInfo addLineBindingInfo;
    private Message addLineLabel;
    private List<? extends Component> addLineItems;
    private List<Action> addLineActions;
    private boolean renderLineActions = true;
    private List<Action> lineActions;
    private boolean includeLineSelectionField;
    private String lineSelectPropertyName;
    private QuickFinder collectionLookup;
    private boolean renderInactiveToggleButton = true;
    @ClientSideState(variableName="inactive")
    private boolean showInactiveLines;
    private CollectionFilter activeCollectionFilter;
    private List<CollectionFilter> filters = Collections.emptyList();
    private List<CollectionGroup> subCollections;
    private String subCollectionSuffix;
    private CollectionGroupBuilder collectionGroupBuilder;
    private int displayCollectionSize = -1;
    private boolean highlightNewItems = true;
    private boolean highlightAddItem = true;
    private String newItemsCssClass;
    private String addItemCssClass;
    private boolean renderAddBlankLineButton;
    private Action addBlankLineAction;
    private String addLinePlacement = "TOP";
    private boolean renderSaveLineActions;
    private boolean addViaLightBox;
    private Action addViaLightBoxAction;
    private boolean useServerPaging = false;
    private int pageSize;
    private int displayStart = -1;
    private int displayLength = -1;
    private int filteredCollectionSize = -1;
    private List<String> totalColumns;

    public CollectionGroup() {
        this.lineActions = Collections.emptyList();
        this.addLineItems = Collections.emptyList();
        this.addLineActions = Collections.emptyList();
        this.subCollections = Collections.emptyList();
    }

    @Override
    public void performInitialization(View view, Object model) {
        DataField field;
        this.setFieldBindingObjectPath(this.getBindingInfo().getBindingObjectPath());
        super.performInitialization(view, model);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(view, this.getPropertyName());
        }
        if (this.addLineBindingInfo != null && StringUtils.isNotBlank((String)this.addLinePropertyName)) {
            this.addLineBindingInfo.setDefaults(view, this.getPropertyName());
            this.addLineBindingInfo.setBindingName(this.addLinePropertyName);
            if (StringUtils.isNotBlank((String)this.getFieldBindByNamePrefix())) {
                this.addLineBindingInfo.setBindByNamePrefix(this.getFieldBindByNamePrefix());
            }
        }
        for (Component component : this.getItems()) {
            if (!(component instanceof DataField) || !StringUtils.isBlank((String)(field = (DataField)component).getDictionaryObjectEntry())) continue;
            field.setDictionaryObjectEntry(this.collectionObjectClass.getName());
        }
        if (this.addLineItems == null || this.addLineItems.isEmpty()) {
            this.addLineItems = this.getItems();
        } else {
            for (Component component : this.addLineItems) {
                if (!(component instanceof DataField) || !StringUtils.isBlank((String)(field = (DataField)component).getDictionaryObjectEntry())) continue;
                field.setDictionaryObjectEntry(this.collectionObjectClass.getName());
            }
        }
        if (this.activeCollectionFilter == null) {
            this.activeCollectionFilter = new ActiveCollectionFilter();
        }
        String collectionPath = "";
        if (StringUtils.isNotBlank((String)this.getBindingInfo().getCollectionPath())) {
            collectionPath = collectionPath + this.getBindingInfo().getCollectionPath() + ".";
        }
        if (StringUtils.isNotBlank((String)this.getBindingInfo().getBindByNamePrefix())) {
            collectionPath = collectionPath + this.getBindingInfo().getBindByNamePrefix() + ".";
        }
        collectionPath = collectionPath + this.getBindingInfo().getBindingName();
        List<DataField> list = ComponentUtils.getComponentsOfTypeDeep(this.getItems(), DataField.class);
        for (DataField collectionField : list) {
            collectionField.getBindingInfo().setCollectionPath(collectionPath);
        }
        List<DataField> addLineCollectionFields = ComponentUtils.getComponentsOfTypeDeep(this.addLineItems, DataField.class);
        for (DataField collectionField : addLineCollectionFields) {
            collectionField.getBindingInfo().setCollectionPath(collectionPath);
        }
        for (CollectionGroup collectionGroup : this.getSubCollections()) {
            collectionGroup.getBindingInfo().setCollectionPath(collectionPath);
        }
        if (!view.getObjectPathToConcreteClassMapping().containsKey(collectionPath)) {
            view.getObjectPathToConcreteClassMapping().put(collectionPath, this.getCollectionObjectClass());
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        Object displayStart;
        super.performApplyModel(view, model, parent);
        if (model instanceof UifFormBase && this.isUseServerPaging() && (displayStart = ((UifFormBase)model).getExtensionData().get(this.getId() + "#displayStart")) != null) {
            this.setDisplayStart((Integer)displayStart);
        }
        if (this.renderAddBlankLineButton) {
            if (this.addBlankLineAction == null) {
                this.addBlankLineAction = (Action)ComponentFactory.getNewComponentInstance("Uif-AddBlankLineAction");
                view.assignComponentIds(this.addBlankLineAction);
            }
            if (this.addLinePlacement.equals(UifConstants.Position.BOTTOM.name())) {
                this.addBlankLineAction.setOnClickScript("writeCurrentPageToSession(this, 'last');");
            } else {
                this.addBlankLineAction.setOnClickScript("writeCurrentPageToSession(this, 'first');");
            }
        } else if (this.addViaLightBox) {
            if (this.addViaLightBoxAction == null) {
                this.addViaLightBoxAction = (Action)ComponentFactory.getNewComponentInstance("Uif-AddViaLightBoxAction");
                view.assignComponentIds(this.addViaLightBoxAction);
            }
            if (this.addLinePlacement.equals(UifConstants.Position.BOTTOM.name())) {
                this.addViaLightBoxAction.setOnClickScript("writeCurrentPageToSession(this, 'last');");
            } else {
                this.addViaLightBoxAction.setOnClickScript("writeCurrentPageToSession(this, 'first');");
            }
        }
        this.pushCollectionGroupToReference();
        if (this.isRender()) {
            this.getCollectionGroupBuilder().build(view, model, this);
        }
        this.pushCollectionGroupToReference();
    }

    protected void pushCollectionGroupToReference() {
        List<Component> components = this.getComponentsForLifecycle();
        components.addAll(this.getComponentPrototypes());
        ComponentUtils.pushObjectToContext(components, "collectionGroup", (Object)this);
        List<Action> actions = ComponentUtils.getComponentsOfTypeDeep(components, Action.class);
        for (Action action : actions) {
            action.addActionParameter("selectedCollectionPath", this.getBindingInfo().getBindingPath());
        }
    }

    public void initializeNewCollectionLine(View view, Object model, CollectionGroup collectionGroup, boolean clearExistingLine) {
        this.getCollectionGroupBuilder().initializeNewCollectionLine(view, model, collectionGroup, clearExistingLine);
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.addLineLabel);
        components.add(this.collectionLookup);
        components.add(this.addBlankLineAction);
        components.add(this.addViaLightBoxAction);
        for (Component component : this.getItems()) {
            if (!components.contains(component)) continue;
            components.remove(component);
        }
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        components.addAll(this.lineActions);
        components.addAll(this.addLineActions);
        components.addAll(this.getItems());
        components.addAll(this.getSubCollections());
        if (this.addLineItems != null) {
            for (Component component : this.addLineItems) {
                if (components.contains(component)) continue;
                components.add(component);
            }
        }
        return components;
    }

    @BeanTagAttribute(name="collectionObjectClass")
    public Class<?> getCollectionObjectClass() {
        return this.collectionObjectClass;
    }

    public void setCollectionObjectClass(Class<?> collectionObjectClass) {
        this.collectionObjectClass = collectionObjectClass;
    }

    @Override
    @BeanTagAttribute(name="propertyName")
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    @BeanTagAttribute(name="bindingInfo", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    @BeanTagAttribute(name="lineActions", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Action> getLineActions() {
        return this.lineActions;
    }

    public void setLineActions(List<Action> lineActions) {
        this.lineActions = lineActions;
    }

    @BeanTagAttribute(name="renderLineActions")
    public boolean isRenderLineActions() {
        return this.renderLineActions;
    }

    public void setRenderLineActions(boolean renderLineActions) {
        this.renderLineActions = renderLineActions;
    }

    @BeanTagAttribute(name="renderAddLine")
    public boolean isRenderAddLine() {
        return this.renderAddLine;
    }

    public void setRenderAddLine(boolean renderAddLine) {
        this.renderAddLine = renderAddLine;
    }

    public String getAddLabel() {
        if (this.getAddLineLabel() != null) {
            return this.getAddLineLabel().getMessageText();
        }
        return null;
    }

    public void setAddLabel(String addLabelText) {
        if (this.getAddLineLabel() != null) {
            this.getAddLineLabel().setMessageText(addLabelText);
        }
    }

    @BeanTagAttribute(name="addLineLabel", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getAddLineLabel() {
        return this.addLineLabel;
    }

    public void setAddLineLabel(Message addLineLabel) {
        this.addLineLabel = addLineLabel;
    }

    @BeanTagAttribute(name="addLinePropertyName")
    public String getAddLinePropertyName() {
        return this.addLinePropertyName;
    }

    public void setAddLinePropertyName(String addLinePropertyName) {
        this.addLinePropertyName = addLinePropertyName;
    }

    @BeanTagAttribute(name="addLineBindingInfo", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BindingInfo getAddLineBindingInfo() {
        return this.addLineBindingInfo;
    }

    public void setAddLineBindingInfo(BindingInfo addLineBindingInfo) {
        this.addLineBindingInfo = addLineBindingInfo;
    }

    @BeanTagAttribute(name="addLineItems", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<? extends Component> getAddLineItems() {
        return this.addLineItems;
    }

    public void setAddLineItems(List<? extends Component> addLineItems) {
        this.addLineItems = addLineItems;
    }

    @BeanTagAttribute(name="addLineActions", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Action> getAddLineActions() {
        return this.addLineActions;
    }

    public void setAddLineActions(List<Action> addLineActions) {
        this.addLineActions = addLineActions;
    }

    @BeanTagAttribute(name="includeLineSelectionField")
    public boolean isIncludeLineSelectionField() {
        return this.includeLineSelectionField;
    }

    public void setIncludeLineSelectionField(boolean includeLineSelectionField) {
        this.includeLineSelectionField = includeLineSelectionField;
    }

    @BeanTagAttribute(name="lineSelectPropertyName")
    public String getLineSelectPropertyName() {
        return this.lineSelectPropertyName;
    }

    public void setLineSelectPropertyName(String lineSelectPropertyName) {
        this.lineSelectPropertyName = lineSelectPropertyName;
    }

    @BeanTagAttribute(name="collectionLookup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public QuickFinder getCollectionLookup() {
        return this.collectionLookup;
    }

    public void setCollectionLookup(QuickFinder collectionLookup) {
        this.collectionLookup = collectionLookup;
    }

    @BeanTagAttribute(name="showInactiveLines")
    public boolean isShowInactiveLines() {
        return this.showInactiveLines;
    }

    public void setShowInactiveLines(boolean showInactiveLines) {
        this.showInactiveLines = showInactiveLines;
    }

    @BeanTagAttribute(name="activeCollectionFilter", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public CollectionFilter getActiveCollectionFilter() {
        return this.activeCollectionFilter;
    }

    public void setActiveCollectionFilter(CollectionFilter activeCollectionFilter) {
        this.activeCollectionFilter = activeCollectionFilter;
    }

    @BeanTagAttribute(name="filters", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<CollectionFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<CollectionFilter> filters) {
        this.filters = filters;
    }

    @BeanTagAttribute(name="subCollections", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<CollectionGroup> getSubCollections() {
        return this.subCollections;
    }

    public void setSubCollections(List<CollectionGroup> subCollections) {
        this.subCollections = subCollections;
    }

    public String getSubCollectionSuffix() {
        return this.subCollectionSuffix;
    }

    public void setSubCollectionSuffix(String subCollectionSuffix) {
        this.subCollectionSuffix = subCollectionSuffix;
    }

    public CollectionGroupSecurity getCollectionGroupSecurity() {
        return (CollectionGroupSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (componentSecurity != null && !(componentSecurity instanceof CollectionGroupSecurity)) {
            throw new RiceRuntimeException("Component security for CollectionGroup should be instance of CollectionGroupSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return CollectionGroupSecurity.class;
    }

    @BeanTagAttribute(name="collectionGroupBuilder", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public CollectionGroupBuilder getCollectionGroupBuilder() {
        if (this.collectionGroupBuilder == null) {
            this.collectionGroupBuilder = new CollectionGroupBuilder();
        }
        return this.collectionGroupBuilder;
    }

    public void setCollectionGroupBuilder(CollectionGroupBuilder collectionGroupBuilder) {
        this.collectionGroupBuilder = collectionGroupBuilder;
    }

    public void setRenderInactiveToggleButton(boolean renderInactiveToggleButton) {
        this.renderInactiveToggleButton = renderInactiveToggleButton;
    }

    @BeanTagAttribute(name="renderInactiveToggleButton")
    public boolean isRenderInactiveToggleButton() {
        return this.renderInactiveToggleButton;
    }

    @BeanTagAttribute(name="displayCollectionSize")
    public int getDisplayCollectionSize() {
        return this.displayCollectionSize;
    }

    public void setDisplayCollectionSize(int displayCollectionSize) {
        this.displayCollectionSize = displayCollectionSize;
    }

    @BeanTagAttribute(name="highlightNewItems")
    public boolean isHighlightNewItems() {
        return this.highlightNewItems;
    }

    public void setHighlightNewItems(boolean highlightNewItems) {
        this.highlightNewItems = highlightNewItems;
    }

    @BeanTagAttribute(name="newItemsCssClass")
    public String getNewItemsCssClass() {
        return this.newItemsCssClass;
    }

    public void setNewItemsCssClass(String newItemsCssClass) {
        this.newItemsCssClass = newItemsCssClass;
    }

    @BeanTagAttribute(name="addItemCssClass")
    public String getAddItemCssClass() {
        return this.addItemCssClass;
    }

    public void setAddItemCssClass(String addItemCssClass) {
        this.addItemCssClass = addItemCssClass;
    }

    @BeanTagAttribute(name="highlightAddItem")
    public boolean isHighlightAddItem() {
        return this.highlightAddItem;
    }

    public void setHighlightAddItem(boolean highlightAddItem) {
        this.highlightAddItem = highlightAddItem;
    }

    @BeanTagAttribute(name="renderAddBlankLineButton")
    public boolean isRenderAddBlankLineButton() {
        return this.renderAddBlankLineButton;
    }

    public void setRenderAddBlankLineButton(boolean renderAddBlankLineButton) {
        this.renderAddBlankLineButton = renderAddBlankLineButton;
    }

    @BeanTagAttribute(name="addBlankLineAction", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Action getAddBlankLineAction() {
        return this.addBlankLineAction;
    }

    public void setAddBlankLineAction(Action addBlankLineAction) {
        this.addBlankLineAction = addBlankLineAction;
    }

    @BeanTagAttribute(name="addLinePlacement")
    public String getAddLinePlacement() {
        return this.addLinePlacement;
    }

    public void setAddLinePlacement(String addLinePlacement) {
        this.addLinePlacement = addLinePlacement;
    }

    @BeanTagAttribute(name="renderSaveLineActions")
    public boolean isRenderSaveLineActions() {
        return this.renderSaveLineActions;
    }

    public void setRenderSaveLineActions(boolean renderSaveLineActions) {
        this.renderSaveLineActions = renderSaveLineActions;
    }

    @BeanTagAttribute(name="addViaLightBox")
    public boolean isAddViaLightBox() {
        return this.addViaLightBox;
    }

    public void setAddViaLightBox(boolean addViaLightBox) {
        this.addViaLightBox = addViaLightBox;
    }

    @BeanTagAttribute(name="addViaLightBoxAction", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Action getAddViaLightBoxAction() {
        return this.addViaLightBoxAction;
    }

    public void setAddViaLightBoxAction(Action addViaLightBoxAction) {
        this.addViaLightBoxAction = addViaLightBoxAction;
    }

    @BeanTagAttribute(name="useServerPaging")
    public boolean isUseServerPaging() {
        return this.useServerPaging;
    }

    public void setUseServerPaging(boolean useServerPaging) {
        this.useServerPaging = useServerPaging;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getDisplayStart() {
        return this.displayStart;
    }

    public void setDisplayStart(int displayStart) {
        this.displayStart = displayStart;
    }

    public int getDisplayLength() {
        return this.displayLength;
    }

    public void setDisplayLength(int displayLength) {
        this.displayLength = displayLength;
    }

    public int getFilteredCollectionSize() {
        return this.filteredCollectionSize;
    }

    public void setFilteredCollectionSize(int filteredCollectionSize) {
        this.filteredCollectionSize = filteredCollectionSize;
    }

    @BeanTagAttribute(name="addTotalColumns")
    protected List<String> getTotalColumns() {
        return this.totalColumns;
    }

    protected void setTotalColumns(List<String> totalColumns) {
        this.totalColumns = totalColumns;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (this.getCollectionObjectClass() == null && Validator.checkExpressions(this, "collectionObjectClass")) {
            String[] currentValues = new String[]{"collectionObjectClass = " + this.getCollectionObjectClass()};
            tracer.createWarning("CollectionObjectClass is not set (disregard if part of an abstract)", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        CollectionGroup collectionGroupCopy = (CollectionGroup)component;
        collectionGroupCopy.setDisplayCollectionSize(this.displayCollectionSize);
        collectionGroupCopy.setActiveCollectionFilter(this.activeCollectionFilter);
        if (this.addBlankLineAction != null) {
            collectionGroupCopy.setAddBlankLineAction((Action)this.addBlankLineAction.copy());
        }
        collectionGroupCopy.setAddItemCssClass(this.addItemCssClass);
        if (this.addLineItems != null && !this.addLineItems.isEmpty()) {
            ArrayList<Component> addLineItemsCopy = new ArrayList<Component>();
            for (Component component2 : this.addLineItems) {
                addLineItemsCopy.add((Component)component2.copy());
            }
            collectionGroupCopy.setAddLineItems(addLineItemsCopy);
        }
        if (this.addLineActions != null && !this.addLineActions.isEmpty()) {
            ArrayList<Action> addLineActionsCopy = new ArrayList<Action>();
            for (Action action : this.addLineActions) {
                addLineActionsCopy.add((Action)action.copy());
            }
            collectionGroupCopy.setAddLineActions(addLineActionsCopy);
        }
        if (this.addLineBindingInfo != null) {
            collectionGroupCopy.setAddLineBindingInfo((BindingInfo)this.addLineBindingInfo.copy());
        }
        if (this.addLineLabel != null) {
            collectionGroupCopy.setAddLineLabel((Message)this.addLineLabel.copy());
        }
        collectionGroupCopy.setAddLinePlacement(this.addLinePlacement);
        collectionGroupCopy.setAddLinePropertyName(this.addLinePropertyName);
        collectionGroupCopy.setAddViaLightBox(this.addViaLightBox);
        if (this.addViaLightBoxAction != null) {
            collectionGroupCopy.setAddViaLightBoxAction((Action)this.addViaLightBoxAction.copy());
        }
        if (this.bindingInfo != null) {
            collectionGroupCopy.setBindingInfo((BindingInfo)this.bindingInfo.copy());
        }
        if (this.collectionLookup != null) {
            collectionGroupCopy.setCollectionLookup((QuickFinder)this.collectionLookup.copy());
        }
        collectionGroupCopy.setCollectionObjectClass(this.collectionObjectClass);
        if (this.filters != null && !this.filters.isEmpty()) {
            collectionGroupCopy.setFilters(new ArrayList<CollectionFilter>(this.filters));
        }
        collectionGroupCopy.setHighlightAddItem(this.highlightAddItem);
        collectionGroupCopy.setHighlightNewItems(this.highlightNewItems);
        collectionGroupCopy.setIncludeLineSelectionField(this.includeLineSelectionField);
        collectionGroupCopy.setUseServerPaging(this.useServerPaging);
        collectionGroupCopy.setPageSize(this.pageSize);
        collectionGroupCopy.setDisplayStart(this.displayStart);
        collectionGroupCopy.setDisplayLength(this.displayLength);
        if (this.lineActions != null && !this.lineActions.isEmpty()) {
            ArrayList<Action> lineActions = new ArrayList<Action>();
            for (Action action : this.lineActions) {
                lineActions.add((Action)action.copy());
            }
            collectionGroupCopy.setLineActions(lineActions);
        }
        collectionGroupCopy.setLineSelectPropertyName(this.lineSelectPropertyName);
        collectionGroupCopy.setNewItemsCssClass(this.newItemsCssClass);
        collectionGroupCopy.setPropertyName(this.propertyName);
        collectionGroupCopy.setRenderAddBlankLineButton(this.renderAddBlankLineButton);
        collectionGroupCopy.setRenderAddLine(this.renderAddLine);
        collectionGroupCopy.setRenderInactiveToggleButton(this.renderInactiveToggleButton);
        collectionGroupCopy.setActiveCollectionFilter(this.activeCollectionFilter);
        collectionGroupCopy.setFilters(this.filters);
        collectionGroupCopy.setRenderLineActions(this.renderLineActions);
        collectionGroupCopy.setRenderSaveLineActions(this.renderSaveLineActions);
        collectionGroupCopy.setShowInactiveLines(this.showInactiveLines);
        if (this.subCollections != null && !this.subCollections.isEmpty()) {
            ArrayList<CollectionGroup> subCollectionsCopy = new ArrayList<CollectionGroup>();
            for (CollectionGroup collectionGroup : this.subCollections) {
                subCollectionsCopy.add((CollectionGroup)collectionGroup.copy());
            }
            collectionGroupCopy.setSubCollections(subCollectionsCopy);
        }
        collectionGroupCopy.setSubCollectionSuffix(this.subCollectionSuffix);
        if (this.totalColumns != null) {
            collectionGroupCopy.setTotalColumns(new ArrayList<String>(this.totalColumns));
        }
    }
}

