/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.CollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.LightTable;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.RemoteFieldsHolder;
import org.kuali.rice.krad.uif.layout.CollectionLayoutManager;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.view.ViewPresentationController;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

public class CollectionGroupBuilder
implements Serializable {
    private static final long serialVersionUID = -4762031957079895244L;
    private static Log LOG = LogFactory.getLog(CollectionGroupBuilder.class);

    public void build(View view, Object model, CollectionGroup collectionGroup) {
        List modelCollection;
        if (collectionGroup.isRenderAddLine() && !collectionGroup.isReadOnly() && !collectionGroup.isRenderAddBlankLineButton()) {
            this.buildAddLine(view, model, collectionGroup);
        }
        if (collectionGroup.isRenderAddBlankLineButton() && collectionGroup.getAddBlankLineAction() != null) {
            collectionGroup.getAddBlankLineAction().setRefreshId(collectionGroup.getId());
        }
        if ((modelCollection = (List)ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath())) != null) {
            List<Integer> showIndexes = this.performCollectionFiltering(view, model, collectionGroup, modelCollection);
            if (collectionGroup.getDisplayCollectionSize() != -1 && showIndexes.size() > collectionGroup.getDisplayCollectionSize()) {
                ArrayList<Integer> newShowIndexes = new ArrayList<Integer>();
                Integer counter = 0;
                for (int index = 0; index < showIndexes.size(); ++index) {
                    newShowIndexes.add(showIndexes.get(index));
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                    if (counter.intValue() == collectionGroup.getDisplayCollectionSize()) break;
                }
                showIndexes = newShowIndexes;
            }
            List<IndexedElement> filteredIndexedElements = this.buildFilteredIndexedCollection(showIndexes, modelCollection);
            collectionGroup.setFilteredCollectionSize(filteredIndexedElements.size());
            this.buildLinesForDisplayedRows(filteredIndexedElements, view, model, collectionGroup);
        }
    }

    private List<IndexedElement> buildFilteredIndexedCollection(List<Integer> showIndexes, List<Object> modelCollection) {
        ArrayList<IndexedElement> filteredIndexedElements = new ArrayList<IndexedElement>(modelCollection.size());
        for (Integer showIndex : showIndexes) {
            filteredIndexedElements.add(new IndexedElement(showIndex, modelCollection.get(showIndex)));
        }
        return filteredIndexedElements;
    }

    protected void buildLinesForDisplayedRows(List<IndexedElement> filteredIndexedElements, View view, Object model, CollectionGroup collectionGroup) {
        if (collectionGroup.isUseServerPaging() && collectionGroup.getDisplayLength() == -1) {
            collectionGroup.setDisplayLength(1);
        }
        int displayStart = collectionGroup.getDisplayStart() != -1 && collectionGroup.isUseServerPaging() ? collectionGroup.getDisplayStart() : 0;
        int displayLength = collectionGroup.getDisplayLength() != -1 && collectionGroup.isUseServerPaging() ? collectionGroup.getDisplayLength() : filteredIndexedElements.size() - displayStart;
        int displayEndExclusive = displayStart + displayLength > filteredIndexedElements.size() ? filteredIndexedElements.size() : displayStart + displayLength;
        List<IndexedElement> renderedIndexedElements = filteredIndexedElements.subList(displayStart, displayEndExclusive);
        for (IndexedElement indexedElement : renderedIndexedElements) {
            Object currentLine = indexedElement.element;
            String bindingPathPrefix = collectionGroup.getBindingInfo().getBindingName() + "[" + indexedElement.index + "]";
            if (StringUtils.isNotBlank((String)collectionGroup.getBindingInfo().getBindByNamePrefix())) {
                bindingPathPrefix = collectionGroup.getBindingInfo().getBindByNamePrefix() + "." + bindingPathPrefix;
            }
            List<Action> lineActions = this.initializeLineActions(collectionGroup.getLineActions(), view, model, collectionGroup, currentLine, indexedElement.index);
            this.buildLine(view, model, collectionGroup, bindingPathPrefix, lineActions, false, currentLine, indexedElement.index);
        }
    }

    protected List<Integer> performCollectionFiltering(View view, Object model, CollectionGroup collectionGroup, Collection<?> collection) {
        CollectionFilter collectionFilter;
        List<Integer> indexes;
        List<Integer> filteredIndexes = new ArrayList<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            filteredIndexes.add(i);
        }
        if (Inactivatable.class.isAssignableFrom(collectionGroup.getCollectionObjectClass()) && !collectionGroup.isShowInactiveLines()) {
            List<Integer> activeIndexes = collectionGroup.getActiveCollectionFilter().filter(view, model, collectionGroup);
            filteredIndexes = ListUtils.intersection(filteredIndexes, activeIndexes);
        }
        Iterator<CollectionFilter> i$ = collectionGroup.getFilters().iterator();
        while (i$.hasNext() && !(filteredIndexes = ListUtils.intersection(filteredIndexes, indexes = (collectionFilter = i$.next()).filter(view, model, collectionGroup))).isEmpty()) {
        }
        return filteredIndexes;
    }

    protected void buildAddLine(View view, Object model, CollectionGroup collectionGroup) {
        boolean addLineBindsToForm = false;
        this.initializeNewCollectionLine(view, model, collectionGroup, false);
        if (StringUtils.isBlank((String)collectionGroup.getAddLinePropertyName())) {
            addLineBindsToForm = true;
        }
        String addLineBindingPath = collectionGroup.getAddLineBindingInfo().getBindingPath();
        List<Action> actions = this.getAddLineActions(view, model, collectionGroup);
        Object addLine = ObjectPropertyUtils.getPropertyValue(model, addLineBindingPath);
        this.buildLine(view, model, collectionGroup, addLineBindingPath, actions, addLineBindsToForm, addLine, -1);
    }

    protected void buildLine(View view, Object model, CollectionGroup collectionGroup, String bindingPath, List<Action> actions, boolean bindToForm, Object currentLine, int lineIndex) {
        CollectionLayoutManager layoutManager = (CollectionLayoutManager)collectionGroup.getLayoutManager();
        List<? extends Component> lineItems = null;
        String lineSuffix = null;
        if (lineIndex == -1) {
            lineItems = ComponentUtils.copyComponentList(collectionGroup.getAddLineItems(), null);
            lineSuffix = "_add";
        } else {
            lineItems = ComponentUtils.copyComponentList(collectionGroup.getItems(), null);
            lineSuffix = "_line" + Integer.toString(lineIndex);
        }
        if (StringUtils.isNotBlank((String)collectionGroup.getSubCollectionSuffix())) {
            lineSuffix = collectionGroup.getSubCollectionSuffix() + lineSuffix;
        }
        List<Field> lineFields = this.processAnyRemoteFieldsHolder(view, model, collectionGroup, lineItems);
        ComponentUtils.bindAndIdFieldList(lineFields, bindingPath, lineSuffix);
        for (Field field : lineFields) {
            List<CollectionGroup> components = ComponentUtils.getComponentsOfTypeDeep(field, CollectionGroup.class);
            for (CollectionGroup fieldCollectionGroup : components) {
                ComponentUtils.prefixBindingPath(fieldCollectionGroup, bindingPath);
                fieldCollectionGroup.setSubCollectionSuffix(lineSuffix);
            }
            List<LightTable> lightTables = ComponentUtils.getComponentsOfTypeDeep(field, LightTable.class);
            for (LightTable lightTable : lightTables) {
                ComponentUtils.prefixBindingPath(lightTable, bindingPath);
            }
        }
        boolean readOnlyLine = collectionGroup.isReadOnly();
        ComponentUtils.updateContextsForLine(lineFields, currentLine, lineIndex, lineSuffix);
        for (Action action : actions) {
            if (action == null || !StringUtils.isNotBlank((String)action.getFocusOnIdAfterSubmit()) || !action.getFocusOnIdAfterSubmit().equalsIgnoreCase(UifConstants.Order.LINE_FIRST.toString()) || lineFields.size() <= 0) continue;
            action.setFocusOnIdAfterSubmit(lineFields.get(0).getId() + "_control");
        }
        if (lineIndex != -1) {
            boolean canViewLine = this.checkViewLineAuthorizationAndPresentationLogic(view, (ViewModel)model, collectionGroup, currentLine);
            if (!canViewLine) {
                return;
            }
            if (!collectionGroup.isReadOnly()) {
                boolean bl = readOnlyLine = !this.checkEditLineAuthorizationAndPresentationLogic(view, (ViewModel)model, collectionGroup, currentLine);
                if (!readOnlyLine && !((UifFormBase)model).isAddedCollectionItem(currentLine) && collectionGroup.isRenderSaveLineActions()) {
                    for (Field f : lineFields) {
                        ControlBase control;
                        if (!(f instanceof InputField) || !f.isRender()) continue;
                        control.setOnChangeScript((control = (ControlBase)((InputField)f).getControl()).getOnChangeScript() == null ? ";collectionLineChanged(this, 'uif-newCollectionItem');" : control.getOnChangeScript() + ";collectionLineChanged(this, 'uif-newCollectionItem');");
                    }
                }
            }
            ComponentUtils.pushObjectToContext(lineFields, "readOnlyLine", (Object)readOnlyLine);
            ComponentUtils.pushObjectToContext(actions, "readOnlyLine", (Object)readOnlyLine);
        }
        this.applyLineFieldAuthorizationAndPresentationLogic(view, (ViewModel)model, collectionGroup, currentLine, readOnlyLine, lineFields, actions);
        if (bindToForm) {
            ComponentUtils.setComponentsPropertyDeep(lineFields, "bindingInfo.bindToForm", true);
        }
        lineFields = this.removeNonRenderLineFields(view, model, collectionGroup, lineFields, currentLine, lineIndex);
        ArrayList<FieldGroup> subCollectionFields = new ArrayList<FieldGroup>();
        if (lineIndex != -1 && collectionGroup.getSubCollections() != null) {
            for (int subLineIndex = 0; subLineIndex < collectionGroup.getSubCollections().size(); ++subLineIndex) {
                CollectionGroup subCollectionPrototype = collectionGroup.getSubCollections().get(subLineIndex);
                CollectionGroup subCollectionGroup = ComponentUtils.copy(subCollectionPrototype, lineSuffix);
                boolean renderSubCollection = this.checkSubCollectionRender(view, model, collectionGroup, subCollectionGroup);
                if (!renderSubCollection) continue;
                subCollectionGroup.getBindingInfo().setBindByNamePrefix(bindingPath);
                if (subCollectionGroup.isRenderAddLine()) {
                    subCollectionGroup.getAddLineBindingInfo().setBindByNamePrefix(bindingPath);
                }
                String subCollectionSuffix = lineSuffix;
                if (StringUtils.isNotBlank((String)subCollectionGroup.getSubCollectionSuffix())) {
                    subCollectionSuffix = subCollectionGroup.getSubCollectionSuffix() + lineSuffix;
                }
                subCollectionGroup.setSubCollectionSuffix(subCollectionSuffix);
                FieldGroup fieldGroupPrototype = layoutManager.getSubCollectionFieldGroupPrototype();
                FieldGroup subCollectionFieldGroup = ComponentUtils.copy(fieldGroupPrototype, lineSuffix + "_sub" + subLineIndex);
                subCollectionFieldGroup.setGroup(subCollectionGroup);
                ComponentUtils.updateContextForLine(subCollectionFieldGroup, currentLine, lineIndex, lineSuffix + "_sub" + subLineIndex);
                subCollectionFields.add(subCollectionFieldGroup);
            }
            ComponentUtils.pushObjectToContext(subCollectionFields, "parentLine", currentLine);
        }
        layoutManager.buildLine(view, model, collectionGroup, lineFields, subCollectionFields, bindingPath, actions, lineSuffix, currentLine, lineIndex);
        String selector = "";
        if (lineIndex == -1) {
            ArrayList addIds = new ArrayList();
            for (Field f : lineFields) {
                if (f instanceof InputField) {
                    Control control = ((InputField)f).getControl();
                    if (control == null) continue;
                    control.addStyleClass("ignoreValid");
                    selector = selector + ",#" + f.getId() + "_control";
                    continue;
                }
                if (!(f instanceof FieldGroup)) continue;
                List<InputField> fields = ComponentUtils.getComponentsOfTypeDeep(((FieldGroup)f).getGroup(), InputField.class);
                for (InputField nestedField : fields) {
                    Control control = nestedField.getControl();
                    if (control == null) continue;
                    control.addStyleClass("ignoreValid");
                    selector = selector + ",#" + nestedField.getId() + "_control";
                }
            }
            collectionGroup.addDataAttribute("add_controls", selector.replaceFirst(",", ""));
        }
    }

    protected List<Field> processAnyRemoteFieldsHolder(View view, Object model, CollectionGroup group, List<? extends Component> items) {
        ArrayList<Field> processedItems = new ArrayList<Field>();
        for (Component component : items) {
            if (component instanceof RemoteFieldsHolder) {
                List<InputField> translatedFields = ((RemoteFieldsHolder)component).fetchAndTranslateRemoteFields(view, model, group);
                processedItems.addAll(translatedFields);
                continue;
            }
            processedItems.add((Field)component);
        }
        return processedItems;
    }

    protected List<Field> removeNonRenderLineFields(View view, Object model, CollectionGroup collectionGroup, List<Field> lineFields, Object currentLine, int lineIndex) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        for (Field lineField : lineFields) {
            String conditionalRender = lineField.getPropertyExpression("render");
            if (StringUtils.isNotBlank((String)conditionalRender)) {
                Map<String, Object> context = this.getContextForField(view, collectionGroup, lineField);
                conditionalRender = expressionEvaluator.replaceBindingPrefixes(view, lineField, conditionalRender);
                Boolean render = (Boolean)expressionEvaluator.evaluateExpression(context, conditionalRender);
                lineField.setRender(render);
            }
            if (!lineField.isRender() && !StringUtils.isNotBlank((String)lineField.getProgressiveRender())) continue;
            fields.add(lineField);
        }
        return fields;
    }

    protected boolean checkViewLineAuthorizationAndPresentationLogic(View view, ViewModel model, CollectionGroup collectionGroup, Object line) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean canViewLine = authorizer.canViewLine(view, model, collectionGroup, collectionGroup.getPropertyName(), line, user);
        if (canViewLine) {
            canViewLine = presentationController.canViewLine(view, model, collectionGroup, collectionGroup.getPropertyName(), line);
        }
        return canViewLine;
    }

    protected boolean checkEditLineAuthorizationAndPresentationLogic(View view, ViewModel model, CollectionGroup collectionGroup, Object line) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean canEditLine = authorizer.canEditLine(view, model, collectionGroup, collectionGroup.getPropertyName(), line, user);
        if (canEditLine) {
            canEditLine = presentationController.canEditLine(view, model, collectionGroup, collectionGroup.getPropertyName(), line);
        }
        return canEditLine;
    }

    protected void applyLineFieldAuthorizationAndPresentationLogic(View view, ViewModel model, CollectionGroup collectionGroup, Object line, boolean readOnlyLine, List<Field> lineFields, List<Action> actions) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        for (Field lineField : lineFields) {
            boolean canEditField;
            String propertyName = null;
            if (lineField instanceof DataBinding) {
                propertyName = ((DataBinding)((Object)lineField)).getPropertyName();
            }
            ComponentSecurity componentSecurity = lineField.getComponentSecurity();
            Map<String, Object> context = this.getContextForField(view, collectionGroup, lineField);
            expressionEvaluator.evaluateExpressionsOnConfigurable(view, componentSecurity, context);
            if (!lineField.isRender() || lineField.isHidden()) continue;
            boolean canViewField = authorizer.canViewLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), line, lineField, propertyName, user);
            if (canViewField) {
                canViewField = presentationController.canViewLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), line, lineField, propertyName);
            }
            if (!canViewField) {
                lineField.setHidden(true);
                if (!lineField.getPropertyExpressions().containsKey("hidden")) continue;
                lineField.getPropertyExpressions().remove("hidden");
                continue;
            }
            boolean bl = canEditField = !readOnlyLine;
            if (!readOnlyLine && (canEditField = authorizer.canEditLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), line, lineField, propertyName, user))) {
                canEditField = presentationController.canEditLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), line, lineField, propertyName);
            }
            if (!readOnlyLine && canEditField) continue;
            lineField.setReadOnly(true);
            if (!lineField.getPropertyExpressions().containsKey("readOnly")) continue;
            lineField.getPropertyExpressions().remove("readOnly");
        }
        for (Action action : actions) {
            if (!action.isRender()) continue;
            boolean canPerformAction = authorizer.canPerformLineAction(view, model, collectionGroup, collectionGroup.getPropertyName(), line, action, action.getActionEvent(), action.getId(), user);
            if (canPerformAction) {
                canPerformAction = presentationController.canPerformLineAction(view, model, collectionGroup, collectionGroup.getPropertyName(), line, action, action.getActionEvent(), action.getId());
            }
            if (canPerformAction) continue;
            action.setRender(false);
            if (!action.getPropertyExpressions().containsKey("render")) continue;
            action.getPropertyExpressions().remove("render");
        }
    }

    protected boolean checkSubCollectionRender(View view, Object model, CollectionGroup collectionGroup, CollectionGroup subCollectionGroup) {
        String conditionalRender = subCollectionGroup.getPropertyExpression("render");
        if (StringUtils.isNotBlank((String)conditionalRender)) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            Map<String, Object> viewContext = view.getContext();
            if (viewContext != null) {
                context.putAll(viewContext);
            }
            context.put("parent", collectionGroup);
            context.put("component", subCollectionGroup);
            Boolean render = (Boolean)view.getViewHelperService().getExpressionEvaluator().evaluateExpression(context, conditionalRender);
            subCollectionGroup.setRender(render);
        }
        return subCollectionGroup.isRender();
    }

    protected List<Action> initializeLineActions(List<Action> lineActions, View view, Object model, CollectionGroup collectionGroup, Object collectionLine, int lineIndex) {
        String lineSuffix = "_line" + Integer.toString(lineIndex);
        if (StringUtils.isNotBlank((String)collectionGroup.getSubCollectionSuffix())) {
            lineSuffix = collectionGroup.getSubCollectionSuffix() + lineSuffix;
        }
        List<Action> actions = ComponentUtils.copyComponentList(lineActions, lineSuffix);
        for (Action action : actions) {
            if (ComponentUtils.containsPropertyExpression(action, "actionParameters", true)) {
                action.getPropertyExpressions().put("actionParameters['selectedCollectionPath']", "@{'" + collectionGroup.getBindingInfo().getBindingPath() + "'" + "}");
                action.getPropertyExpressions().put("actionParameters['selectedLineIndex']", "@{'" + Integer.toString(lineIndex) + "'" + "}");
            } else {
                action.addActionParameter("selectedCollectionPath", collectionGroup.getBindingInfo().getBindingPath());
                action.addActionParameter("selectedLineIndex", Integer.toString(lineIndex));
            }
            action.setJumpToIdAfterSubmit(collectionGroup.getId());
            action.setRefreshId(collectionGroup.getId());
            if (!action.isPerformClientSideValidation()) continue;
            String preSubmitScript = "var valid=validateLine('" + collectionGroup.getBindingInfo().getBindingPath() + "'," + Integer.toString(lineIndex) + ");";
            if (StringUtils.isNotBlank((String)action.getPreSubmitCall())) {
                preSubmitScript = ScriptUtils.appendScript(preSubmitScript, "if(valid){valid=function(){" + action.getPreSubmitCall() + "}();}");
            }
            preSubmitScript = preSubmitScript + " return valid;";
            action.setPreSubmitCall(preSubmitScript);
            action.setPerformClientSideValidation(false);
        }
        ComponentUtils.updateContextsForLine(actions, collectionLine, lineIndex, lineSuffix);
        return actions;
    }

    protected List<Action> getAddLineActions(View view, Object model, CollectionGroup collectionGroup) {
        String lineSuffix = "_add";
        if (StringUtils.isNotBlank((String)collectionGroup.getSubCollectionSuffix())) {
            lineSuffix = collectionGroup.getSubCollectionSuffix() + lineSuffix;
        }
        List<Action> lineActions = ComponentUtils.copyComponentList(collectionGroup.getAddLineActions(), lineSuffix);
        for (Action action : lineActions) {
            action.addActionParameter("selectedCollectionPath", collectionGroup.getBindingInfo().getBindingPath());
            action.setJumpToIdAfterSubmit(collectionGroup.getId());
            action.addActionParameter("actionType", "addLine");
            action.setRefreshId(collectionGroup.getId());
            String baseId = collectionGroup.getBaseId();
            if (StringUtils.isNotBlank((String)collectionGroup.getSubCollectionSuffix())) {
                baseId = baseId + collectionGroup.getSubCollectionSuffix();
            }
            if (!action.isPerformClientSideValidation()) continue;
            String preSubmitScript = "var valid=";
            preSubmitScript = collectionGroup.isAddViaLightBox() ? preSubmitScript + "validateAddLine('" + collectionGroup.getId() + "', true);" : preSubmitScript + "validateAddLine('" + collectionGroup.getId() + "');";
            if (StringUtils.isNotBlank((String)action.getPreSubmitCall())) {
                preSubmitScript = ScriptUtils.appendScript(preSubmitScript, "if(valid){valid=function(){" + action.getPreSubmitCall() + "}();}");
            }
            if (collectionGroup.isAddViaLightBox()) {
                preSubmitScript = preSubmitScript + " if(valid){closeLightbox();}";
            }
            preSubmitScript = preSubmitScript + "return valid;";
            action.setPreSubmitCall(preSubmitScript);
            action.setPerformClientSideValidation(false);
        }
        String addLinePath = collectionGroup.getAddLineBindingInfo().getBindingPath();
        Object addLine = ObjectPropertyUtils.getPropertyValue(model, addLinePath);
        ComponentUtils.updateContextsForLine(lineActions, addLine, -1, lineSuffix);
        return lineActions;
    }

    protected Map<String, Object> getContextForField(View view, CollectionGroup collectionGroup, Field field) {
        Map<String, Object> fieldContext;
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<String, Object> viewContext = view.getContext();
        if (viewContext != null) {
            context.putAll(viewContext);
        }
        if ((fieldContext = field.getContext()) != null) {
            context.putAll(fieldContext);
        }
        context.put("parent", collectionGroup);
        context.put("component", field);
        return context;
    }

    public void initializeNewCollectionLine(View view, Object model, CollectionGroup collectionGroup, boolean clearExistingLine) {
        Object newLine = null;
        if (StringUtils.isBlank((String)collectionGroup.getAddLinePropertyName())) {
            if (!(model instanceof UifFormBase)) {
                throw new RuntimeException("Cannot create new collection line for group: " + collectionGroup.getPropertyName() + ". Model does not extend " + UifFormBase.class.getName());
            }
            HashMap newCollectionLines = (HashMap)ObjectPropertyUtils.getPropertyValue(model, "newCollectionLines");
            if (newCollectionLines == null) {
                newCollectionLines = new HashMap();
                ObjectPropertyUtils.setPropertyValue(model, "newCollectionLines", newCollectionLines);
            }
            String newCollectionLineKey = KRADUtils.translateToMapSafeKey(collectionGroup.getBindingInfo().getBindingPath());
            String addLineBindingPath = "newCollectionLines['" + newCollectionLineKey + "']";
            collectionGroup.getAddLineBindingInfo().setBindingPath(addLineBindingPath);
            if (!newCollectionLines.containsKey(newCollectionLineKey) || newCollectionLines.get(newCollectionLineKey) == null || clearExistingLine) {
                newLine = ObjectUtils.newInstance(collectionGroup.getCollectionObjectClass());
                newCollectionLines.put(newCollectionLineKey, newLine);
            }
        } else {
            Object addLine = ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getAddLineBindingInfo().getBindingPath());
            if (addLine == null || clearExistingLine) {
                newLine = ObjectUtils.newInstance(collectionGroup.getCollectionObjectClass());
                ObjectPropertyUtils.setPropertyValue(model, collectionGroup.getAddLineBindingInfo().getBindingPath(), newLine);
            }
        }
        if (newLine != null) {
            view.getViewHelperService().applyDefaultValuesForCollectionLine(view, model, collectionGroup, newLine);
        }
    }

    private static class IndexedElement {
        final int index;
        final Object element;

        private IndexedElement(int index, Object element) {
            this.index = index;
            this.element = element;
        }
    }
}

