/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.component.Ordered;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.element.ValidationMessages;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Help;
import org.kuali.rice.krad.uif.widget.Tooltip;

public abstract class ContainerBase
extends ComponentBase
implements Container {
    private static final long serialVersionUID = -4182226230601746657L;
    private int defaultItemPosition = 1;
    private Help help;
    private LayoutManager layoutManager;
    private Header header;
    private Group footer;
    private String instructionalText;
    private Message instructionalMessage;
    private ValidationMessages validationMessages;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        this.sortItems(view, model);
        if ((StringUtils.isNotBlank((String)this.instructionalText) || this.getPropertyExpression("instructionalText") != null) && this.instructionalMessage == null) {
            this.instructionalMessage = ComponentFactory.getInstructionalMessage();
            view.assignComponentIds(this.instructionalMessage);
        }
        if (this.layoutManager != null) {
            this.layoutManager.performInitialization(view, model, this);
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.instructionalMessage != null && StringUtils.isBlank((String)this.instructionalMessage.getMessageText())) {
            this.instructionalMessage.setMessageText(this.instructionalText);
        }
        if (this.layoutManager != null) {
            this.layoutManager.performApplyModel(view, model, this);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.header != null) {
            this.header.addDataAttribute("header_for", this.getId());
        }
        if (this.layoutManager != null) {
            this.layoutManager.performFinalize(view, model, this);
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.header);
        components.add(this.footer);
        components.add(this.validationMessages);
        components.add(this.help);
        components.add(this.instructionalMessage);
        for (Component component : this.getItems()) {
            components.add(component);
        }
        if (this.layoutManager != null) {
            components.addAll(this.layoutManager.getComponentsForLifecycle());
        }
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        if (this.layoutManager != null) {
            components.addAll(this.layoutManager.getComponentPrototypes());
        }
        return components;
    }

    protected void sortItems(View view, Object model) {
        List<? extends Ordered> sortedItems = ComponentUtils.sort(this.getItems(), this.defaultItemPosition);
        this.setItems(sortedItems);
    }

    @Override
    @BeanTagAttribute(name="validationMessages", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ValidationMessages getValidationMessages() {
        return this.validationMessages;
    }

    @Override
    public void setValidationMessages(ValidationMessages validationMessages) {
        this.validationMessages = validationMessages;
    }

    @Override
    @BeanTagAttribute(name="help", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Help getHelp() {
        return this.help;
    }

    @Override
    public void setHelp(Help help) {
        this.help = help;
    }

    @Override
    public void setTooltipOfComponent(Tooltip tooltip) {
        this.getHeader().setToolTip(tooltip);
    }

    @Override
    public String getHelpTitle() {
        return this.getHeader().getHeaderText();
    }

    @Override
    @BeanTagAttribute(name="items", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public abstract List<? extends Component> getItems();

    @Override
    public abstract void setItems(List<? extends Component> var1);

    @BeanTagAttribute(name="defaultItemPosition")
    public int getDefaultItemPosition() {
        return this.defaultItemPosition;
    }

    public void setDefaultItemPosition(int defaultItemPosition) {
        this.defaultItemPosition = defaultItemPosition;
    }

    @Override
    @BeanTagAttribute(name="layoutManager", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    @Override
    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    @Override
    @BeanTagAttribute(name="header", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(Header header) {
        this.header = header;
    }

    @Override
    @BeanTagAttribute(name="footer", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getFooter() {
        return this.footer;
    }

    @Override
    public void setFooter(Group footer) {
        this.footer = footer;
    }

    public void setRenderHeader(boolean renderHeader) {
        if (this.header != null) {
            this.header.setRender(renderHeader);
        }
    }

    @BeanTagAttribute(name="headertext")
    public String getHeaderText() {
        if (this.header != null && this.header.getHeaderText() != null) {
            return this.header.getHeaderText();
        }
        return "";
    }

    public void setHeaderText(String headerText) {
        if (this.header != null) {
            this.header.setHeaderText(headerText);
        }
    }

    public void setRenderFooter(boolean renderFooter) {
        if (this.footer != null) {
            this.footer.setRender(renderFooter);
        }
    }

    @BeanTagAttribute(name="instructionalText")
    public String getInstructionalText() {
        return this.instructionalText;
    }

    public void setInstructionalText(String instructionalText) {
        this.instructionalText = instructionalText;
    }

    @Override
    @BeanTagAttribute(name="instructionalMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getInstructionalMessage() {
        return this.instructionalMessage;
    }

    @Override
    public void setInstructionalMessage(Message instructionalMessage) {
        this.instructionalMessage = instructionalMessage;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        ContainerBase containerBaseCopy = (ContainerBase)component;
        containerBaseCopy.setDefaultItemPosition(this.defaultItemPosition);
        if (this.footer != null) {
            containerBaseCopy.setFooter((Group)this.footer.copy());
        }
        if (this.header != null) {
            containerBaseCopy.setHeader((Header)this.header.copy());
        }
        if (this.help != null) {
            containerBaseCopy.setHelp((Help)this.help.copy());
        }
        if (this.instructionalMessage != null) {
            containerBaseCopy.setInstructionalMessage((Message)this.instructionalMessage.copy());
        }
        containerBaseCopy.setInstructionalText(this.instructionalText);
        if (this.layoutManager != null) {
            containerBaseCopy.setLayoutManager((LayoutManager)this.layoutManager.copy());
        }
        if (this.getItems() != null) {
            ArrayList itemsCopy = Lists.newArrayListWithExpectedSize((int)this.getItems().size());
            for (Component component2 : this.getItems()) {
                itemsCopy.add((Component)component2.copy());
            }
            containerBaseCopy.setItems(itemsCopy);
        }
        if (this.validationMessages != null) {
            containerBaseCopy.setValidationMessages((ValidationMessages)this.validationMessages.copy());
        }
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (this.getInstructionalText() != null && this.getInstructionalMessage() != null) {
            String[] currentValues = new String[]{"instructionalMessage.text = " + this.getInstructionalMessage().getMessageText(), "instructionalText = " + this.getInstructionalText()};
            tracer.createWarning("InstructionalMessage will override instructioanlText", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

