/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.control.MultiValueControl;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="dialogGroup-bean", parent="Uif-DialogGroup"), @BeanTag(name="sensitiveData-dialogGroup-bean", parent="Uif-SensitiveData-DialogGroup"), @BeanTag(name="ok-cancel-dialogGroup-bean", parent="Uif-OK-Cancel-DialogGroup"), @BeanTag(name="yes-no-dialogGroup-bean", parent="Uif-Yes-No-DialogGroup"), @BeanTag(name="true-false-dialogGroup-bean", parent="Uif-True-False-DialogGroup"), @BeanTag(name="checkbox-dialogGroup-bean", parent="Uif-Checkbox-DialogGroup"), @BeanTag(name="radioButton-dialogGroup-bean", parent="Uif-RadioButton-DialogGroup")})
public class DialogGroup
extends Group {
    private static final long serialVersionUID = 1L;
    private String promptText;
    private List<KeyValue> availableResponses;
    private MessageField prompt;
    private InputField explanation;
    private InputField responseInputField;
    private boolean reverseButtonOrder;
    private boolean displayExplanation;
    private String onDialogResponseScript;
    private String onShowDialogScript;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        ArrayList<? extends Component> newItems = new ArrayList<Component>();
        List<? extends Component> items = this.getItems();
        if (!items.contains(this.prompt)) {
            view.assignComponentIds(this.prompt);
            newItems.add(this.prompt);
        }
        if (!items.contains(this.explanation)) {
            view.assignComponentIds(this.explanation);
            newItems.add(this.explanation);
        }
        newItems.addAll(this.getItems());
        if (!items.contains(this.responseInputField)) {
            view.assignComponentIds(this.responseInputField);
            newItems.add(this.responseInputField);
        }
        this.setItems(newItems);
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        this.prompt.setMessageText(this.promptText);
        this.explanation.setRender(this.displayExplanation);
        if (this.responseInputField.getControl() != null && this.responseInputField.getControl() instanceof MultiValueControl) {
            MultiValueControl multiValueControl = (MultiValueControl)((Object)this.responseInputField.getControl());
            if (this.reverseButtonOrder) {
                ArrayList<KeyValue> buttonList = new ArrayList<KeyValue>(this.availableResponses);
                Collections.reverse(buttonList);
                multiValueControl.setOptions(buttonList);
            } else {
                multiValueControl.setOptions(this.availableResponses);
            }
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.responseInputField != null) {
            String responseInputSelector = "#" + this.responseInputField.getId() + " [name='" + this.responseInputField.getBindingInfo().getBindingPath() + "']";
            String onChangeScript = "var value = coerceValue(\"" + this.responseInputField.getBindingInfo().getBindingPath() + "\");";
            onChangeScript = onChangeScript + "jQuery('#" + this.getId() + "').trigger({type:'" + "dialogresponse.uif" + "',value:value});";
            String onChangeHandler = "jQuery(\"" + responseInputSelector + "\").change(function(e){" + onChangeScript + "});";
            String onReadyScript = ScriptUtils.appendScript(this.getOnDocumentReadyScript(), onChangeHandler);
            this.setOnDocumentReadyScript(onReadyScript);
        }
    }

    @Override
    public String getEventHandlerScript() {
        String handlerScript = super.getEventHandlerScript();
        handlerScript = handlerScript + ScriptUtils.buildEventHandlerScript(this.getId(), "dialogresponse.uif", this.getOnDialogResponseScript());
        handlerScript = handlerScript + ScriptUtils.buildEventHandlerScript(this.getId(), "showdialog.uif", this.getOnShowDialogScript());
        return handlerScript;
    }

    @BeanTagAttribute(name="promptText")
    public String getPromptText() {
        return this.promptText;
    }

    public void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    @BeanTagAttribute(name="prompt", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public MessageField getPrompt() {
        return this.prompt;
    }

    public void setPrompt(MessageField prompt) {
        this.prompt = prompt;
    }

    @BeanTagAttribute(name="explanation", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public InputField getExplanation() {
        return this.explanation;
    }

    public void setExplanation(InputField explanation) {
        this.explanation = explanation;
    }

    @BeanTagAttribute(name="displayExplanation")
    public boolean isDisplayExplanation() {
        return this.displayExplanation;
    }

    public void setDisplayExplanation(boolean displayExplanation) {
        this.displayExplanation = displayExplanation;
    }

    @BeanTagAttribute(name="availableResponses", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<KeyValue> getAvailableResponses() {
        return this.availableResponses;
    }

    public void setAvailableResponses(List<KeyValue> availableResponses) {
        this.availableResponses = availableResponses;
    }

    @BeanTagAttribute(name="responseInputField", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public InputField getResponseInputField() {
        return this.responseInputField;
    }

    public void setResponseInputField(InputField responseInputField) {
        this.responseInputField = responseInputField;
    }

    @BeanTagAttribute(name="reverseButtonOrder")
    public boolean isReverseButtonOrder() {
        return this.reverseButtonOrder;
    }

    public void setReverseButtonOrder(boolean reverseButtonOrder) {
        this.reverseButtonOrder = reverseButtonOrder;
    }

    @BeanTagAttribute(name="onDialogResponseScript")
    public String getOnDialogResponseScript() {
        return this.onDialogResponseScript;
    }

    public void setOnDialogResponseScript(String onDialogResponseScript) {
        this.onDialogResponseScript = onDialogResponseScript;
    }

    @BeanTagAttribute(name="onShowDialogScript")
    public String getOnShowDialogScript() {
        return this.onShowDialogScript;
    }

    public void setOnShowDialogScript(String onShowDialogScript) {
        this.onShowDialogScript = onShowDialogScript;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        DialogGroup dialogGroupCopy = (DialogGroup)component;
        if (this.availableResponses != null) {
            dialogGroupCopy.setAvailableResponses(new ArrayList<KeyValue>(this.availableResponses));
        }
        dialogGroupCopy.setDisplayExplanation(this.displayExplanation);
        dialogGroupCopy.setOnDialogResponseScript(this.onDialogResponseScript);
        dialogGroupCopy.setOnShowDialogScript(this.onShowDialogScript);
        if (this.prompt != null) {
            dialogGroupCopy.setPrompt((MessageField)this.prompt.copy());
        }
        dialogGroupCopy.setPromptText(this.promptText);
        dialogGroupCopy.setReverseButtonOrder(this.reverseButtonOrder);
        if (this.explanation != null) {
            dialogGroupCopy.setExplanation((InputField)this.explanation.copy());
        }
        if (this.responseInputField != null) {
            dialogGroupCopy.setResponseInputField((InputField)this.responseInputField.copy());
        }
    }
}

