/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.NavigationGroup;
import org.kuali.rice.krad.uif.util.BreadcrumbItem;
import org.kuali.rice.krad.uif.util.PageBreadcrumbOptions;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="page-bean", parent="Uif-Page"), @BeanTag(name="disclosure-page-bean", parent="Uif-Disclosure-Page"), @BeanTag(name="documentPage-bean", parent="Uif-DocumentPage"), @BeanTag(name="inquiryPage-bean", parent="Uif-InquiryPage"), @BeanTag(name="lookupPage-bean", parent="Uif-LookupPage"), @BeanTag(name="maintenancePage-bean", parent="Uif-MaintenancePage")})
public class PageGroup
extends Group {
    private static final long serialVersionUID = 7571981300587270274L;
    private boolean autoFocus = false;
    private PageBreadcrumbOptions breadcrumbOptions;
    private BreadcrumbItem breadcrumbItem;
    private boolean stickyFooter;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        for (Component component : this.getItems()) {
            if (component == null || !(component instanceof PageGroup)) continue;
            throw new RuntimeException("The page with id='" + this.getId() + "' contains a page with id='" + component.getId() + "'.  Nesting a page within a page is not allowed since only one " + "page's content can be shown on the View " + "at a time.  This may have been caused by possible misuse of the singlePageView flag (when " + "this flag is true, items set on the View become items of the single page.  Instead use " + "the page property on the View to set the page being used).");
        }
        this.breadcrumbOptions.setupBreadcrumbs(view, model);
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        this.addDataAttribute("type", "Page");
        String prefixScript = "";
        if (this.getOnDocumentReadyScript() != null) {
            prefixScript = this.getOnDocumentReadyScript();
        }
        if (view instanceof FormView && ((FormView)view).isValidateClientSide()) {
            this.setOnDocumentReadyScript(prefixScript + "\nsetupPage(true);");
        } else {
            this.setOnDocumentReadyScript(prefixScript + "\nsetupPage(false);");
        }
        this.breadcrumbOptions.finalizeBreadcrumbs(view, model, this, this.breadcrumbItem);
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.breadcrumbItem);
        if (this.breadcrumbOptions != null) {
            if (this.breadcrumbOptions.getHomewardPathBreadcrumbs() != null) {
                components.addAll(this.breadcrumbOptions.getHomewardPathBreadcrumbs());
            }
            if (this.breadcrumbOptions.getPreViewBreadcrumbs() != null) {
                components.addAll(this.breadcrumbOptions.getPreViewBreadcrumbs());
            }
            if (this.breadcrumbOptions.getPrePageBreadcrumbs() != null) {
                components.addAll(this.breadcrumbOptions.getPrePageBreadcrumbs());
            }
            if (this.breadcrumbOptions.getBreadcrumbOverrides() != null) {
                components.addAll(this.breadcrumbOptions.getBreadcrumbOverrides());
            }
        }
        components.addAll(super.getComponentsForLifecycle());
        return components;
    }

    @BeanTagAttribute(name="autoFocus")
    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    @BeanTagAttribute(name="breadcrumbOptions", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public PageBreadcrumbOptions getBreadcrumbOptions() {
        return this.breadcrumbOptions;
    }

    public void setBreadcrumbOptions(PageBreadcrumbOptions breadcrumbOptions) {
        this.breadcrumbOptions = breadcrumbOptions;
    }

    @BeanTagAttribute(name="breadcrumbItem", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BreadcrumbItem getBreadcrumbItem() {
        return this.breadcrumbItem;
    }

    public void setBreadcrumbItem(BreadcrumbItem breadcrumbItem) {
        this.breadcrumbItem = breadcrumbItem;
    }

    @BeanTagAttribute(name="stickyFooter")
    public boolean isStickyFooter() {
        return this.stickyFooter;
    }

    public void setStickyFooter(boolean stickyFooter) {
        this.stickyFooter = stickyFooter;
        if (this.getFooter() != null) {
            this.getFooter().addDataAttribute("sticky_footer", Boolean.toString(stickyFooter));
        }
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        PageGroup pageGroupCopy = (PageGroup)component;
        pageGroupCopy.setAutoFocus(this.isAutoFocus());
        pageGroupCopy.setStickyFooter(this.isStickyFooter());
        if (this.breadcrumbOptions != null) {
            pageGroupCopy.setBreadcrumbOptions((PageBreadcrumbOptions)this.getBreadcrumbOptions().copy());
        }
        if (this.breadcrumbItem != null) {
            pageGroupCopy.setBreadcrumbItem((BreadcrumbItem)this.getBreadcrumbItem().copy());
        }
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (this.getItems().get(i).getClass() != PageGroup.class && this.getItems().get(i).getClass() != NavigationGroup.class) continue;
            String[] currentValues = new String[]{"item(" + i + ").class =" + this.getItems().get(i).getClass()};
            tracer.createError("Items in PageGroup cannot be PageGroup or NaviagtionGroup", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

