/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.control.ValueConfiguredControl;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="checkboxControl-bean", parent="Uif-CheckboxControl")
public class CheckboxControl
extends ControlBase
implements ValueConfiguredControl {
    private static final long serialVersionUID = -1397028958569144230L;
    private String value;
    private String checkboxLabel;
    private Message richLabelMessage;
    private List<Component> inlineComponents;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.richLabelMessage == null) {
            Message message = ComponentFactory.getMessage();
            view.assignComponentIds(message);
            message.setMessageText(this.checkboxLabel);
            message.setInlineComponents(this.inlineComponents);
            message.setGenerateSpan(false);
            view.getViewHelperService().performComponentInitialization(view, model, message);
            this.setRichLabelMessage(message);
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.richLabelMessage);
        return components;
    }

    @Override
    @BeanTagAttribute(name="value")
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @BeanTagAttribute(name="checkboxLabel")
    public String getCheckboxLabel() {
        return this.checkboxLabel;
    }

    public void setCheckboxLabel(String checkboxLabel) {
        this.checkboxLabel = checkboxLabel;
    }

    @BeanTagAttribute(name="richLabelMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getRichLabelMessage() {
        return this.richLabelMessage;
    }

    public void setRichLabelMessage(Message richLabelMessage) {
        this.richLabelMessage = richLabelMessage;
    }

    @BeanTagAttribute(name="inlineComponents", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        CheckboxControl checkboxControlCopy = (CheckboxControl)component;
        checkboxControlCopy.setValue(this.value);
        checkboxControlCopy.setCheckboxLabel(this.checkboxLabel);
        if (this.richLabelMessage != null) {
            checkboxControlCopy.setRichLabelMessage((Message)this.richLabelMessage.copy());
        }
        if (this.inlineComponents != null) {
            ArrayList<Component> inlineComponentsCopy = new ArrayList<Component>();
            for (Component inlineComponent : this.inlineComponents) {
                inlineComponentsCopy.add((Component)inlineComponent.copy());
            }
            checkboxControlCopy.setInlineComponents(inlineComponentsCopy);
        }
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        super.completeValidation(tracer.getCopy());
    }
}

