/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.util.ExpressionUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="controlBase-bean", parent="Uif-ControlBase")
public abstract class ControlBase
extends ContentElementBase
implements Control {
    private static final long serialVersionUID = -7898244978136312663L;
    private int tabIndex;
    private boolean disabled = false;
    private String disabledExpression;
    private String disabledReason;
    private boolean evaluateDisabledOnKeyUp;
    private String disabledConditionJs;
    private List<String> disabledConditionControlNames;
    private List<String> disabledWhenChangedPropertyNames = new ArrayList<String>();
    private List<String> enabledWhenChangedPropertyNames = new ArrayList<String>();

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        this.disabledExpression = this.getPropertyExpression("disabled");
        if (this.disabledExpression != null) {
            ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
            this.disabledExpression = expressionEvaluator.replaceBindingPrefixes(view, this, this.disabledExpression);
            this.disabled = (Boolean)expressionEvaluator.evaluateExpression(this.getContext(), this.disabledExpression);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        ExpressionEvaluator expressionEvaluator = view.getViewHelperService().getExpressionEvaluator();
        if (StringUtils.isNotEmpty((String)this.disabledExpression) && !this.disabledExpression.equalsIgnoreCase("true") && !this.disabledExpression.equalsIgnoreCase("false")) {
            this.disabledConditionControlNames = new ArrayList<String>();
            this.disabledConditionJs = ExpressionUtils.parseExpression(this.disabledExpression, this.disabledConditionControlNames);
        }
        ArrayList<String> adjustedDisablePropertyNames = new ArrayList<String>();
        for (String propertyName : this.disabledWhenChangedPropertyNames) {
            adjustedDisablePropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, propertyName));
        }
        this.disabledWhenChangedPropertyNames = adjustedDisablePropertyNames;
        ArrayList<String> adjustedEnablePropertyNames = new ArrayList<String>();
        for (String propertyName : this.enabledWhenChangedPropertyNames) {
            adjustedEnablePropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, propertyName));
        }
        this.enabledWhenChangedPropertyNames = adjustedEnablePropertyNames;
        this.addDataAttribute("role", "Control");
    }

    @Override
    public final String getComponentTypeName() {
        return "control";
    }

    @Override
    @BeanTagAttribute(name="tabIndex")
    public int getTabIndex() {
        return this.tabIndex;
    }

    @Override
    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    @Override
    @BeanTagAttribute(name="disabled")
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    @BeanTagAttribute(name="disabledReason")
    public String getDisabledReason() {
        return this.disabledReason;
    }

    @Override
    public void setDisabledReason(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        super.completeValidation(tracer.getCopy());
    }

    @BeanTagAttribute(name="evaluateDisabledOnKeyUp")
    public boolean isEvaluateDisabledOnKeyUp() {
        return this.evaluateDisabledOnKeyUp;
    }

    public void setEvaluateDisabledOnKeyUp(boolean evaluateDisabledOnKeyUp) {
        this.evaluateDisabledOnKeyUp = evaluateDisabledOnKeyUp;
    }

    public String getDisabledConditionJs() {
        return this.disabledConditionJs;
    }

    public List<String> getDisabledConditionControlNames() {
        return this.disabledConditionControlNames;
    }

    @BeanTagAttribute(name="disabledWhenChangedPropertyNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getDisabledWhenChangedPropertyNames() {
        return this.disabledWhenChangedPropertyNames;
    }

    public void setDisabledWhenChangedPropertyNames(List<String> disabledWhenChangedPropertyNames) {
        this.disabledWhenChangedPropertyNames = disabledWhenChangedPropertyNames;
    }

    @BeanTagAttribute(name="ensabledConditionControlNames", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getEnabledWhenChangedPropertyNames() {
        return this.enabledWhenChangedPropertyNames;
    }

    public void setEnabledWhenChangedPropertyNames(List<String> enabledWhenChangedPropertyNames) {
        this.enabledWhenChangedPropertyNames = enabledWhenChangedPropertyNames;
    }

    protected void setDisabledExpression(String disabledExpression) {
        this.disabledExpression = disabledExpression;
    }

    protected void setDisabledConditionJs(String disabledConditionJs) {
        this.disabledConditionJs = disabledConditionJs;
    }

    protected void setDisabledConditionControlNames(List<String> disabledConditionControlNames) {
        this.disabledConditionControlNames = disabledConditionControlNames;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        ControlBase controlBaseCopy = (ControlBase)component;
        controlBaseCopy.setTabIndex(this.tabIndex);
        controlBaseCopy.setDisabled(this.disabled);
        controlBaseCopy.setDisabledExpression(this.disabledExpression);
        controlBaseCopy.setDisabledReason(this.disabledReason);
        controlBaseCopy.setEvaluateDisabledOnKeyUp(this.evaluateDisabledOnKeyUp);
        controlBaseCopy.setDisabledConditionJs(this.disabledConditionJs);
        if (this.disabledConditionControlNames != null) {
            controlBaseCopy.setDisabledConditionControlNames(new ArrayList<String>(this.disabledConditionControlNames));
        }
        if (this.disabledWhenChangedPropertyNames != null) {
            controlBaseCopy.setDisabledWhenChangedPropertyNames(new ArrayList<String>(this.disabledWhenChangedPropertyNames));
        }
        if (this.enabledWhenChangedPropertyNames != null) {
            controlBaseCopy.setEnabledWhenChangedPropertyNames(new ArrayList<String>(this.enabledWhenChangedPropertyNames));
        }
    }
}

