/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.field.AttributeQuery;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.QuickFinder;

@BeanTag(name="kimPersonControl-bean", parent="Uif-KimPersonControl")
public class UserControl
extends TextControl
implements FilterableLookupCriteriaControl {
    private static final long serialVersionUID = 7468340793076585869L;
    private String principalIdPropertyName;
    private String personNamePropertyName;
    private String personObjectPropertyName;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (!(parent instanceof InputField)) {
            return;
        }
        InputField field = (InputField)parent;
        field.getAdditionalHiddenPropertyNames().add(this.principalIdPropertyName);
        if (!field.isReadOnly()) {
            if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
                field.getPropertyNamesForAdditionalDisplay().add(this.personNamePropertyName);
            } else {
                field.getPropertyNamesForAdditionalDisplay().add(this.personObjectPropertyName + "." + "name");
            }
            String idPropertyPath = field.getBindingInfo().getPropertyAdjustedBindingPath(this.principalIdPropertyName);
            String onChangeScript = "setValue('" + ScriptUtils.escapeName(idPropertyPath) + "','');";
            if (StringUtils.isNotBlank((String)this.getOnChangeScript())) {
                onChangeScript = this.getOnChangeScript() + onChangeScript;
            }
            this.setOnChangeScript(onChangeScript);
        }
        if (field.isReadOnly() && StringUtils.isBlank((String)field.getReadOnlyDisplaySuffixPropertyName())) {
            if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
                field.setReadOnlyDisplaySuffixPropertyName(this.personNamePropertyName);
            } else {
                field.setReadOnlyDisplaySuffixPropertyName(this.personObjectPropertyName + "." + "name");
            }
        }
        AttributeQuery attributeQuery = new AttributeQuery();
        MethodInvokerConfig methodInvokerConfig = new MethodInvokerConfig();
        PersonService personService = KimApiServiceLocator.getPersonService();
        methodInvokerConfig.setTargetObject(personService);
        attributeQuery.setQueryMethodInvokerConfig(methodInvokerConfig);
        attributeQuery.setQueryMethodToCall("getPersonByPrincipalName");
        attributeQuery.getQueryMethodArgumentFieldList().add(field.getPropertyName());
        attributeQuery.getReturnFieldMapping().put("principalId", this.principalIdPropertyName);
        if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
            attributeQuery.getReturnFieldMapping().put("name", this.personNamePropertyName);
        } else {
            attributeQuery.getReturnFieldMapping().put("name", this.personObjectPropertyName + "." + "name");
        }
        field.setAttributeQuery(attributeQuery);
        this.buildUserQuickfinder(view, model, field);
    }

    @Override
    public Map<String, String> filterSearchCriteria(String propertyName, Map<String, String> searchCriteria) {
        HashMap<String, String> filteredSearchCriteria = new HashMap<String, String>(searchCriteria);
        String principalName = searchCriteria.get(propertyName);
        if (StringUtils.isNotBlank((String)principalName)) {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName);
            if (principal == null) {
                return null;
            }
            filteredSearchCriteria.put(this.principalIdPropertyName, principal.getPrincipalId());
        }
        filteredSearchCriteria.remove(propertyName);
        filteredSearchCriteria.remove(this.personNamePropertyName);
        return filteredSearchCriteria;
    }

    protected void buildUserQuickfinder(View view, Object model, InputField field) {
        QuickFinder quickFinder = field.getQuickfinder();
        if (quickFinder != null && !quickFinder.isRender()) {
            return;
        }
        boolean quickfinderCreated = false;
        if (quickFinder == null) {
            quickFinder = ComponentFactory.getQuickFinder();
            view.assignComponentIds(quickFinder);
            field.setQuickfinder(quickFinder);
            quickfinderCreated = true;
        }
        if (StringUtils.isBlank((String)quickFinder.getDataObjectClassName())) {
            quickFinder.setDataObjectClassName(Person.class.getName());
        }
        if (quickFinder.getFieldConversions().isEmpty()) {
            quickFinder.getFieldConversions().put("principalId", this.principalIdPropertyName);
            if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
                quickFinder.getFieldConversions().put("name", this.personNamePropertyName);
            } else {
                quickFinder.getFieldConversions().put("name", this.personObjectPropertyName + "." + "name");
            }
            quickFinder.getFieldConversions().put("principalName", field.getPropertyName());
        }
        if (quickfinderCreated) {
            view.getViewHelperService().spawnSubLifecyle(view, model, quickFinder, field, "INITIALIZE", "APPLY_MODEL");
        }
    }

    @BeanTagAttribute(name="principalIdPropertyName")
    public String getPrincipalIdPropertyName() {
        return this.principalIdPropertyName;
    }

    public void setPrincipalIdPropertyName(String principalIdPropertyName) {
        this.principalIdPropertyName = principalIdPropertyName;
    }

    @BeanTagAttribute(name="personNamePropertyName")
    public String getPersonNamePropertyName() {
        return this.personNamePropertyName;
    }

    public void setPersonNamePropertyName(String personNamePropertyName) {
        this.personNamePropertyName = personNamePropertyName;
    }

    @BeanTagAttribute(name="personObjectPropertyName")
    public String getPersonObjectPropertyName() {
        return this.personObjectPropertyName;
    }

    public void setPersonObjectPropertyName(String personObjectPropertyName) {
        this.personObjectPropertyName = personObjectPropertyName;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        UserControl userControlCopy = (UserControl)component;
        userControlCopy.setPrincipalIdPropertyName(this.principalIdPropertyName);
        userControlCopy.setPersonNamePropertyName(this.personNamePropertyName);
        userControlCopy.setPersonObjectPropertyName(this.personObjectPropertyName);
    }
}

