/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.HashMap;
import java.util.Map;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.ValidationMessages;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="fieldValidationMessages-bean", parent="Uif-FieldValidationMessages")
public class FieldValidationMessages
extends ValidationMessages {
    private boolean useTooltip;
    private boolean showIcons;

    @Override
    public void generateMessages(boolean reset, View view, Object model, Component parent) {
        super.generateMessages(reset, view, model, parent);
        boolean hasMessages = false;
        if (!(this.getErrors().isEmpty() && this.getWarnings().isEmpty() && this.getInfos().isEmpty())) {
            hasMessages = true;
        }
        HashMap<String, Object> validationMessagesDataAttributes = new HashMap<String, Object>();
        Map dataDefaults = (Map)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryObject("Uif-FieldValidationMessages-DataDefaults");
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "displayMessages", this.isDisplayMessages());
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "useTooltip", this.useTooltip);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "messagingEnabled", this.isDisplayMessages());
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "hasOwnMessages", hasMessages);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "showIcons", this.showIcons);
        if (hasMessages) {
            parent.addDataAttribute("has_messages", Boolean.toString(hasMessages));
        }
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "serverErrors", ScriptUtils.escapeHtml(this.getErrors()));
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "serverWarnings", ScriptUtils.escapeHtml(this.getWarnings()));
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "serverInfo", ScriptUtils.escapeHtml(this.getInfos()));
        if (!validationMessagesDataAttributes.isEmpty()) {
            parent.addDataAttribute("validation_messages", ScriptUtils.translateValue(validationMessagesDataAttributes));
        }
    }

    @BeanTagAttribute(name="useTooltip")
    public boolean isUseTooltip() {
        return this.useTooltip;
    }

    public void setUseTooltip(boolean useTooltip) {
        this.useTooltip = useTooltip;
    }

    @BeanTagAttribute(name="showIcons")
    public boolean isShowIcons() {
        return this.showIcons;
    }

    public void setShowIcons(boolean showIcons) {
        this.showIcons = showIcons;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        FieldValidationMessages fieldValidationMessagesCopy = (FieldValidationMessages)component;
        fieldValidationMessagesCopy.setUseTooltip(this.useTooltip);
        fieldValidationMessagesCopy.setShowIcons(this.showIcons);
    }
}

