/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.LightTable;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.element.PageValidationMessages;
import org.kuali.rice.krad.uif.element.ValidationMessages;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.layout.StackedLayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.GlobalVariables;

@BeanTag(name="groupValidationMessages-bean", parent="Uif-GroupValidationMessages")
public class GroupValidationMessages
extends ValidationMessages {
    private static final long serialVersionUID = -5389990220206079052L;
    private boolean displayFieldLabelWithMessages;
    private boolean collapseAdditionalFieldLinkMessages;
    private boolean displayHeaderMessageSummary;
    private static final String SECTION_TOKEN = "s$";
    private static final String FIELDGROUP_TOKEN = "f$";
    private static final String TABLE_COLLECTION_TOKEN = "c$";

    @Override
    public void generateMessages(boolean reset, View view, Object model, Component parent) {
        super.generateMessages(reset, view, model, parent);
        Map<String, Object> parentContext = parent.getContext();
        Object parentContainer = parentContext == null ? null : parentContext.get("parent");
        List<? extends Component> items = ((Container)parent).getItems();
        boolean skipSections = false;
        boolean isTableCollection = false;
        if (parent instanceof CollectionGroup && ((CollectionGroup)parent).getLayoutManager() instanceof StackedLayoutManager) {
            items = ((StackedLayoutManager)((CollectionGroup)parent).getLayoutManager()).getStackedGroups();
        } else if (parent instanceof CollectionGroup && ((CollectionGroup)parent).getLayoutManager() instanceof TableLayoutManager || parent instanceof LightTable) {
            items = null;
            skipSections = true;
            isTableCollection = true;
        }
        ArrayList<String> sectionIds = new ArrayList<String>();
        ArrayList<String> fieldOrder = new ArrayList<String>();
        this.collectIdsFromItems(items, sectionIds, fieldOrder, skipSections);
        boolean pageLevel = false;
        boolean forceShow = false;
        boolean showPageSummaryHeader = true;
        if (parent instanceof PageGroup) {
            pageLevel = true;
            forceShow = true;
            parent.addDataAttribute("server_messages", Boolean.toString(GlobalVariables.getMessageMap().hasMessages()));
            if (this instanceof PageValidationMessages) {
                showPageSummaryHeader = ((PageValidationMessages)this).isShowPageSummaryHeader();
            }
        } else if (parentContainer instanceof FieldGroup) {
            Map<String, String> parentFieldGroupDataAttributes = ((FieldGroup)parentContainer).getDataAttributes();
            String role = parentFieldGroupDataAttributes == null ? null : parentFieldGroupDataAttributes.get("role");
            forceShow = !StringUtils.isNotBlank((String)role) || !role.equals("detailsFieldGroup");
        }
        boolean hasMessages = false;
        if (!(this.getErrors().isEmpty() && this.getWarnings().isEmpty() && this.getInfos().isEmpty())) {
            hasMessages = true;
        }
        HashMap<String, Object> validationMessagesDataAttributes = new HashMap<String, Object>();
        Map dataDefaults = (Map)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryObject("Uif-GroupValidationMessages-DataDefaults");
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "summarize", true);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "displayMessages", this.isDisplayMessages());
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "collapseFieldMessages", this.collapseAdditionalFieldLinkMessages);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "showPageSummaryHeader", showPageSummaryHeader);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "displayLabel", this.displayFieldLabelWithMessages);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "displayHeaderSummary", this.displayHeaderMessageSummary);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "isTableCollection", isTableCollection);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "hasOwnMessages", hasMessages);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "pageLevel", pageLevel);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "forceShow", forceShow);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "sections", sectionIds);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "order", fieldOrder);
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "serverErrors", ScriptUtils.escapeHtml(this.getErrors()));
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "serverWarnings", ScriptUtils.escapeHtml(this.getWarnings()));
        this.addValidationDataSettingsValue(validationMessagesDataAttributes, dataDefaults, "serverInfo", ScriptUtils.escapeHtml(this.getInfos()));
        if (!validationMessagesDataAttributes.isEmpty()) {
            parent.addDataAttribute("validation_messages", ScriptUtils.translateValue(validationMessagesDataAttributes));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void collectIdsFromItems(List<? extends Component> items, List<String> sectionIds, List<String> order, boolean skipSections) {
        if (items != null) {
            for (Component component : items) {
                String id = component.getId().replace("@id@", "");
                if (component instanceof Container || component instanceof FieldGroup) {
                    void var6_6;
                    if (component instanceof FieldGroup) {
                        if (!skipSections && ((FieldGroup)component).getFieldLabel().isRender() && !((FieldGroup)component).getFieldLabel().isHidden() && (StringUtils.isNotEmpty((String)((FieldGroup)component).getLabel()) || StringUtils.isNotEmpty((String)((FieldGroup)component).getFieldLabel().getLabelText()))) {
                            sectionIds.add(id);
                            order.add(FIELDGROUP_TOKEN + id);
                            continue;
                        }
                        Group group = ((FieldGroup)component).getGroup();
                        if (group == null) continue;
                    }
                    id = var6_6.getId().replace("@id@", "");
                    if (!skipSections && ((Container)var6_6).getHeader() != null && ((Container)var6_6).getHeader().isRender() && (StringUtils.isNotBlank((String)((Container)var6_6).getHeader().getHeaderText()) || StringUtils.isNotBlank((String)var6_6.getTitle()))) {
                        sectionIds.add(id);
                        order.add(SECTION_TOKEN + id);
                        continue;
                    }
                    if (var6_6 instanceof CollectionGroup && ((CollectionGroup)var6_6).getLayoutManager() instanceof TableLayoutManager || var6_6 instanceof LightTable) {
                        order.add(TABLE_COLLECTION_TOKEN + id);
                        continue;
                    }
                    this.collectIdsFromItems(((Container)var6_6).getItems(), sectionIds, order, skipSections);
                    continue;
                }
                if (!(component instanceof InputField)) continue;
                order.add(id);
            }
        }
    }

    @BeanTagAttribute(name="displayFieldLabelWithMessages")
    public boolean isDisplayFieldLabelWithMessages() {
        return this.displayFieldLabelWithMessages;
    }

    public void setDisplayFieldLabelWithMessages(boolean displayFieldLabelWithMessages) {
        this.displayFieldLabelWithMessages = displayFieldLabelWithMessages;
    }

    @BeanTagAttribute(name="collapseAdditionalFieldLinkMessages")
    public boolean isCollapseAdditionalFieldLinkMessages() {
        return this.collapseAdditionalFieldLinkMessages;
    }

    public void setCollapseAdditionalFieldLinkMessages(boolean collapseAdditionalFieldLinkMessages) {
        this.collapseAdditionalFieldLinkMessages = collapseAdditionalFieldLinkMessages;
    }

    @BeanTagAttribute(name="displayHeaderMessageSummary")
    public boolean isDisplayHeaderMessageSummary() {
        return this.displayHeaderMessageSummary;
    }

    public void setDisplayHeaderMessageSummary(boolean displayHeaderMessageSummary) {
        this.displayHeaderMessageSummary = displayHeaderMessageSummary;
    }
}

