/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="label-bean", parent="Uif-Label")
public class Label
extends ContentElementBase {
    private static final long serialVersionUID = -6491546893195180114L;
    private String labelText;
    private String labelForComponentId;
    private boolean renderColon = true;
    private UifConstants.Position requiredMessagePlacement = UifConstants.Position.LEFT;
    private Message requiredMessage;
    private Message richLabelMessage;
    private List<Component> inlineComponents;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.richLabelMessage == null && this.labelText != null && this.labelText.contains("[") && this.labelText.contains("]")) {
            Message message = ComponentFactory.getMessage();
            view.assignComponentIds(message);
            message.setMessageText(this.labelText);
            message.setInlineComponents(this.inlineComponents);
            message.setGenerateSpan(false);
            view.getViewHelperService().performComponentInitialization(view, model, message);
            this.setRichLabelMessage(message);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (StringUtils.isBlank((String)this.getLabelText())) {
            this.setRender(false);
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.requiredMessage);
        components.add(this.richLabelMessage);
        return components;
    }

    @BeanTagAttribute(name="labelForComponentId")
    public String getLabelForComponentId() {
        return this.labelForComponentId;
    }

    public void setLabelForComponentId(String labelForComponentId) {
        this.labelForComponentId = labelForComponentId;
    }

    @BeanTagAttribute(name="labelText")
    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    @BeanTagAttribute(name="renderColon")
    public boolean isRenderColon() {
        return this.renderColon;
    }

    public void setRenderColon(boolean renderColon) {
        this.renderColon = renderColon;
    }

    @BeanTagAttribute(name="requiredMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getRequiredMessage() {
        return this.requiredMessage;
    }

    public void setRequiredMessage(Message requiredMessage) {
        this.requiredMessage = requiredMessage;
    }

    @BeanTagAttribute(name="requiredMessagePlacement", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public UifConstants.Position getRequiredMessagePlacement() {
        return this.requiredMessagePlacement;
    }

    public void setRequiredMessagePlacement(UifConstants.Position requiredMessagePlacement) {
        this.requiredMessagePlacement = requiredMessagePlacement;
    }

    @BeanTagAttribute(name="richLabelMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getRichLabelMessage() {
        return this.richLabelMessage;
    }

    public void setRichLabelMessage(Message richLabelMessage) {
        this.richLabelMessage = richLabelMessage;
    }

    @BeanTagAttribute(name="inlineComponents", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (tracer.getValidationStage() == 1 && this.isRender() && this.getLabelText() == null && !Validator.checkExpressions(this, "labelText")) {
            String[] currentValues = new String[]{"render = " + this.isRender(), "labelText =" + this.getLabelText()};
            tracer.createError("LabelText should be set if render is true", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Label labelCopy = (Label)component;
        if (this.inlineComponents != null) {
            ArrayList inlineComponents = Lists.newArrayListWithExpectedSize((int)this.inlineComponents.size());
            for (Component inlineComponent : this.inlineComponents) {
                inlineComponents.add((Component)inlineComponent.copy());
            }
            labelCopy.setInlineComponents(inlineComponents);
        }
        labelCopy.setLabelForComponentId(this.labelForComponentId);
        labelCopy.setLabelText(this.labelText);
        labelCopy.setRenderColon(this.renderColon);
        if (this.requiredMessage != null) {
            labelCopy.setRequiredMessage((Message)this.requiredMessage.copy());
        }
        if (this.richLabelMessage != null) {
            labelCopy.setRichLabelMessage((Message)this.richLabelMessage.copy());
        }
        labelCopy.setRequiredMessagePlacement(this.requiredMessagePlacement);
    }
}

