/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.LightBox;

@BeanTags(value={@BeanTag(name="link-bean", parent="Uif-Link"), @BeanTag(name="createNewLink-bean", parent="Uif-CreateNewLink")})
public class Link
extends ContentElementBase {
    private static final long serialVersionUID = 8989868231938336068L;
    private String linkText;
    private String target;
    private String href;
    private boolean openInLightbox;
    private LightBox lightBox;

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.openInLightbox && this.lightBox == null) {
            this.lightBox = ComponentFactory.getLightBox();
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.lightBox != null && this.lightBox.isRender()) {
            this.addDataAttribute("onclick", "handleLightboxOpen(jQuery(this), " + this.lightBox.getTemplateOptionsJSString() + ", " + this.lightBox.isAddAppParms() + ", e);");
            this.lightBox.setRender(false);
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.lightBox);
        return components;
    }

    @BeanTagAttribute(name="linkText")
    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    @BeanTagAttribute(name="target")
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @BeanTagAttribute(name="href")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public boolean isOpenInLightbox() {
        return this.openInLightbox;
    }

    public void setOpenInLightbox(boolean openInLightbox) {
        this.openInLightbox = openInLightbox;
    }

    @BeanTagAttribute(name="lightBox", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public LightBox getLightBox() {
        return this.lightBox;
    }

    public void setLightBox(LightBox lightBox) {
        this.lightBox = lightBox;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        ArrayList reports = new ArrayList();
        tracer.addBean(this);
        if (tracer.getValidationStage() == 1) {
            String[] currentValues;
            if (this.getHref() == null && !Validator.checkExpressions(this, "href")) {
                currentValues = new String[]{"href =" + this.getHref()};
                tracer.createError("Href must be set", currentValues);
            }
            if (this.getLinkText() == null && !Validator.checkExpressions(this, "linkText")) {
                currentValues = new String[]{"linkText = " + this.getLinkText()};
                tracer.createError("LinkText must be set", currentValues);
            }
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        Link linkCopy = (Link)component;
        linkCopy.setHref(this.href);
        if (this.lightBox != null) {
            linkCopy.setLightBox((LightBox)this.lightBox.copy());
        }
        linkCopy.setLinkText(this.linkText);
        linkCopy.setOpenInLightbox(this.openInLightbox);
        linkCopy.setTarget(this.target);
    }
}

