/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.ContainerBase;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.MessageStructureUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

@BeanTag(name="validationMessages-bean", parent="Uif-ValidationMessagesBase")
public class ValidationMessages
extends ContentElementBase {
    private static final long serialVersionUID = 780940788435330077L;
    private List<String> additionalKeysToMatch;
    private boolean displayMessages;
    private List<String> errors;
    private List<String> warnings;
    private List<String> infos;
    private Map<String, String> validationDataDefaults;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        this.generateMessages(true, view, model, parent);
    }

    public void generateMessages(boolean reset, View view, Object model, Component parent) {
        Object parentContainer;
        if (reset) {
            this.errors = new ArrayList<String>();
            this.warnings = new ArrayList<String>();
            this.infos = new ArrayList<String>();
        }
        List<String> masterKeyList = this.getKeys(parent);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        String parentContainerId = "";
        Map<String, Object> parentContext = parent.getContext();
        Object object = parentContainer = parentContext == null ? null : parentContext.get("parent");
        if (parentContainer != null && (parentContainer instanceof Container || parentContainer instanceof FieldGroup)) {
            parentContainerId = ((Component)parentContainer).getId();
        }
        if (parentContainer != null && parentContainer instanceof Message && ((Message)parentContainer).isGenerateSpan()) {
            parentContainerId = ((Component)parentContainer).getId();
        }
        if (parentContainer != null && parentContainer instanceof Component && StringUtils.isBlank((String)parentContainerId) && (parentContainer = ((Component)parentContainer).getContext().get("parent")) != null && (parentContainer instanceof Container || parentContainer instanceof FieldGroup)) {
            parentContainerId = ((Component)parentContainer).getId();
        }
        this.addDataAttribute("messages_for", parent.getId());
        if (parent.getDataAttributes() == null || parent.getDataAttributes().get("parent") == null) {
            parent.addDataAttribute("parent", parentContainerId);
        }
        if (parentContainer != null && parentContainer instanceof FieldGroup) {
            masterKeyList.add(parentContainerId);
        }
        if (parent instanceof PageGroup) {
            Map<String, PropertyEditor> propertyEditors = view.getViewIndex().getFieldPropertyEditors();
            Map<String, PropertyEditor> securePropertyEditors = view.getViewIndex().getSecureFieldPropertyEditors();
            ArrayList<String> allPossibleKeys = new ArrayList<String>(propertyEditors.keySet());
            allPossibleKeys.addAll(securePropertyEditors.keySet());
            this.addNestedGroupKeys(allPossibleKeys, parent);
            if (this.additionalKeysToMatch != null) {
                allPossibleKeys.addAll(this.additionalKeysToMatch);
            }
            if (StringUtils.isNotBlank((String)parent.getId())) {
                allPossibleKeys.add(parent.getId());
            }
            HashSet messageKeys = new HashSet();
            messageKeys.addAll(messageMap.getAllPropertiesWithErrors());
            messageKeys.addAll(messageMap.getAllPropertiesWithWarnings());
            messageKeys.addAll(messageMap.getAllPropertiesWithInfo());
            messageKeys.removeAll(allPossibleKeys);
            masterKeyList.addAll(messageKeys);
        }
        for (String key : masterKeyList) {
            this.errors.addAll(this.getMessages(view, key, messageMap.getErrorMessagesForProperty(key, true)));
            this.warnings.addAll(this.getMessages(view, key, messageMap.getWarningMessagesForProperty(key, true)));
            this.infos.addAll(this.getMessages(view, key, messageMap.getInfoMessagesForProperty(key, true)));
        }
    }

    private List<String> getMessages(View view, String key, List<AutoPopulatingList<ErrorMessage>> lists) {
        ArrayList<String> result = new ArrayList<String>();
        for (AutoPopulatingList<ErrorMessage> errorList : lists) {
            if (errorList == null || !StringUtils.isNotBlank((String)key)) continue;
            for (ErrorMessage e : errorList) {
                String message = KRADUtils.getMessageText(e, true);
                message = MessageStructureUtils.translateStringMessage(message);
                result.add(message);
            }
        }
        return result;
    }

    protected List<String> getKeys(Component parent) {
        ArrayList<String> keyList = new ArrayList<String>();
        if (this.additionalKeysToMatch != null) {
            keyList.addAll(this.additionalKeysToMatch);
        }
        if (StringUtils.isNotBlank((String)parent.getId())) {
            keyList.add(parent.getId());
        }
        if (parent instanceof InputField && ((InputField)parent).getBindingInfo() != null && StringUtils.isNotEmpty((String)((InputField)parent).getBindingInfo().getBindingPath())) {
            keyList.add(((InputField)parent).getBindingInfo().getBindingPath());
        }
        return keyList;
    }

    private void addNestedGroupKeys(Collection<String> keyList, Component component) {
        for (Component c : component.getComponentsForLifecycle()) {
            ValidationMessages ef = null;
            if (c instanceof ContainerBase) {
                ef = ((ContainerBase)c).getValidationMessages();
            } else if (c instanceof FieldGroup) {
                ef = ((FieldGroup)c).getGroup().getValidationMessages();
            }
            if (ef == null) continue;
            keyList.addAll(ef.getKeys(c));
            this.addNestedGroupKeys(keyList, c);
        }
    }

    @BeanTagAttribute(name="additionalKeysToMatch", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalKeysToMatch() {
        return this.additionalKeysToMatch;
    }

    public void setAdditionalKeysToMatch(String additionalKeysToMatch) {
        if (StringUtils.isNotBlank((String)additionalKeysToMatch)) {
            this.additionalKeysToMatch = Arrays.asList(StringUtils.split((String)additionalKeysToMatch, (String)","));
        }
    }

    public void setAdditionalKeysToMatch(List<String> additionalKeysToMatch) {
        this.additionalKeysToMatch = additionalKeysToMatch;
    }

    @BeanTagAttribute(name="displayMessages")
    public boolean isDisplayMessages() {
        return this.displayMessages;
    }

    public void setDisplayMessages(boolean displayMessages) {
        this.displayMessages = displayMessages;
    }

    @BeanTagAttribute(name="errors", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getErrors() {
        return this.errors;
    }

    @BeanTagAttribute(name="warnings", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getWarnings() {
        return this.warnings;
    }

    @BeanTagAttribute(name="infos", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getInfos() {
        return this.infos;
    }

    public Map<String, String> getValidationDataDefaults() {
        return this.validationDataDefaults;
    }

    public void setValidationDataDefaults(Map<String, String> validationDataDefaults) {
        this.validationDataDefaults = validationDataDefaults;
    }

    protected void addValidationDataSettingsValue(Map<String, Object> valueMap, Map<String, String> defaults, String key, Object value) {
        String defaultValue = defaults.get(key);
        if (defaultValue != null && !value.toString().equals(defaultValue) || defaultValue != null && defaultValue.equals("[]") && value instanceof List && !((List)value).isEmpty() || defaultValue == null) {
            valueMap.put(key, value);
        }
    }

    protected void setErrors(List<String> errors) {
        this.errors = errors;
    }

    protected void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    protected void setInfos(List<String> infos) {
        this.infos = infos;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        ValidationMessages validationMessagesCopy = (ValidationMessages)component;
        if (this.additionalKeysToMatch != null) {
            ArrayList additionalKeysToMatchCopy = Lists.newArrayListWithExpectedSize((int)this.additionalKeysToMatch.size());
            for (String string : this.additionalKeysToMatch) {
                additionalKeysToMatchCopy.add(string);
            }
            validationMessagesCopy.setAdditionalKeysToMatch(additionalKeysToMatchCopy);
        }
        validationMessagesCopy.setDisplayMessages(this.displayMessages);
        if (this.warnings != null) {
            ArrayList warningsCopy = Lists.newArrayListWithExpectedSize((int)this.warnings.size());
            for (String string : this.warnings) {
                warningsCopy.add(string);
            }
            validationMessagesCopy.setWarnings(warningsCopy);
        }
        if (this.errors != null) {
            ArrayList errorsCopy = Lists.newArrayListWithExpectedSize((int)this.errors.size());
            for (String string : this.errors) {
                errorsCopy.add(string);
            }
            validationMessagesCopy.setErrors(errorsCopy);
        }
        if (this.infos != null) {
            ArrayList infosCopy = Lists.newArrayListWithExpectedSize((int)this.infos.size());
            for (String string : this.infos) {
                infosCopy.add(string);
            }
            validationMessagesCopy.setInfos(infosCopy);
        }
        if (this.validationDataDefaults != null) {
            HashMap validationDataDefaultsCopy = Maps.newHashMapWithExpectedSize((int)this.validationDataDefaults.size());
            for (Map.Entry entry : this.validationDataDefaults.entrySet()) {
                validationDataDefaultsCopy.put(entry.getKey().toString(), entry.getValue().toString());
            }
            validationMessagesCopy.setValidationDataDefaults(validationDataDefaultsCopy);
        }
    }
}

