/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="viewHeader-bean", parent="Uif-ViewHeader")
public class ViewHeader
extends Header {
    private Message areaTitleMessage;
    private Message supportTitleMessage;
    private Message metadataMessage;
    private boolean sticky;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.supportTitleMessage != null && view.getCurrentPage() != null && view.getCurrentPage().getHeader() != null && view.isUnifiedHeader()) {
            Header pageHeader = view.getCurrentPage().getHeader();
            pageHeader.addStyleClass("uif-hideHeaderText");
            Message pageHeaderMessage = pageHeader.getRichHeaderMessage();
            if (pageHeaderMessage != null && StringUtils.isBlank((String)this.supportTitleMessage.getMessageText())) {
                pageHeaderMessage.addStyleClass("uif-viewHeader-supportTitle");
                this.supportTitleMessage = pageHeaderMessage;
            } else if (StringUtils.isNotBlank((String)pageHeader.getHeaderText()) && StringUtils.isBlank((String)this.supportTitleMessage.getMessageText())) {
                this.supportTitleMessage.setMessageText(pageHeader.getHeaderText().trim());
            }
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.areaTitleMessage);
        components.add(this.supportTitleMessage);
        components.add(this.metadataMessage);
        return components;
    }

    @BeanTagAttribute(name="areaTitleText")
    public String getAreaTitleText() {
        return this.areaTitleMessage.getMessageText();
    }

    public void setAreaTitleText(String areaTitle) {
        this.areaTitleMessage.setMessageText(areaTitle);
    }

    @BeanTagAttribute(name="areaTitleMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getAreaTitleMessage() {
        return this.areaTitleMessage;
    }

    public void setAreaTitleMessage(Message areaTitleMessage) {
        this.areaTitleMessage = areaTitleMessage;
    }

    @BeanTagAttribute(name="supportTitleText")
    public String getSupportTitleText() {
        return this.supportTitleMessage.getMessageText();
    }

    public void setSupportTitleText(String supportTitle) {
        this.supportTitleMessage.setMessageText(supportTitle);
    }

    @BeanTagAttribute(name="supportTitleMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getSupportTitleMessage() {
        return this.supportTitleMessage;
    }

    public void setSupportTitleMessage(Message supportTitleMessage) {
        this.supportTitleMessage = supportTitleMessage;
    }

    @BeanTagAttribute(name="metadataText")
    public String getMetadataText() {
        return this.metadataMessage.getMessageText();
    }

    public void setMetadataText(String metadataText) {
        this.metadataMessage.setMessageText(metadataText);
    }

    @BeanTagAttribute(name="metadataMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getMetadataMessage() {
        return this.metadataMessage;
    }

    public void setMetadataMessage(Message metadataMessage) {
        this.metadataMessage = metadataMessage;
    }

    @BeanTagAttribute(name="sticky")
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        ViewHeader viewHeaderCopy = (ViewHeader)component;
        if (this.areaTitleMessage != null) {
            viewHeaderCopy.setAreaTitleMessage((Message)this.areaTitleMessage.copy());
        }
        if (this.supportTitleMessage != null) {
            viewHeaderCopy.setSupportTitleMessage((Message)this.supportTitleMessage.copy());
        }
        if (this.metadataMessage != null) {
            viewHeaderCopy.setMetadataMessage((Message)this.metadataMessage.copy());
        }
        viewHeaderCopy.setSticky(this.sticky);
    }
}

