/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="actionField-bean", parent="Uif-ActionField"), @BeanTag(name="actionLinkField-bean", parent="Uif-ActionLinkField")})
public class ActionField
extends FieldBase {
    private static final long serialVersionUID = -8495752159848603102L;
    private Action action = new Action();

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.getFieldLabel() != null && this.getAction() != null && StringUtils.isNotBlank((String)this.getAction().getId())) {
            this.getFieldLabel().setLabelForComponentId(this.getAction().getId());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.action);
        return components;
    }

    @BeanTagAttribute(name="action", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    @BeanTagAttribute(name="methodToCall")
    public String getMethodToCall() {
        return this.action.getMethodToCall();
    }

    public void setMethodToCall(String methodToCall) {
        this.action.setMethodToCall(methodToCall);
    }

    @BeanTagAttribute(name="actionLabel")
    public String getActionLabel() {
        return this.action.getActionLabel();
    }

    public void setActionLabel(String actionLabel) {
        this.action.setActionLabel(actionLabel);
    }

    @BeanTagAttribute(name="actionImage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Image getActionImage() {
        return this.action.getActionImage();
    }

    public void setActionImage(Image actionImage) {
        this.action.setActionImage(actionImage);
    }

    @BeanTagAttribute(name="navigateToPageId")
    public String getNavigateToPageId() {
        return this.action.getNavigateToPageId();
    }

    public void setNavigateToPageId(String navigateToPageId) {
        this.action.setNavigateToPageId(navigateToPageId);
    }

    @BeanTagAttribute(name="actionEvent")
    public String getActionEvent() {
        return this.action.getActionEvent();
    }

    public void setActionEvent(String actionEvent) {
        this.action.setActionEvent(actionEvent);
    }

    @BeanTagAttribute(name="actionParameters", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getActionParameters() {
        return this.action.getActionParameters();
    }

    public void setActionParameters(Map<String, String> actionParameters) {
        this.action.setActionParameters(actionParameters);
    }

    @BeanTagAttribute(name="additionalSubmitData", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getAdditionalSubmitData() {
        return this.action.getAdditionalSubmitData();
    }

    public void setAdditionalSubmitData(Map<String, String> additionalSubmitData) {
        this.action.setAdditionalSubmitData(additionalSubmitData);
    }

    public void addActionParameter(String parameterName, String parameterValue) {
        this.action.addActionParameter(parameterName, parameterValue);
    }

    public String getActionParameter(String parameterName) {
        return this.action.getActionParameter(parameterName);
    }

    @BeanTagAttribute(name="jumpToIdAfterSubmit")
    public String getJumpToIdAfterSubmit() {
        return this.action.getJumpToIdAfterSubmit();
    }

    public void setJumpToIdAfterSubmit(String jumpToIdAfterSubmit) {
        this.action.setJumpToIdAfterSubmit(jumpToIdAfterSubmit);
    }

    @BeanTagAttribute(name="jumpToNameAfterSubmit")
    public String getJumpToNameAfterSubmit() {
        return this.action.getJumpToNameAfterSubmit();
    }

    public void setJumpToNameAfterSubmit(String jumpToNameAfterSubmit) {
        this.action.setJumpToNameAfterSubmit(jumpToNameAfterSubmit);
    }

    @BeanTagAttribute(name="focusOnIdAfterSubmit")
    public String getFocusOnIdAfterSubmit() {
        return this.action.getFocusOnIdAfterSubmit();
    }

    public void setFocusOnIdAfterSubmit(String focusOnAfterSubmit) {
        this.action.setFocusOnIdAfterSubmit(focusOnAfterSubmit);
    }

    @BeanTagAttribute(name="performClientSideValidation")
    public boolean isPerformClientSideValidation() {
        return this.action.isPerformClientSideValidation();
    }

    public void setPerformClientSideValidation(boolean clientSideValidate) {
        this.action.setPerformClientSideValidation(clientSideValidate);
    }

    @BeanTagAttribute(name="actionScript")
    public String getActionScript() {
        return this.action.getActionScript();
    }

    public void setActionScript(String actionScript) {
        this.action.setActionScript(actionScript);
    }

    @BeanTagAttribute(name="performDirtyValidation")
    public boolean isPerformDirtyValidation() {
        return this.action.isPerformDirtyValidation();
    }

    public void setPerformDirtyValidation(boolean blockValidateDirty) {
        this.action.setPerformDirtyValidation(blockValidateDirty);
    }

    @BeanTagAttribute(name="disabled")
    public boolean isDisabled() {
        return this.action.isDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.action.setDisabled(disabled);
    }

    @BeanTagAttribute(name="disabledReason")
    public String getDisabledReason() {
        return this.action.getDisabledReason();
    }

    public void setDisabledReason(String disabledReason) {
        this.action.setDisabledReason(disabledReason);
    }

    @BeanTagAttribute(name="actionImagePlacement")
    public String getActionImagePlacement() {
        return this.action.getActionImagePlacement();
    }

    public void setActionImagePlacement(String actionImageLocation) {
        this.action.setActionImagePlacement(actionImageLocation);
    }

    @BeanTagAttribute(name="preSubmitCall")
    public String getPreSubmitCall() {
        return this.action.getPreSubmitCall();
    }

    public void setPreSubmitCall(String preSubmitCall) {
        this.action.setPreSubmitCall(preSubmitCall);
    }

    @BeanTagAttribute(name="ajaxSubmit")
    public boolean isAjaxSubmit() {
        return this.action.isAjaxSubmit();
    }

    public void setAjaxSubmit(boolean ajaxSubmit) {
        this.action.setAjaxSubmit(ajaxSubmit);
    }

    @BeanTagAttribute(name="successCallback")
    public String getSuccessCallback() {
        return this.action.getSuccessCallback();
    }

    public void setSuccessCallback(String successCallback) {
        this.action.setSuccessCallback(successCallback);
    }

    @BeanTagAttribute(name="errorCallback")
    public String getErrorCallback() {
        return this.action.getErrorCallback();
    }

    public void setErrorCallback(String errorCallback) {
        this.action.setErrorCallback(errorCallback);
    }

    @BeanTagAttribute(name="refreshId")
    public String getRefreshId() {
        return this.action.getRefreshId();
    }

    public void setRefreshId(String refreshId) {
        this.action.setRefreshId(refreshId);
    }

    @BeanTagAttribute(name="disableBlocking")
    public boolean isDisableBlocking() {
        return this.action.isDisableBlocking();
    }

    public void setDisableBlocking(boolean disableBlocking) {
        this.action.setDisableBlocking(disableBlocking);
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        ArrayList reports = new ArrayList();
        tracer.addBean(this);
        if (this.getAction() == null && Validator.checkExpressions(this, "action")) {
            currentValues = new String[]{"action =" + this.getAction()};
            tracer.createWarning("Action should not be null", currentValues);
        }
        if (this.getLabel() == null && Validator.checkExpressions(this, "label")) {
            currentValues = new String[]{"label =" + this.getLabel(), "action =" + this.getAction()};
            tracer.createWarning("Label is null, action should be used instead", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        ActionField actionFieldCopy = (ActionField)component;
        if (this.action != null) {
            actionFieldCopy.setAction((Action)this.action.copy());
        }
    }
}

