/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldSecurity;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.MessageStructureUtils;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="fieldBase-bean", parent="Uif-FieldBase"), @BeanTag(name="fieldBase-withLabel-bean", parent="Uif-FieldBase-withLabel")})
public class FieldBase
extends ComponentBase
implements Field {
    private static final long serialVersionUID = -5888414844802862760L;
    private String shortLabel;
    private Label fieldLabel;
    private UifConstants.Position labelPlacement = UifConstants.Position.LEFT;
    private boolean labelRendered = false;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.fieldLabel != null) {
            this.fieldLabel.setLabelForComponentId(this.getId());
            if (this.getRequired() != null && this.getRequired().booleanValue()) {
                if (view.getViewTypeName() != null && view.getViewTypeName().equals((Object)UifConstants.ViewType.MAINTENANCE)) {
                    this.fieldLabel.getRequiredMessage().setRender(!view.isReadOnly());
                } else {
                    this.fieldLabel.getRequiredMessage().setRender(!this.isReadOnly());
                }
            } else {
                this.setRequired(new Boolean(false));
                this.fieldLabel.getRequiredMessage().setRender(true);
                String prefixStyle = "";
                if (StringUtils.isNotBlank((String)this.fieldLabel.getRequiredMessage().getStyle())) {
                    prefixStyle = this.fieldLabel.getRequiredMessage().getStyle();
                }
                this.fieldLabel.getRequiredMessage().setStyle(prefixStyle + ";" + "display: none;");
            }
            if (this.labelPlacement.equals((Object)UifConstants.Position.RIGHT)) {
                this.fieldLabel.setRenderColon(false);
            }
            if (this.labelPlacement.equals((Object)UifConstants.Position.TOP) || this.labelPlacement.equals((Object)UifConstants.Position.BOTTOM)) {
                this.fieldLabel.addStyleClass("uif-labelBlock");
            }
            this.fieldLabel.addDataAttribute("label_for", this.getId());
            if (StringUtils.isNotBlank((String)this.getFieldLabel().getLabelText())) {
                this.addDataAttribute("label", MessageStructureUtils.translateStringMessage(this.getFieldLabel().getLabelText()));
            }
        }
    }

    protected void setNestedComponentIdAndSuffix(Component component, String suffix) {
        if (component != null) {
            String fieldId = this.getId();
            fieldId = fieldId + suffix;
            component.setId(fieldId);
        }
    }

    @Override
    public final String getComponentTypeName() {
        return "field";
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.fieldLabel);
        return components;
    }

    @Override
    @BeanTagAttribute(name="label")
    public String getLabel() {
        if (this.fieldLabel != null) {
            return this.fieldLabel.getLabelText();
        }
        return null;
    }

    @Override
    public void setLabel(String labelText) {
        if (StringUtils.isNotBlank((String)labelText) && this.fieldLabel == null) {
            this.fieldLabel = ComponentFactory.getLabel();
        }
        if (this.fieldLabel != null) {
            this.fieldLabel.setLabelText(labelText);
        }
    }

    @Override
    @BeanTagAttribute(name="labelStyleClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getLabelStyleClasses() {
        if (this.fieldLabel != null) {
            return this.fieldLabel.getCssClasses();
        }
        return null;
    }

    @Override
    public void setLabelStyleClasses(List<String> labelStyleClasses) {
        if (labelStyleClasses != null && this.fieldLabel == null) {
            this.fieldLabel = ComponentFactory.getLabel();
        }
        if (this.fieldLabel != null) {
            this.fieldLabel.setCssClasses(labelStyleClasses);
        }
    }

    @Override
    @BeanTagAttribute(name="labelColSpan")
    public int getLabelColSpan() {
        if (this.fieldLabel != null) {
            return this.fieldLabel.getColSpan();
        }
        return 1;
    }

    @Override
    public void setLabelColSpan(int labelColSpan) {
        if (this.fieldLabel == null) {
            this.fieldLabel = ComponentFactory.getLabel();
        }
        if (this.fieldLabel != null) {
            this.fieldLabel.setColSpan(labelColSpan);
        }
    }

    @Override
    @BeanTagAttribute(name="shortLabel")
    public String getShortLabel() {
        return this.shortLabel;
    }

    @Override
    public void setShortLabel(String shortLabel) {
        this.shortLabel = shortLabel;
    }

    public void setShowLabel(boolean showLabel) {
        if (this.fieldLabel != null) {
            this.fieldLabel.setRender(showLabel);
        }
    }

    @Override
    @BeanTagAttribute(name="fieldLabel", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Label getFieldLabel() {
        return this.fieldLabel;
    }

    @Override
    public void setFieldLabel(Label fieldLabel) {
        this.fieldLabel = fieldLabel;
    }

    @BeanTagAttribute(name="labelPlacement", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public UifConstants.Position getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(UifConstants.Position labelPlacement) {
        this.labelPlacement = labelPlacement;
    }

    @Override
    @BeanTagAttribute(name="labelRendered")
    public boolean isLabelRendered() {
        return this.labelRendered;
    }

    @Override
    public void setLabelRendered(boolean labelRendered) {
        this.labelRendered = labelRendered;
    }

    @Override
    public FieldSecurity getFieldSecurity() {
        return (FieldSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (componentSecurity != null && !(componentSecurity instanceof FieldSecurity)) {
            throw new RiceRuntimeException("Component security for Field should be instance of FieldSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return FieldSecurity.class;
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        FieldBase fieldBaseCopy = (FieldBase)component;
        fieldBaseCopy.setShortLabel(this.shortLabel);
        fieldBaseCopy.setLabelRendered(this.labelRendered);
        if (this.fieldLabel != null) {
            fieldBaseCopy.setFieldLabel((Label)this.fieldLabel.copy());
        }
        fieldBaseCopy.setLabelPlacement(this.labelPlacement);
    }
}

