/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="imageField-bean", parent="Uif-ImageField")
public class ImageField
extends FieldBase {
    private static final long serialVersionUID = -7994212503770623408L;
    private Image image;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.getFieldLabel() != null && this.getImage() != null && StringUtils.isNotBlank((String)this.getImage().getId())) {
            this.getFieldLabel().setLabelForComponentId(this.getImage().getId());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.image);
        return components;
    }

    @BeanTagAttribute(name="image", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @BeanTagAttribute(name="source")
    public String getSource() {
        return this.image.getSource();
    }

    public void setSource(String source) {
        this.image.setSource(source);
    }

    @BeanTagAttribute(name="altText")
    public String getAltText() {
        return this.image.getAltText();
    }

    public void setAltText(String altText) {
        this.image.setAltText(altText);
    }

    @BeanTagAttribute(name="height")
    public String getHeight() {
        return this.image.getHeight();
    }

    public void setHeight(String height) {
        this.image.setHeight(height);
    }

    @Override
    public void setWidth(String width) {
        if (this.image != null) {
            this.image.setWidth(width);
        }
    }

    @Override
    @BeanTagAttribute(name="width")
    public String getWidth() {
        return this.image.getWidth();
    }

    @BeanTagAttribute(name="captionHeaderText")
    public String getCaptionHeaderText() {
        return this.image.getCaptionHeaderText();
    }

    public void setCaptionHeaderText(String captionHeaderText) {
        this.image.setCaptionHeaderText(captionHeaderText);
    }

    @BeanTagAttribute(name="captionHeader", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Header getCaptionHeader() {
        return this.image.getCaptionHeader();
    }

    public void setCaptionHeader(Header captionHeader) {
        this.image.setCaptionHeader(captionHeader);
    }

    @BeanTagAttribute(name="cutlineText")
    public String getCutlineText() {
        return this.image.getCutlineText();
    }

    public void setCutlineText(String cutlineText) {
        this.image.setCutlineText(cutlineText);
    }

    @BeanTagAttribute(name="cutline", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getCutline() {
        return this.image.getCutlineMessage();
    }

    public void setCutline(Message cutline) {
        this.image.setCutlineMessage(cutline);
    }

    @BeanTagAttribute(name="captionHeaderAboveImage")
    public boolean isCaptionHeaderAboveImage() {
        return this.image.isCaptionHeaderPlacementAboveImage();
    }

    public void setCaptionHeaderAboveImage(boolean captionHeaderAboveImage) {
        this.image.setCaptionHeaderPlacementAboveImage(captionHeaderAboveImage);
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        ImageField imageFieldCopy = (ImageField)component;
        if (this.image != null) {
            imageFieldCopy.setImage((Image)this.image.copy());
        }
    }
}

