/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validation.capability.CaseConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.PrerequisiteConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.SimpleConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.ValidCharactersConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.SimpleConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.MultiValueControlBase;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinder;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.element.ValidationMessages;
import org.kuali.rice.krad.uif.field.AttributeQuery;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.util.ClientValidationUtils;
import org.kuali.rice.krad.uif.util.CloneUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ConstraintStateUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.QuickFinder;
import org.kuali.rice.krad.uif.widget.Suggest;
import org.kuali.rice.krad.util.ObjectUtils;

@BeanTags(value={@BeanTag(name="inputField-bean", parent="Uif-InputField"), @BeanTag(name="inputField-labelTop-bean", parent="Uif-InputField-LabelTop"), @BeanTag(name="inputField-labelRight-bean", parent="Uif-InputField-LabelRight"), @BeanTag(name="checkboxInputField-bean", parent="Uif-CheckboxInputField"), @BeanTag(name="dialogResponse-bean", parent="Uif-DialogResponse"), @BeanTag(name="dialogExplanation-bean", parent="Uif-DialogExplanation"), @BeanTag(name="documentNumber-bean", parent="Uif-DocumentNumber"), @BeanTag(name="documentStatus-bean", parent="Uif-DocumentStatus"), @BeanTag(name="documentInitiatorNetworkId-bean", parent="Uif-DocumentInitiatorNetworkId"), @BeanTag(name="documentCreateDate-bean", parent="Uif-DocumentCreateDate"), @BeanTag(name="documentTemplateNumber-bean", parent="Uif-DocumentTemplateNumber"), @BeanTag(name="documentDescription-bean", parent="Uif-DocumentDescription"), @BeanTag(name="documentExplaination-bean", parent="Uif-DocumentExplaination"), @BeanTag(name="organizationDocumentNumber-bean", parent="Uif-OrganizationDocumentNumber"), @BeanTag(name="selectCollectionItemField-bean", parent="Uif-SelectCollectionItemField")})
public class InputField
extends DataField
implements SimpleConstrainable,
CaseConstrainable,
PrerequisiteConstrainable,
MustOccurConstrainable,
ValidCharactersConstrainable {
    private static final long serialVersionUID = -3703656713706343840L;
    private String customValidatorClass;
    private ValidCharactersConstraint validCharactersConstraint;
    private CaseConstraint caseConstraint;
    private List<PrerequisiteConstraint> dependencyConstraints;
    private List<MustOccurConstraint> mustOccurConstraints;
    private SimpleConstraint simpleConstraint = new SimpleConstraint();
    private DataType dataType;
    private Control control;
    private KeyValuesFinder optionsFinder;
    private boolean uppercaseValue;
    private boolean disableNativeAutocomplete;
    private ValidationMessages validationMessages;
    private String constraintText;
    private String instructionalText;
    private Message constraintMessage;
    private Message instructionalMessage;
    private AttributeQuery attributeQuery;
    private boolean enableAutoDirectInquiry = true;
    private QuickFinder quickfinder;
    private boolean enableAutoQuickfinder = true;
    private Suggest suggest;
    private boolean widgetInputOnly;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
        if ((StringUtils.isNotBlank((String)this.constraintText) || this.getPropertyExpression("constraintText") != null) && this.constraintMessage == null) {
            this.constraintMessage = ComponentFactory.getConstraintMessage();
            view.assignComponentIds(this.constraintMessage);
        }
        if ((StringUtils.isNotBlank((String)this.instructionalText) || this.getPropertyExpression("instructionalText") != null) && this.instructionalMessage == null) {
            this.instructionalMessage = ComponentFactory.getInstructionalMessage();
            view.assignComponentIds(this.instructionalMessage);
        }
    }

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        Object fieldValue;
        MultiValueControlBase multiValueControl;
        super.performApplyModel(view, model, parent);
        if (StringUtils.isNotBlank((String)this.instructionalText) && StringUtils.isBlank((String)this.instructionalMessage.getMessageText())) {
            this.instructionalMessage.setMessageText(this.instructionalText);
        }
        if (StringUtils.isNotBlank((String)this.constraintText) && StringUtils.isBlank((String)this.constraintMessage.getMessageText())) {
            this.constraintMessage.setMessageText(this.constraintText);
        }
        ArrayList<KeyValue> fieldOptions = new ArrayList();
        if (this.control != null && this.control instanceof MultiValueControlBase && (multiValueControl = (MultiValueControlBase)this.control).getOptions() != null && !multiValueControl.getOptions().isEmpty()) {
            fieldOptions = multiValueControl.getOptions();
        }
        if (this.control instanceof TextAreaControl) {
            this.setMultiLineReadOnlyDisplay(true);
        }
        if (fieldOptions.isEmpty() && this.optionsFinder != null) {
            if (this.optionsFinder instanceof UifKeyValuesFinder) {
                fieldOptions = ((UifKeyValuesFinder)this.optionsFinder).getKeyValues((ViewModel)model, this);
                if (((UifKeyValuesFinder)this.optionsFinder).isAddBlankOption()) {
                    fieldOptions.add(0, (KeyValue)new ConcreteKeyValue("", ""));
                }
            } else {
                fieldOptions = this.optionsFinder.getKeyValues();
            }
            if (this.control != null && this.control instanceof MultiValueControlBase) {
                ((MultiValueControlBase)this.control).setOptions(fieldOptions);
            }
        }
        if (this.enableAutoDirectInquiry && this.getInquiry() == null && !this.isReadOnly()) {
            this.buildAutomaticInquiry(view, model, true);
        }
        if (this.enableAutoQuickfinder && this.getQuickfinder() == null) {
            this.buildAutomaticQuickfinder(view, model);
        }
        if (this.isReadOnly() && !fieldOptions.isEmpty() && StringUtils.isBlank((String)this.getReadOnlyDisplayReplacement()) && StringUtils.isBlank((String)this.getReadOnlyDisplaySuffix()) && StringUtils.isBlank((String)this.getReadOnlyDisplayReplacementPropertyName()) && StringUtils.isBlank((String)this.getReadOnlyDisplaySuffixPropertyName()) && (fieldValue = ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath())) != null && TypeUtils.isSimpleType(fieldValue.getClass())) {
            for (KeyValue keyValue : fieldOptions) {
                if (!StringUtils.equals((String)fieldValue.toString(), (String)keyValue.getKey())) continue;
                this.setReadOnlyDisplayReplacement(keyValue.getValue());
                break;
            }
        }
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        Object currentPropertyValue;
        super.performFinalize(view, model, parent);
        this.setupIds();
        this.addDataAttribute("role", "InputField");
        if (this.isReadOnly() || this.getControl() == null) {
            return;
        }
        if (this.uppercaseValue && (currentPropertyValue = ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath())) instanceof String) {
            String uppercasedValue = ((String)currentPropertyValue).toUpperCase();
            ObjectPropertyUtils.setPropertyValue(model, this.getBindingInfo().getBindingPath(), uppercasedValue);
        }
        if (this.suggest != null && this.suggest.isSuggestConfigured()) {
            this.setDisableNativeAutocomplete(true);
        }
        this.adjustPrerequisiteConstraintBinding(this.dependencyConstraints);
        this.adjustMustOccurConstraintBinding(this.mustOccurConstraints);
        if (this.caseConstraint != null) {
            String propertyName = this.getBindingInfo().getPropertyAdjustedBindingPath(this.caseConstraint.getPropertyName());
            this.caseConstraint.setPropertyName(propertyName);
        }
        this.setupFieldQuery();
        String path = view.getStateObjectBindingPath();
        Object stateObject = StringUtils.isNotBlank((String)path) ? ObjectPropertyUtils.getPropertyValue(model, path) : model;
        StateMapping stateMapping = view.getStateMapping();
        if (stateMapping != null) {
            SimpleConstraint prevConstraint;
            String validationState = ConstraintStateUtils.getClientViewValidationState(model, view);
            SimpleConstraint appliedSimpleConstraint = ConstraintStateUtils.getApplicableConstraint(this.getSimpleConstraint(), validationState, stateMapping);
            if (appliedSimpleConstraint != null && appliedSimpleConstraint.getRequired() != null && appliedSimpleConstraint.getRequired().booleanValue() && ((prevConstraint = ConstraintStateUtils.getApplicableConstraint(this.getSimpleConstraint(), stateMapping.getCurrentState(stateObject), stateMapping)) == null || prevConstraint.getRequired() == null || !prevConstraint.getRequired().booleanValue())) {
                this.getFieldLabel().getRequiredMessage().setMessageText("**");
            }
        }
        ClientValidationUtils.processAndApplyConstraints(this, view, model);
    }

    protected void buildAutomaticQuickfinder(View view, Object model) {
        QuickFinder autoQuickfinder = ComponentFactory.getQuickFinder();
        view.getViewHelperService().spawnSubLifecyle(view, model, autoQuickfinder, this, "INITIALIZE", "APPLY_MODEL");
        if (autoQuickfinder.isRender()) {
            this.quickfinder = autoQuickfinder;
        }
    }

    @Override
    protected void processReadOnlyListDisplay(Object model, List<?> originalList) {
        if (this.control != null && this.control instanceof MultiValueControlBase) {
            ArrayList<String> newList = new ArrayList<String>();
            List<KeyValue> fieldOptions = ((MultiValueControlBase)this.control).getOptions();
            if (fieldOptions == null || fieldOptions.isEmpty()) {
                return;
            }
            block0: for (Object fieldValue : originalList) {
                for (KeyValue keyValue : fieldOptions) {
                    if (fieldValue == null || !StringUtils.equals((String)fieldValue.toString(), (String)keyValue.getKey())) continue;
                    newList.add(keyValue.getValue());
                    continue block0;
                }
            }
            this.setReadOnlyDisplayReplacement(super.generateReadOnlyListDisplayReplacement(newList));
        } else {
            this.setReadOnlyDisplayReplacement(super.generateReadOnlyListDisplayReplacement(originalList));
        }
    }

    @Override
    protected void setAlternateAndAdditionalDisplayValue(View view, Object model) {
        if (StringUtils.isNotBlank((String)this.getReadOnlyDisplayReplacement()) || StringUtils.isNotBlank((String)this.getReadOnlyDisplaySuffix())) {
            return;
        }
        if (this.isApplyMask()) {
            if (this.quickfinder != null && StringUtils.isNotBlank((String)this.quickfinder.getDataObjectClassName())) {
                this.setWidgetInputOnly(true);
            } else {
                this.setReadOnly(true);
            }
        }
        super.setAlternateAndAdditionalDisplayValue(view, model);
    }

    protected void adjustMustOccurConstraintBinding(List<MustOccurConstraint> mustOccurConstraints) {
        if (mustOccurConstraints != null) {
            for (MustOccurConstraint mustOccurConstraint : mustOccurConstraints) {
                this.adjustPrerequisiteConstraintBinding(mustOccurConstraint.getPrerequisiteConstraints());
                this.adjustMustOccurConstraintBinding(mustOccurConstraint.getMustOccurConstraints());
            }
        }
    }

    protected void adjustPrerequisiteConstraintBinding(List<PrerequisiteConstraint> prerequisiteConstraints) {
        if (prerequisiteConstraints != null) {
            for (PrerequisiteConstraint prerequisiteConstraint : prerequisiteConstraints) {
                String propertyName = this.getBindingInfo().getPropertyAdjustedBindingPath(prerequisiteConstraint.getPropertyName());
                prerequisiteConstraint.setPropertyName(propertyName);
            }
        }
    }

    protected void setupFieldQuery() {
        if (this.getAttributeQuery() != null) {
            this.getAttributeQuery().updateQueryFieldMapping(this.getBindingInfo());
            this.getAttributeQuery().updateReturnFieldMapping(this.getBindingInfo());
            this.getAttributeQuery().updateQueryMethodArgumentFieldList(this.getBindingInfo());
            String script = "executeFieldQuery('" + this.getControl().getId() + "',";
            script = script + "'" + this.getId() + "'," + this.getAttributeQuery().getQueryFieldMappingJsString() + ",";
            script = script + this.getAttributeQuery().getQueryMethodArgumentFieldsJsString() + ",";
            script = script + this.getAttributeQuery().getReturnFieldMappingJsString() + ");";
            if (StringUtils.isNotBlank((String)this.getControl().getOnBlurScript())) {
                script = this.getControl().getOnBlurScript() + script;
            }
            this.getControl().setOnBlurScript(script);
        }
    }

    protected void setupIds() {
        this.setNestedComponentIdAndSuffix(this.getControl(), "_control");
        this.setNestedComponentIdAndSuffix(this.getValidationMessages(), "_errors");
        this.setNestedComponentIdAndSuffix(this.getFieldLabel(), "_label");
        this.setNestedComponentIdAndSuffix(this.getInstructionalMessage(), "_instructional");
        this.setNestedComponentIdAndSuffix(this.getConstraintMessage(), "_constraint");
        this.setNestedComponentIdAndSuffix(this.getQuickfinder(), "_quickfinder");
        this.setNestedComponentIdAndSuffix(this.getSuggest(), "_suggest");
        if (this.getControl() != null) {
            this.getControl().addDataAttribute("control_for", this.getId());
        }
    }

    @Override
    public void copyFromAttributeDefinition(View view, AttributeDefinition attributeDefinition) {
        super.copyFromAttributeDefinition(view, attributeDefinition);
        if (this.getMaxLength() == null) {
            this.setMaxLength(attributeDefinition.getMaxLength());
        }
        if (this.getMinLength() == null) {
            this.setMinLength(attributeDefinition.getMinLength());
        }
        if (this.getValidCharactersConstraint() == null) {
            this.setValidCharactersConstraint(attributeDefinition.getValidCharactersConstraint());
        }
        if (this.getCaseConstraint() == null) {
            this.setCaseConstraint(attributeDefinition.getCaseConstraint());
        }
        if (this.getDependencyConstraints() == null) {
            this.setDependencyConstraints(attributeDefinition.getPrerequisiteConstraints());
        }
        if (this.getMustOccurConstraints() == null) {
            this.setMustOccurConstraints(attributeDefinition.getMustOccurConstraints());
        }
        if (this.getRequired() == null) {
            this.setRequired(attributeDefinition.isRequired());
            if (this.getRequired() == null) {
                this.setRequired(Boolean.FALSE);
            }
        }
        if (this.getDataType() == null) {
            this.setDataType(attributeDefinition.getDataType());
            if (this.getDataType() == null && this.control instanceof TextControl && ((TextControl)this.control).getDatePicker() != null) {
                this.setDataType(DataType.DATE);
            }
        }
        if (this.getControl() == null && attributeDefinition.getControlField() != null) {
            Control control = attributeDefinition.getControlField();
            view.assignComponentIds(control);
            this.setControl(ComponentUtils.copy(control));
        }
        if (StringUtils.isEmpty((String)this.getConstraintText())) {
            this.setConstraintText(attributeDefinition.getConstraintText());
            if (this.constraintMessage == null) {
                this.constraintMessage = ComponentFactory.getConstraintMessage();
                view.assignComponentIds(this.constraintMessage);
            }
            this.getConstraintMessage().setMessageText(attributeDefinition.getConstraintText());
        }
        if (this.getOptionsFinder() == null) {
            this.setOptionsFinder(attributeDefinition.getOptionsFinder());
        }
        if (this.getSimpleConstraint().getConstraintStateOverrides() == null) {
            this.getSimpleConstraint().setConstraintStateOverrides(attributeDefinition.getSimpleConstraint().getConstraintStateOverrides());
        }
        if (this.getSimpleConstraint().getStates().isEmpty()) {
            this.getSimpleConstraint().setStates(attributeDefinition.getSimpleConstraint().getStates());
        }
        if (this.getSimpleConstraint().getMessageKey() == null) {
            this.getSimpleConstraint().setMessageKey(attributeDefinition.getSimpleConstraint().getMessageKey());
        }
        if (this.getSimpleConstraint().getApplyClientSide() == null) {
            this.getSimpleConstraint().setApplyClientSide(attributeDefinition.getSimpleConstraint().getApplyClientSide());
        }
        if (this.getSimpleConstraint().getValidationMessageParams() == null) {
            this.getSimpleConstraint().setValidationMessageParams(attributeDefinition.getSimpleConstraint().getValidationMessageParams());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.instructionalMessage);
        components.add(this.constraintMessage);
        components.add(this.control);
        components.add(this.validationMessages);
        components.add(this.quickfinder);
        components.add(this.suggest);
        return components;
    }

    @Override
    public boolean isInputAllowed() {
        return true;
    }

    @BeanTagAttribute(name="control", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    @BeanTagAttribute(name="validationMessages", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ValidationMessages getValidationMessages() {
        return this.validationMessages;
    }

    public void setValidationMessages(ValidationMessages validationMessages) {
        this.validationMessages = validationMessages;
    }

    @BeanTagAttribute(name="optionsFinder", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public KeyValuesFinder getOptionsFinder() {
        return this.optionsFinder;
    }

    public void setOptionsFinder(KeyValuesFinder optionsFinder) {
        this.optionsFinder = optionsFinder;
    }

    @BeanTagAttribute(name="optionsFinderClass")
    public Class<? extends KeyValuesFinder> getOptionsFinderClass() {
        if (this.optionsFinder != null) {
            return this.optionsFinder.getClass();
        }
        return null;
    }

    public void setOptionsFinderClass(Class<? extends KeyValuesFinder> optionsFinderClass) {
        this.optionsFinder = ObjectUtils.newInstance(optionsFinderClass);
    }

    public boolean isEnableAutoDirectInquiry() {
        return this.enableAutoDirectInquiry;
    }

    public void setEnableAutoDirectInquiry(boolean enableAutoDirectInquiry) {
        this.enableAutoDirectInquiry = enableAutoDirectInquiry;
    }

    @BeanTagAttribute(name="quickfinder", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public QuickFinder getQuickfinder() {
        return this.quickfinder;
    }

    public void setQuickfinder(QuickFinder quickfinder) {
        this.quickfinder = quickfinder;
    }

    public boolean isEnableAutoQuickfinder() {
        return this.enableAutoQuickfinder;
    }

    public void setEnableAutoQuickfinder(boolean enableAutoQuickfinder) {
        this.enableAutoQuickfinder = enableAutoQuickfinder;
    }

    @BeanTagAttribute(name="suggest", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Suggest getSuggest() {
        return this.suggest;
    }

    public void setSuggest(Suggest suggest) {
        this.suggest = suggest;
    }

    @BeanTagAttribute(name="widgetInputOnly")
    public boolean isWidgetInputOnly() {
        return this.widgetInputOnly;
    }

    public void setWidgetInputOnly(boolean widgetInputOnly) {
        this.widgetInputOnly = widgetInputOnly;
    }

    @BeanTagAttribute(name="instructionalText")
    public String getInstructionalText() {
        return this.instructionalText;
    }

    public void setInstructionalText(String instructionalText) {
        this.instructionalText = instructionalText;
    }

    @BeanTagAttribute(name="instructionalMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getInstructionalMessage() {
        return this.instructionalMessage;
    }

    public void setInstructionalMessage(Message instructionalMessage) {
        this.instructionalMessage = instructionalMessage;
    }

    @BeanTagAttribute(name="constraintText")
    public String getConstraintText() {
        return this.constraintText;
    }

    public void setConstraintText(String constraintText) {
        this.constraintText = constraintText;
    }

    @BeanTagAttribute(name="constraintMessage", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getConstraintMessage() {
        return this.constraintMessage;
    }

    public void setConstraintMessage(Message constraintMessage) {
        this.constraintMessage = constraintMessage;
    }

    @Override
    @BeanTagAttribute(name="validCharactersConstraint", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ValidCharactersConstraint getValidCharactersConstraint() {
        return this.validCharactersConstraint;
    }

    public void setValidCharactersConstraint(ValidCharactersConstraint validCharactersConstraint) {
        this.validCharactersConstraint = validCharactersConstraint;
    }

    @Override
    @BeanTagAttribute(name="caseConstraint", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public CaseConstraint getCaseConstraint() {
        return this.caseConstraint;
    }

    public void setCaseConstraint(CaseConstraint caseConstraint) {
        this.caseConstraint = caseConstraint;
    }

    @BeanTagAttribute(name="dependencyConstraints", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<PrerequisiteConstraint> getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    public void setDependencyConstraints(List<PrerequisiteConstraint> dependencyConstraints) {
        this.dependencyConstraints = dependencyConstraints;
    }

    @Override
    public List<PrerequisiteConstraint> getPrerequisiteConstraints() {
        return this.dependencyConstraints;
    }

    @Override
    @BeanTagAttribute(name="mustOccurConstraints", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    @Override
    @BeanTagAttribute(name="simpleConstraint", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public SimpleConstraint getSimpleConstraint() {
        return this.simpleConstraint;
    }

    public void setSimpleConstraint(SimpleConstraint simpleConstraint) {
        this.simpleConstraint = simpleConstraint;
    }

    public void setDataType(DataType dataType) {
        this.simpleConstraint.setDataType(dataType);
    }

    public void setDataType(String dataType) {
        this.simpleConstraint.setDataType(DataType.valueOf((String)dataType));
    }

    @BeanTagAttribute(name="dataType", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public DataType getDataType() {
        return this.simpleConstraint.getDataType();
    }

    @BeanTagAttribute(name="maxLength")
    public Integer getMaxLength() {
        return this.simpleConstraint.getMaxLength();
    }

    public void setMaxLength(Integer maxLength) {
        this.simpleConstraint.setMaxLength(maxLength);
    }

    @BeanTagAttribute(name="minLength")
    public Integer getMinLength() {
        return this.simpleConstraint.getMinLength();
    }

    public void setMinLength(Integer minLength) {
        this.simpleConstraint.setMinLength(minLength);
    }

    @Override
    @BeanTagAttribute(name="required")
    public Boolean getRequired() {
        return this.simpleConstraint.getRequired();
    }

    @Override
    public void setRequired(Boolean required) {
        this.simpleConstraint.setRequired(required);
    }

    @BeanTagAttribute(name="exclusiveMin")
    public String getExclusiveMin() {
        return this.simpleConstraint.getExclusiveMin();
    }

    public void setExclusiveMin(String exclusiveMin) {
        this.simpleConstraint.setExclusiveMin(exclusiveMin);
    }

    @BeanTagAttribute(name="inclusiveMax")
    public String getInclusiveMax() {
        return this.simpleConstraint.getInclusiveMax();
    }

    public void setInclusiveMax(String inclusiveMax) {
        this.simpleConstraint.setInclusiveMax(inclusiveMax);
    }

    @BeanTagAttribute(name="attributeQuery", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public AttributeQuery getAttributeQuery() {
        return this.attributeQuery;
    }

    public void setAttributeQuery(AttributeQuery attributeQuery) {
        this.attributeQuery = attributeQuery;
    }

    @BeanTagAttribute(name="uppercaseValue")
    public boolean isUppercaseValue() {
        return this.uppercaseValue;
    }

    public void setUppercaseValue(boolean uppercaseValue) {
        this.uppercaseValue = uppercaseValue;
    }

    public boolean isDisableNativeAutocomplete() {
        return this.disableNativeAutocomplete;
    }

    public void setDisableNativeAutocomplete(boolean disableNativeAutocomplete) {
        this.disableNativeAutocomplete = disableNativeAutocomplete;
    }

    @Override
    public boolean isRenderFieldset() {
        return super.isRenderFieldset() || this.quickfinder != null && this.quickfinder.isRender() && this.quickfinder.getQuickfinderAction() != null && this.quickfinder.getQuickfinderAction().isRender();
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        InputField inputFieldCopy = (InputField)component;
        inputFieldCopy.setCustomValidatorClass(this.customValidatorClass);
        inputFieldCopy.setValidCharactersConstraint(CloneUtils.deepClone(this.validCharactersConstraint));
        inputFieldCopy.setCaseConstraint(CloneUtils.deepClone(this.caseConstraint));
        if (this.dependencyConstraints != null) {
            ArrayList dependencyConstraintsCopy = Lists.newArrayListWithExpectedSize((int)this.dependencyConstraints.size());
            for (PrerequisiteConstraint dependencyConstraint : this.dependencyConstraints) {
                dependencyConstraintsCopy.add(CloneUtils.deepClone(dependencyConstraint));
            }
            inputFieldCopy.setDependencyConstraints(dependencyConstraintsCopy);
        }
        if (this.mustOccurConstraints != null) {
            ArrayList mustOccurConstraintsCopy = Lists.newArrayListWithExpectedSize((int)this.mustOccurConstraints.size());
            for (MustOccurConstraint mustOccurConstraint : this.mustOccurConstraints) {
                mustOccurConstraintsCopy.add(CloneUtils.deepClone(mustOccurConstraint));
            }
            inputFieldCopy.setMustOccurConstraints(mustOccurConstraintsCopy);
        }
        inputFieldCopy.setSimpleConstraint(CloneUtils.deepClone(this.simpleConstraint));
        inputFieldCopy.setDataType(this.dataType);
        if (this.control != null) {
            inputFieldCopy.setControl((Control)this.control.copy());
        }
        inputFieldCopy.setOptionsFinder(this.optionsFinder);
        inputFieldCopy.setUppercaseValue(this.uppercaseValue);
        inputFieldCopy.setDisableNativeAutocomplete(this.disableNativeAutocomplete);
        if (this.validationMessages != null) {
            inputFieldCopy.setValidationMessages((ValidationMessages)this.validationMessages.copy());
        }
        inputFieldCopy.setConstraintText(this.constraintText);
        inputFieldCopy.setInstructionalText(this.instructionalText);
        if (this.constraintMessage != null) {
            inputFieldCopy.setConstraintMessage((Message)this.constraintMessage.copy());
        }
        if (this.instructionalMessage != null) {
            inputFieldCopy.setInstructionalMessage((Message)this.instructionalMessage.copy());
        }
        if (this.attributeQuery != null) {
            inputFieldCopy.setAttributeQuery((AttributeQuery)this.attributeQuery.copy());
        }
        inputFieldCopy.setEnableAutoDirectInquiry(this.enableAutoDirectInquiry);
        if (this.quickfinder != null) {
            inputFieldCopy.setQuickfinder((QuickFinder)this.quickfinder.copy());
        }
        inputFieldCopy.setEnableAutoQuickfinder(this.enableAutoQuickfinder);
        if (this.suggest != null) {
            inputFieldCopy.setSuggest((Suggest)this.suggest.copy());
        }
        inputFieldCopy.setWidgetInputOnly(this.widgetInputOnly);
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (this.getControl() == null && Validator.checkExpressions(this, "control")) {
            String[] currentValues = new String[]{"control =" + this.getConstraintText()};
            tracer.createWarning("Control should be set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    public void setCustomValidatorClass(String customValidatorClass) {
        this.customValidatorClass = customValidatorClass;
    }
}

