/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="messageField-bean", parent="Uif-MessageField"), @BeanTag(name="colGroupingField-bean", parent="Uif-ColGroupingField")})
public class MessageField
extends FieldBase {
    private static final long serialVersionUID = -7045208136391722063L;
    private Message message;

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.message);
        return components;
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.getFieldLabel() != null && this.getMessage() != null && StringUtils.isNotBlank((String)this.getMessage().getId())) {
            if (this.getMessage().getMessageComponentStructure() != null && !this.getMessage().getMessageComponentStructure().isEmpty()) {
                this.getFieldLabel().setLabelForComponentId(this.getMessage().getId());
            } else {
                this.getFieldLabel().setLabelForComponentId(this.getMessage().getId() + "_span");
            }
        }
    }

    @BeanTagAttribute(name="messageText")
    public void setMessageText(String messageText) {
        if (this.message != null) {
            this.message.setMessageText(messageText);
        }
    }

    @BeanTagAttribute(name="inlineComponents")
    public void setInlineComponents(List<Component> inlineComponents) {
        if (this.message != null) {
            this.message.setInlineComponents(inlineComponents);
        }
    }

    @BeanTagAttribute(name="messageComponentStructure")
    public void setMessageComponentStructure(List<Component> messageComponentStructure) {
        if (this.message != null) {
            this.message.setMessageComponentStructure(messageComponentStructure);
        }
    }

    @BeanTagAttribute(name="message", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getMessage() == null && Validator.checkExpressions(this, "message")) {
            currentValues = new String[]{"message =" + this.getMessage()};
            tracer.createWarning("Message should not be null", currentValues);
        }
        if (this.getLabel() == null && Validator.checkExpressions(this, "label")) {
            currentValues = new String[]{"label =" + this.getLabel(), "Message =" + this.getMessage()};
            tracer.createWarning("Label is null, message should be used instead", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    protected <T> void copyProperties(T component) {
        super.copyProperties(component);
        MessageField messageFieldCopy = (MessageField)component;
        if (this.message != null) {
            messageFieldCopy.setMessage((Message)this.message.copy());
        }
    }
}

