/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.freemarker;

import freemarker.core.Environment;
import freemarker.core.InlineTemplateUtils;
import freemarker.core.Macro;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.StackedLayoutManager;
import org.kuali.rice.krad.uif.widget.Disclosure;
import org.kuali.rice.krad.uif.widget.Pager;
import org.kuali.rice.krad.uif.widget.Tooltip;
import org.springframework.util.StringUtils;

public class FreeMarkerInlineRenderUtils {
    public static <T> T resolve(Environment env, String name) {
        TemplateModel tm = FreeMarkerInlineRenderUtils.resolveModel(env, name);
        try {
            return (T)FreeMarkerInlineRenderUtils.getBeansWrapper(env).unwrap(tm);
        }
        catch (TemplateModelException e) {
            throw new IllegalArgumentException("Failed to unwrap " + name + ", template model " + tm, e);
        }
    }

    public static <T> T resolve(Environment env, String name, Class<T> type) {
        Object rv = FreeMarkerInlineRenderUtils.resolve(env, name);
        if (rv instanceof Collection && !Collection.class.isAssignableFrom(type)) {
            Collection rc = (Collection)rv;
            if (rc.isEmpty()) {
                return null;
            }
            rv = rc.iterator().next();
        }
        if ("".equals(rv) && !String.class.equals(type)) {
            return null;
        }
        return type.cast(rv);
    }

    public static BeansWrapper getBeansWrapper(Environment env) {
        ObjectWrapper wrapper = env.getObjectWrapper();
        if (!(wrapper instanceof BeansWrapper)) {
            throw new UnsupportedOperationException("FreeMarker environment uses unsupported ObjectWrapper " + wrapper);
        }
        return (BeansWrapper)wrapper;
    }

    public static TemplateModel resolveModel(Environment env, String name) {
        try {
            return env.getVariable(name);
        }
        catch (TemplateModelException e) {
            throw new IllegalArgumentException("Failed to resolve " + name + " in current freemarker environment", e);
        }
    }

    public static void renderTemplate(Environment env, Component component, String body, boolean componentUpdate, boolean includeSrc, Map<String, TemplateModel> tmplParms) throws TemplateException, IOException {
        List<String> refreshWhenChanged;
        String s;
        if (component == null) {
            return;
        }
        Writer out = env.getOut();
        if (component.isRender() && (!component.isRetrieveViaAjax() || componentUpdate) || component.getProgressiveRender() != null && !component.getProgressiveRender().equals("") && !component.isProgressiveRenderViaAJAX() && !component.isProgressiveRenderAndRefresh()) {
            s = component.getPreRenderContent();
            if (StringUtils.hasText((String)s)) {
                out.write(StringEscapeUtils.escapeHtml((String)s));
            }
            if (component.isSelfRendered()) {
                out.write(component.getRenderedHtmlOutput());
            } else {
                Macro fmMacro;
                if (includeSrc) {
                    env.include(component.getTemplate(), env.getTemplate().getEncoding(), true);
                }
                if ((fmMacro = (Macro)env.getMainNamespace().get(component.getTemplateName())) == null) {
                    throw new TemplateException("No macro found using " + component.getTemplateName(), env);
                }
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put(component.getComponentTypeName(), component);
                if (tmplParms != null) {
                    args.putAll(tmplParms);
                }
                if (StringUtils.hasText((String)body)) {
                    args.put("body", body);
                }
                InlineTemplateUtils.invokeMacro((Environment)env, (Macro)fmMacro, args, null);
            }
            s = component.getEventHandlerScript();
            if (StringUtils.hasText((String)s)) {
                FreeMarkerInlineRenderUtils.renderScript(s, component, null, out);
            }
            if (StringUtils.hasText((String)(s = component.getPostRenderContent()))) {
                out.append(StringEscapeUtils.escapeHtml((String)s));
            }
        }
        if (componentUpdate) {
            return;
        }
        String methodToCallOnRefresh = ((ComponentBase)component).getMethodToCallOnRefresh();
        if (!StringUtils.hasText((String)methodToCallOnRefresh)) {
            methodToCallOnRefresh = "";
        }
        if (StringUtils.hasText((String)(s = component.getProgressiveRender()))) {
            if (!component.isRender() && (component.isProgressiveRenderViaAJAX() || component.isProgressiveRenderAndRefresh())) {
                out.write("<span id=\"");
                out.write(component.getId());
                out.write("\" data-role=\"placeholder\" class=\"uif-placeholder\"></span>");
            }
            for (String cName : component.getProgressiveDisclosureControlNames()) {
                FreeMarkerInlineRenderUtils.renderScript("var condition = function(){return (" + component.getProgressiveDisclosureConditionJs() + ");};setupProgressiveCheck('" + StringEscapeUtils.escapeJavaScript((String)cName) + "', '" + component.getId() + "', '" + component.getBaseId() + "', condition," + component.isProgressiveRenderAndRefresh() + ", '" + methodToCallOnRefresh + "');", component, null, out);
            }
            FreeMarkerInlineRenderUtils.renderScript("hiddenInputValidationToggle('" + component.getId() + "');", null, null, out);
        }
        if (component.isProgressiveRenderViaAJAX() && !StringUtils.hasLength((String)component.getProgressiveRender()) || !component.isRender() && (component.isDisclosedByAction() || component.isRefreshedByAction()) || component.isRetrieveViaAjax()) {
            out.write("<span id=\"");
            out.write(component.getId());
            out.write("\" data-role=\"placeholder\" class=\"uif-placeholder\"></span>");
        }
        if (StringUtils.hasText((String)component.getConditionalRefresh())) {
            for (String cName : component.getConditionalRefreshControlNames()) {
                FreeMarkerInlineRenderUtils.renderScript("var condition = function(){return (" + component.getConditionalRefreshConditionJs() + ");};setupRefreshCheck('" + StringEscapeUtils.escapeJavaScript((String)cName) + "', '" + component.getId() + "', condition,'" + methodToCallOnRefresh + "');", null, null, out);
            }
        }
        if ((refreshWhenChanged = component.getRefreshWhenChangedPropertyNames()) != null) {
            for (String cName : refreshWhenChanged) {
                FreeMarkerInlineRenderUtils.renderScript("setupOnChangeRefresh('" + StringEscapeUtils.escapeJavaScript((String)cName) + "', '" + component.getId() + "','" + methodToCallOnRefresh + "');", null, null, out);
            }
        }
        FreeMarkerInlineRenderUtils.renderTooltip(component, out);
    }

    public static void renderTooltip(Component component, Writer out) throws IOException {
        Tooltip tt = component.getToolTip();
        if (tt != null && StringUtils.hasText((String)tt.getTooltipContent())) {
            String templateOptionsJSString = tt.getTemplateOptionsJSString();
            FreeMarkerInlineRenderUtils.renderScript("createTooltip('" + component.getId() + "', '" + tt.getTooltipContent() + "', " + (templateOptionsJSString == null ? "''" : templateOptionsJSString) + ", " + tt.isOnMouseHover() + ", " + tt.isOnFocus() + ");", component, null, out);
            FreeMarkerInlineRenderUtils.renderScript("addAttribute('" + component.getId() + "', 'class', 'uif-tooltip', true);", component, null, out);
        }
    }

    public static void renderScript(String script, Component component, String role, Writer out) throws IOException {
        if (script == null || "".equals(script.trim())) {
            return;
        }
        out.write("<input name=\"script\" type=\"hidden\" data-role=\"");
        out.write(role == null ? "script" : role);
        out.write("\" ");
        if (component != null && component.getId() != null) {
            out.write("data-for=\"");
            out.write(component.getId());
            out.write("\" ");
        }
        out.write("value=\"");
        out.write(StringEscapeUtils.escapeHtml((String)script));
        out.write("\" />");
    }

    public static void renderAttrBuild(Component component, Writer out) throws IOException {
        ComponentBase componentBase;
        String s;
        if (component instanceof ComponentBase && StringUtils.hasText((String)(s = (componentBase = (ComponentBase)component).getStyleClassesAsString()))) {
            out.write(" class=\"");
            out.write(s);
            out.write("\"");
        }
        if (StringUtils.hasText((String)(s = component.getStyle()))) {
            out.write(" style=\"");
            out.write(s);
            out.write("\"");
        }
        if (StringUtils.hasText((String)(s = component.getTitle()))) {
            out.write(" title=\"");
            out.write(s);
            out.write("\"");
        }
    }

    public static void renderOpenDiv(Component component, Writer out) throws IOException {
        out.write("<div id=\"");
        out.write(component.getId());
        out.write("\"");
        FreeMarkerInlineRenderUtils.renderAttrBuild(component, out);
        out.write(component.getSimpleDataAttributes());
        out.write(">");
    }

    public static void renderCloseDiv(Writer out) throws IOException {
        out.write("</div>");
    }

    public static void renderOpenGroupWrap(Environment env, Group group) throws IOException, TemplateException {
        Writer out = env.getOut();
        FreeMarkerInlineRenderUtils.renderOpenDiv(group, out);
        FreeMarkerInlineRenderUtils.renderTemplate(env, group.getHeader(), null, false, false, null);
        if (group.isRenderLoading()) {
            out.write("<div id=\"");
            out.write(group.getId());
            out.write("_disclosureContent\" data-role=\"placeholder\"> Loading... </div>");
        } else {
            Disclosure disclosure = group.getDisclosure();
            if (disclosure != null && disclosure.isRender()) {
                out.write("<div id=\"");
                out.write(group.getId() + "_disclosureContent");
                out.write("\" data-role=\"disclosureContent\" data-open=\"");
                out.write(Boolean.toString(disclosure.isDefaultOpen()));
                out.write("\" class=\"uif-disclosureContent\">");
            }
            FreeMarkerInlineRenderUtils.renderTemplate(env, group.getValidationMessages(), null, false, false, null);
            FreeMarkerInlineRenderUtils.renderTemplate(env, group.getInstructionalMessage(), null, false, false, null);
        }
    }

    public static void renderCloseGroupWrap(Environment env, Group group) throws IOException, TemplateException {
        Disclosure disclosure;
        Writer out = env.getOut();
        boolean renderLoading = group.isRenderLoading();
        if (!renderLoading) {
            FreeMarkerInlineRenderUtils.renderTemplate(env, group.getFooter(), null, false, false, null);
        }
        if ((disclosure = group.getDisclosure()) != null && disclosure.isRender()) {
            if (!renderLoading) {
                out.write("</div>");
            }
            HashMap<String, TemplateModel> tmplParms = new HashMap<String, TemplateModel>();
            tmplParms.put("parent", env.getObjectWrapper().wrap((Object)group));
            FreeMarkerInlineRenderUtils.renderTemplate(env, disclosure, null, false, false, tmplParms);
        }
        FreeMarkerInlineRenderUtils.renderCloseDiv(out);
    }

    public static void renderCollectionGroup(Environment env, CollectionGroup group) throws IOException, TemplateException {
        FreeMarkerInlineRenderUtils.renderOpenGroupWrap(env, group);
        HashMap<String, TemplateModel> tmplParms = new HashMap<String, TemplateModel>();
        tmplParms.put("componentId", env.getObjectWrapper().wrap((Object)group.getId()));
        FreeMarkerInlineRenderUtils.renderTemplate(env, group.getCollectionLookup(), null, false, false, tmplParms);
        if ("TOP".equals(group.getAddLinePlacement())) {
            if (group.isRenderAddBlankLineButton()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, group.getAddBlankLineAction(), null, false, false, null);
            }
            if (group.isAddViaLightBox()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, group.getAddViaLightBoxAction(), null, false, false, null);
            }
        }
        LayoutManager layoutManager = group.getLayoutManager();
        String managerTemplateName = layoutManager.getTemplateName();
        List<? extends Component> items = group.getItems();
        if ("uif_stacked".equals(managerTemplateName)) {
            FreeMarkerInlineRenderUtils.renderStacked(env, items, (StackedLayoutManager)layoutManager, group);
        } else {
            Macro fmMacro = (Macro)env.getMainNamespace().get(layoutManager.getTemplateName());
            if (fmMacro == null) {
                throw new TemplateException("No macro found using " + layoutManager.getTemplateName(), env);
            }
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("items", items);
            args.put("manager", group.getLayoutManager());
            args.put("container", group);
            InlineTemplateUtils.invokeMacro((Environment)env, (Macro)fmMacro, args, null);
        }
        if ("BOTTOM".equals(group.getAddLinePlacement())) {
            if (group.isRenderAddBlankLineButton()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, group.getAddBlankLineAction(), null, false, false, null);
            }
            if (group.isAddViaLightBox()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, group.getAddViaLightBoxAction(), null, false, false, null);
            }
        }
        FreeMarkerInlineRenderUtils.renderCloseGroupWrap(env, group);
    }

    public static void renderStacked(Environment env, List<? extends Component> items, StackedLayoutManager manager, CollectionGroup container) throws IOException, TemplateException {
        Writer out = env.getOut();
        Pager pager = manager.getPagerWidget();
        HashMap<String, Object> pagerTmplParms = null;
        if (pager != null && container.isUseServerPaging()) {
            pagerTmplParms = new HashMap<String, TemplateModel>();
            pagerTmplParms.put("parent", env.getObjectWrapper().wrap((Object)container));
            FreeMarkerInlineRenderUtils.renderTemplate(env, pager, null, false, false, pagerTmplParms);
        }
        out.write("<div id=\"");
        out.write(manager.getId());
        out.write("\"");
        String s = manager.getStyle();
        if (StringUtils.hasText((String)s)) {
            out.write(" style=\"");
            out.write(s);
            out.write("\"");
        }
        if (StringUtils.hasText((String)(s = manager.getStyleClassesAsString()))) {
            out.write(" class=\"");
            out.write(s);
            out.write("\"");
        }
        out.write(">");
        Group wrapperGroup = manager.getWrapperGroup();
        if (wrapperGroup != null) {
            FreeMarkerInlineRenderUtils.renderTemplate(env, wrapperGroup, null, false, false, null);
        } else {
            for (Group item : manager.getStackedGroups()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, item, null, false, false, null);
            }
        }
        out.write("</div>");
        if (pager != null && container.isUseServerPaging()) {
            pagerTmplParms = new HashMap();
            pagerTmplParms.put("parent", env.getObjectWrapper().wrap((Object)container));
            FreeMarkerInlineRenderUtils.renderTemplate(env, pager, null, false, false, pagerTmplParms);
        }
    }
}

