/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.layout.LayoutManagerBase;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.view.View;

@BeanTags(value={@BeanTag(name="gridLayout-bean", parent="Uif-GridLayoutBase"), @BeanTag(name="twoColumnGridLayout-bean", parent="Uif-TwoColumnGridLayout"), @BeanTag(name="fourColumnGridLayout-bean", parent="Uif-FourColumnGridLayout"), @BeanTag(name="sixColumnGridLayout-bean", parent="Uif-SixColumnGridLayout")})
public class GridLayoutManager
extends LayoutManagerBase {
    private static final long serialVersionUID = 1890011900375071128L;
    private int numberOfColumns;
    private boolean suppressLineWrapping;
    private boolean applyAlternatingRowStyles;
    private boolean applyDefaultCellWidths;
    private boolean renderFirstRowHeader;
    private boolean renderAlternatingHeaderColumns;
    private boolean renderRowFirstCellHeader;
    private List<String> rowCssClasses = new ArrayList<String>();

    @Override
    public void performFinalize(View view, Object model, Container container) {
        super.performFinalize(view, model, container);
        if (this.suppressLineWrapping) {
            this.numberOfColumns = container.getItems().size();
        }
        for (Component component : container.getItems()) {
            if (!(this instanceof TableLayoutManager)) {
                component.addCellCssClass("uif-gridLayoutCell");
            }
            this.setCellAttributes(component);
        }
    }

    protected void setCellAttributes(Component component) {
        if (StringUtils.isNotBlank((String)component.getWidth()) && StringUtils.isBlank((String)component.getCellWidth())) {
            component.setCellWidth(component.getWidth());
            component.setWidth("");
        }
        if (StringUtils.isNotBlank((String)component.getAlign()) && !StringUtils.contains((String)component.getCellStyle(), (String)"text-align: ")) {
            if (component.getCellStyle() == null) {
                component.setCellStyle("");
            }
            component.setCellStyle(component.getCellStyle() + "text-align: " + component.getAlign() + ";");
            component.setAlign("");
        }
        if (StringUtils.isNotBlank((String)component.getValign()) && !StringUtils.contains((String)component.getCellStyle(), (String)"vertical-align: ")) {
            if (component.getCellStyle() == null) {
                component.setCellStyle("");
            }
            component.setCellStyle(component.getCellStyle() + "vertical-align: " + component.getValign() + ";");
            component.setValign("");
        }
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return Group.class;
    }

    @BeanTagAttribute(name="numberOfColumns")
    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    @BeanTagAttribute(name="suppressLineWrapping")
    public boolean isSuppressLineWrapping() {
        return this.suppressLineWrapping;
    }

    public void setSuppressLineWrapping(boolean suppressLineWrapping) {
        this.suppressLineWrapping = suppressLineWrapping;
    }

    @BeanTagAttribute(name="applyAlternatingRowStyles")
    public boolean isApplyAlternatingRowStyles() {
        return this.applyAlternatingRowStyles;
    }

    public void setApplyAlternatingRowStyles(boolean applyAlternatingRowStyles) {
        this.applyAlternatingRowStyles = applyAlternatingRowStyles;
    }

    @BeanTagAttribute(name="applyDefaultCellWidths")
    public boolean isApplyDefaultCellWidths() {
        return this.applyDefaultCellWidths;
    }

    public void setApplyDefaultCellWidths(boolean applyDefaultCellWidths) {
        this.applyDefaultCellWidths = applyDefaultCellWidths;
    }

    @BeanTagAttribute(name="renderRowFirstCellHeader")
    public boolean isRenderRowFirstCellHeader() {
        return this.renderRowFirstCellHeader;
    }

    public void setRenderRowFirstCellHeader(boolean renderRowFirstCellHeader) {
        this.renderRowFirstCellHeader = renderRowFirstCellHeader;
    }

    @BeanTagAttribute(name="renderFirstRowHeader")
    public boolean isRenderFirstRowHeader() {
        return this.renderFirstRowHeader;
    }

    public void setRenderFirstRowHeader(boolean renderFirstRowHeader) {
        this.renderFirstRowHeader = renderFirstRowHeader;
    }

    @BeanTagAttribute(name="renderAlternatingHeaderColumns")
    public boolean isRenderAlternatingHeaderColumns() {
        return this.renderAlternatingHeaderColumns;
    }

    public void setRenderAlternatingHeaderColumns(boolean renderAlternatingHeaderColumns) {
        this.renderAlternatingHeaderColumns = renderAlternatingHeaderColumns;
    }

    @BeanTagAttribute(name="rowCssClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getRowCssClasses() {
        return this.rowCssClasses;
    }

    public void setRowCssClasses(List<String> rowCssClasses) {
        this.rowCssClasses = rowCssClasses;
    }

    @Override
    protected <T> void copyProperties(T layoutManager) {
        super.copyProperties(layoutManager);
        GridLayoutManager gridLayoutManagerCopy = (GridLayoutManager)layoutManager;
        gridLayoutManagerCopy.setNumberOfColumns(this.numberOfColumns);
        gridLayoutManagerCopy.setSuppressLineWrapping(this.suppressLineWrapping);
        gridLayoutManagerCopy.setApplyAlternatingRowStyles(this.applyAlternatingRowStyles);
        gridLayoutManagerCopy.setApplyDefaultCellWidths(this.applyDefaultCellWidths);
        gridLayoutManagerCopy.setRenderFirstRowHeader(this.renderFirstRowHeader);
        gridLayoutManagerCopy.setRenderAlternatingHeaderColumns(this.renderAlternatingHeaderColumns);
        gridLayoutManagerCopy.setRenderRowFirstCellHeader(this.renderRowFirstCellHeader);
        if (this.rowCssClasses != null) {
            gridLayoutManagerCopy.setRowCssClasses(new ArrayList<String>(this.rowCssClasses));
        }
    }
}

