/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.layout.CollectionLayoutManager;
import org.kuali.rice.krad.uif.layout.CollectionLayoutUtils;
import org.kuali.rice.krad.uif.layout.LayoutManagerBase;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Pager;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="stackedCollectionLayout-bean", parent="Uif-StackedCollectionLayoutBase"), @BeanTag(name="stackedCollectionLayout-withGridItems-bean", parent="Uif-StackedCollectionLayout-WithGridItems"), @BeanTag(name="stackedCollectionLayout-withBoxItems-bean", parent="Uif-StackedCollectionLayout-WithBoxItems"), @BeanTag(name="stackedCollectionLayout-list-bean", parent="Uif-StackedCollectionLayout-List")})
public class StackedLayoutManager
extends LayoutManagerBase
implements CollectionLayoutManager {
    private static final long serialVersionUID = 4602368505430238846L;
    @KeepExpression
    private String summaryTitle;
    private List<String> summaryFields = new ArrayList<String>();
    private Group addLineGroup;
    private Group lineGroupPrototype;
    private FieldGroup subCollectionFieldGroupPrototype;
    private Field selectFieldPrototype;
    private Group wrapperGroup;
    private Pager pagerWidget;
    private List<Group> stackedGroups = new ArrayList<Group>();
    private boolean actionsInLineGroup;

    @Override
    public void performInitialization(View view, Object model, Container container) {
        super.performInitialization(view, model, container);
        this.stackedGroups = new ArrayList<Group>();
    }

    @Override
    public void performApplyModel(View view, Object model, Container container) {
        super.performApplyModel(view, model, container);
        if (this.wrapperGroup != null) {
            this.wrapperGroup.setItems(this.stackedGroups);
        }
    }

    @Override
    public void performFinalize(View view, Object model, Container container) {
        super.performFinalize(view, model, container);
        if (container instanceof CollectionGroup && ((CollectionGroup)container).isUseServerPaging() && this.getPagerWidget() != null) {
            CollectionGroup collectionGroup = (CollectionGroup)container;
            CollectionLayoutUtils.setupPagerWidget(this.pagerWidget, collectionGroup, model);
        }
    }

    @Override
    public void buildLine(View view, Object model, CollectionGroup collectionGroup, List<Field> lineFields, List<FieldGroup> subCollectionFields, String bindingPath, List<Action> actions, String idSuffix, Object currentLine, int lineIndex) {
        boolean isAddLine = lineIndex == -1;
        Group lineGroup = null;
        if (isAddLine) {
            this.stackedGroups = new ArrayList<Group>();
            if (this.addLineGroup == null) {
                lineGroup = ComponentUtils.copy(this.lineGroupPrototype, idSuffix);
            } else {
                lineGroup = ComponentUtils.copy(this.getAddLineGroup(), idSuffix);
                lineGroup.addStyleClass(collectionGroup.getAddItemCssClass());
            }
            if (collectionGroup.isAddViaLightBox()) {
                String actionScript = "showLightboxComponent('" + lineGroup.getId() + "');";
                if (StringUtils.isNotBlank((String)collectionGroup.getAddViaLightBoxAction().getActionScript())) {
                    actionScript = collectionGroup.getAddViaLightBoxAction().getActionScript() + actionScript;
                }
                collectionGroup.getAddViaLightBoxAction().setActionScript(actionScript);
                lineGroup.setStyle("display: none");
            }
        } else {
            lineGroup = ComponentUtils.copy(this.lineGroupPrototype, idSuffix);
        }
        if (((UifFormBase)model).isAddedCollectionItem(currentLine)) {
            lineGroup.addStyleClass(collectionGroup.getNewItemsCssClass());
        }
        ComponentUtils.updateContextForLine(lineGroup, currentLine, lineIndex, idSuffix);
        if (isAddLine) {
            if (lineGroup.getHeader() != null) {
                lineGroup.getHeader().setRichHeaderMessage(collectionGroup.getAddLineLabel());
            }
        } else {
            List modelCollection = (List)ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath());
            String headerText = this.buildLineHeaderText(view, modelCollection.get(lineIndex), lineGroup);
            if (StringUtils.isNotBlank((String)headerText) && lineGroup.getHeader() != null) {
                lineGroup.getHeader().setHeaderText(headerText);
            }
        }
        ArrayList<Component> groupFields = new ArrayList<Component>();
        groupFields.addAll(lineFields);
        groupFields.addAll(subCollectionFields);
        if (collectionGroup.isRenderLineActions() && !collectionGroup.isReadOnly() && lineGroup.getFooter() != null) {
            if (this.isActionsInLineGroup()) {
                groupFields.addAll(actions);
                lineGroup.setRenderFooter(false);
            } else {
                lineGroup.getFooter().setItems(actions);
            }
        }
        lineGroup.setItems(groupFields);
        this.stackedGroups.add(lineGroup);
    }

    protected String buildLineHeaderText(View view, Object line, Group lineGroup) {
        if (view.getViewHelperService().getExpressionEvaluator().containsElPlaceholder(this.summaryTitle)) {
            lineGroup.getPropertyExpressions().put("headerText", this.summaryTitle);
            return null;
        }
        String summaryFieldString = "";
        for (String summaryField : this.summaryFields) {
            Object summaryFieldValue = ObjectPropertyUtils.getPropertyValue(line, summaryField);
            if (StringUtils.isNotBlank((String)summaryFieldString)) {
                summaryFieldString = summaryFieldString + " - ";
            }
            if (summaryFieldValue != null) {
                summaryFieldString = summaryFieldString + summaryFieldValue;
                continue;
            }
            summaryFieldString = summaryFieldString + "Null";
        }
        String headerText = this.summaryTitle;
        if (StringUtils.isNotBlank((String)summaryFieldString)) {
            headerText = headerText + " ( " + summaryFieldString + " )";
        }
        return headerText;
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return CollectionGroup.class;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        if (this.wrapperGroup != null) {
            components.add(this.wrapperGroup);
        } else {
            components.addAll(this.stackedGroups);
        }
        if (this.pagerWidget != null) {
            components.add(this.pagerWidget);
        }
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = super.getComponentPrototypes();
        components.add(this.addLineGroup);
        components.add(this.lineGroupPrototype);
        components.add(this.subCollectionFieldGroupPrototype);
        components.add(this.selectFieldPrototype);
        return components;
    }

    @BeanTagAttribute(name="summaryTitle")
    public String getSummaryTitle() {
        return this.summaryTitle;
    }

    public void setSummaryTitle(String summaryTitle) {
        this.summaryTitle = summaryTitle;
    }

    @BeanTagAttribute(name="summaryFields", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getSummaryFields() {
        return this.summaryFields;
    }

    public void setSummaryFields(List<String> summaryFields) {
        this.summaryFields = summaryFields;
    }

    @BeanTagAttribute(name="addLineGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getAddLineGroup() {
        return this.addLineGroup;
    }

    public void setAddLineGroup(Group addLineGroup) {
        this.addLineGroup = addLineGroup;
    }

    @BeanTagAttribute(name="lineGroupPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getLineGroupPrototype() {
        return this.lineGroupPrototype;
    }

    public void setLineGroupPrototype(Group lineGroupPrototype) {
        this.lineGroupPrototype = lineGroupPrototype;
    }

    @Override
    @BeanTagAttribute(name="subCollectionFieldGroupPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public FieldGroup getSubCollectionFieldGroupPrototype() {
        return this.subCollectionFieldGroupPrototype;
    }

    public void setSubCollectionFieldGroupPrototype(FieldGroup subCollectionFieldGroupPrototype) {
        this.subCollectionFieldGroupPrototype = subCollectionFieldGroupPrototype;
    }

    @BeanTagAttribute(name="selectFieldPrototype", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Field getSelectFieldPrototype() {
        return this.selectFieldPrototype;
    }

    public void setSelectFieldPrototype(Field selectFieldPrototype) {
        this.selectFieldPrototype = selectFieldPrototype;
    }

    @BeanTagAttribute(name="wrapperGroup", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Group getWrapperGroup() {
        return this.wrapperGroup;
    }

    public void setWrapperGroup(Group wrapperGroup) {
        this.wrapperGroup = wrapperGroup;
    }

    public Pager getPagerWidget() {
        return this.pagerWidget;
    }

    public void setPagerWidget(Pager pagerWidget) {
        this.pagerWidget = pagerWidget;
    }

    @BeanTagAttribute(name="stackedGroups", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<Group> getStackedGroups() {
        return this.stackedGroups;
    }

    public void setStackedGroups(List<Group> stackedGroups) {
        this.stackedGroups = stackedGroups;
    }

    public boolean isActionsInLineGroup() {
        return this.actionsInLineGroup;
    }

    public void setActionsInLineGroup(boolean actionsInLineGroup) {
        this.actionsInLineGroup = actionsInLineGroup;
    }

    @Override
    protected <T> void copyProperties(T layoutManager) {
        super.copyProperties(layoutManager);
        StackedLayoutManager stackedLayoutManagerCopy = (StackedLayoutManager)layoutManager;
        stackedLayoutManagerCopy.setSummaryTitle(this.getSummaryTitle());
        if (this.summaryFields != null) {
            stackedLayoutManagerCopy.setSummaryFields(new ArrayList<String>(this.summaryFields));
        }
        if (this.addLineGroup != null) {
            stackedLayoutManagerCopy.setAddLineGroup((Group)this.getAddLineGroup().copy());
        }
        if (this.lineGroupPrototype != null) {
            stackedLayoutManagerCopy.setLineGroupPrototype((Group)this.getLineGroupPrototype().copy());
        }
        if (this.wrapperGroup != null) {
            stackedLayoutManagerCopy.setWrapperGroup((Group)this.getWrapperGroup().copy());
        }
        if (this.subCollectionFieldGroupPrototype != null) {
            stackedLayoutManagerCopy.setSubCollectionFieldGroupPrototype((FieldGroup)this.getSubCollectionFieldGroupPrototype().copy());
        }
        if (this.selectFieldPrototype != null) {
            stackedLayoutManagerCopy.setSelectFieldPrototype((Field)this.getSelectFieldPrototype().copy());
        }
        if (this.stackedGroups != null) {
            ArrayList stackedGroupsCopy = Lists.newArrayListWithExpectedSize((int)this.stackedGroups.size());
            for (Group stackedGroup : this.stackedGroups) {
                stackedGroupsCopy.add((Group)stackedGroup.copy());
            }
            stackedLayoutManagerCopy.setStackedGroups(stackedGroupsCopy);
        }
        stackedLayoutManagerCopy.setPagerWidget((Pager)this.getPagerWidget().copy());
        stackedLayoutManagerCopy.setActionsInLineGroup(this.isActionsInLineGroup());
    }
}

