/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.field.AttributeQuery;
import org.kuali.rice.krad.uif.field.AttributeQueryResult;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.service.AttributeQueryService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.LocationSuggest;
import org.kuali.rice.krad.uif.widget.Suggest;
import org.kuali.rice.krad.util.BeanPropertyComparator;

public class AttributeQueryServiceImpl
implements AttributeQueryService {
    private static final Logger LOG = Logger.getLogger(AttributeQueryServiceImpl.class);
    private LookupService lookupService;
    private ConfigurationService configurationService;

    @Override
    public AttributeQueryResult performFieldSuggestQuery(View view, String fieldId, String fieldTerm, Map<String, String> queryParameters) {
        AttributeQueryResult queryResult = new AttributeQueryResult();
        InputField inputField = (InputField)view.getViewIndex().getComponentById(fieldId);
        if (inputField == null) {
            throw new RuntimeException("Unable to find attribute field instance for id: " + fieldId);
        }
        Suggest fieldSuggest = inputField.getSuggest();
        AttributeQuery suggestQuery = fieldSuggest.getSuggestQuery();
        HashMap<String, String> additionalCriteria = new HashMap<String, String>();
        additionalCriteria.put(fieldSuggest.getValuePropertyName(), fieldTerm + "*");
        Collection results = null;
        if (suggestQuery.hasConfiguredMethod()) {
            Object queryMethodResult = this.executeAttributeQueryMethod(view, suggestQuery, queryParameters, true, fieldTerm);
            if (queryMethodResult != null && queryMethodResult instanceof Collection) {
                results = (Collection)queryMethodResult;
            }
        } else {
            results = this.executeAttributeQueryCriteria(suggestQuery, queryParameters, additionalCriteria);
        }
        if (results != null) {
            if (fieldSuggest.isReturnFullQueryObject()) {
                queryResult.setResultData((List)results);
            } else {
                this.retrievePropertiesOnResults(queryResult, results, fieldSuggest);
            }
        }
        return queryResult;
    }

    protected void retrievePropertiesOnResults(AttributeQueryResult queryResult, Collection<?> results, Suggest fieldSuggest) {
        ArrayList<Object> suggestData = new ArrayList<Object>();
        for (Object result : results) {
            if (result == null) continue;
            HashMap<String, String> propMap = new HashMap<String, String>();
            if (result instanceof String) {
                propMap.put("value", (String)result);
                propMap.put("label", (String)result);
            }
            Object suggestFieldValue = null;
            if (StringUtils.isNotBlank((String)fieldSuggest.getValuePropertyName())) {
                suggestFieldValue = ObjectPropertyUtils.getPropertyValue(result, fieldSuggest.getValuePropertyName());
            } else if (ObjectPropertyUtils.isReadableProperty(result, "value")) {
                suggestFieldValue = ObjectPropertyUtils.getPropertyValue(result, "value");
            }
            if (suggestFieldValue != null) {
                propMap.put("value", suggestFieldValue.toString());
            }
            Object suggestFieldLabel = null;
            if (StringUtils.isNotBlank((String)fieldSuggest.getLabelPropertyName())) {
                suggestFieldLabel = ObjectPropertyUtils.getPropertyValue(result, fieldSuggest.getLabelPropertyName());
            } else if (ObjectPropertyUtils.isReadableProperty(result, "label")) {
                suggestFieldLabel = ObjectPropertyUtils.getPropertyValue(result, "label");
            }
            if (suggestFieldLabel != null) {
                propMap.put("label", suggestFieldLabel.toString());
            }
            if (fieldSuggest instanceof LocationSuggest) {
                this.handleLocationSuggestProperties((LocationSuggest)fieldSuggest, result, propMap);
            }
            this.handleAdditionalSuggestProperties(fieldSuggest, result, propMap);
            if (propMap.isEmpty()) continue;
            suggestData.add(propMap);
        }
        queryResult.setResultData(suggestData);
    }

    private void handleAdditionalSuggestProperties(Suggest fieldSuggest, Object result, Map<String, String> propMap) {
        if (fieldSuggest.getAdditionalPropertiesToReturn() != null) {
            for (String propName : fieldSuggest.getAdditionalPropertiesToReturn()) {
                Object propValue = null;
                if (StringUtils.isNotBlank((String)propName) && ObjectPropertyUtils.isReadableProperty(result, propName)) {
                    propValue = ObjectPropertyUtils.getPropertyValue(result, propName);
                }
                if (propValue == null) continue;
                propMap.put(propName, propValue.toString());
            }
        }
    }

    private void handleLocationSuggestProperties(LocationSuggest fieldSuggest, Object result, Map<String, String> propMap) {
        Object suggestHrefValue = null;
        if (StringUtils.isNotBlank((String)fieldSuggest.getHrefPropertyName()) && ObjectPropertyUtils.isReadableProperty(result, fieldSuggest.getHrefPropertyName())) {
            suggestHrefValue = ObjectPropertyUtils.getPropertyValue(result, fieldSuggest.getHrefPropertyName());
        }
        if (suggestHrefValue != null) {
            propMap.put(fieldSuggest.getHrefPropertyName(), suggestHrefValue.toString());
        }
        Object addUrlValue = null;
        if (StringUtils.isNotBlank((String)fieldSuggest.getAdditionalUrlPathPropertyName()) && ObjectPropertyUtils.isReadableProperty(result, fieldSuggest.getAdditionalUrlPathPropertyName())) {
            addUrlValue = ObjectPropertyUtils.getPropertyValue(result, fieldSuggest.getAdditionalUrlPathPropertyName());
        }
        if (addUrlValue != null) {
            propMap.put(fieldSuggest.getAdditionalUrlPathPropertyName(), addUrlValue.toString());
        }
        if (fieldSuggest.getRequestParameterPropertyNames() == null) {
            return;
        }
        for (String key : fieldSuggest.getRequestParameterPropertyNames().keySet()) {
            String prop = fieldSuggest.getRequestParameterPropertyNames().get(key);
            Object propValue = null;
            if (StringUtils.isNotBlank((String)prop) && ObjectPropertyUtils.isReadableProperty(result, prop)) {
                propValue = ObjectPropertyUtils.getPropertyValue(result, prop);
            }
            if (propValue == null) continue;
            propMap.put(prop, propValue.toString());
        }
    }

    @Override
    public AttributeQueryResult performFieldQuery(View view, String fieldId, Map<String, String> queryParameters) {
        AttributeQueryResult queryResult = new AttributeQueryResult();
        InputField inputField = (InputField)view.getViewIndex().getComponentById(fieldId);
        if (inputField == null) {
            throw new RuntimeException("Unable to find attribute field instance for id: " + fieldId);
        }
        AttributeQuery fieldQuery = inputField.getAttributeQuery();
        if (fieldQuery == null) {
            throw new RuntimeException("Field query not defined for field instance with id: " + fieldId);
        }
        Object resultObject = null;
        if (fieldQuery.hasConfiguredMethod()) {
            Object queryMethodResult = this.executeAttributeQueryMethod(view, fieldQuery, queryParameters, false, null);
            if (queryMethodResult != null) {
                if (queryMethodResult instanceof AttributeQueryResult) {
                    return (AttributeQueryResult)queryMethodResult;
                }
                if (queryMethodResult instanceof Collection) {
                    Collection methodResultCollection = (Collection)queryMethodResult;
                    if (!methodResultCollection.isEmpty()) {
                        resultObject = methodResultCollection.iterator().next();
                    }
                } else {
                    resultObject = queryMethodResult;
                }
            }
        } else {
            Collection<?> results = this.executeAttributeQueryCriteria(fieldQuery, queryParameters, null);
            if (results != null && !results.isEmpty()) {
                resultObject = results.size() > 1 ? null : results.iterator().next();
            }
        }
        if (resultObject != null) {
            HashMap<String, String> resultFieldData = new HashMap<String, String>();
            for (String fromField : fieldQuery.getReturnFieldMapping().keySet()) {
                String returnField = fieldQuery.getReturnFieldMapping().get(fromField);
                String fieldValueStr = "";
                Object fieldValue = ObjectPropertyUtils.getPropertyValue(resultObject, fromField);
                if (fieldValue != null) {
                    fieldValueStr = fieldValue.toString();
                }
                resultFieldData.put(returnField, fieldValueStr);
            }
            queryResult.setResultFieldData(resultFieldData);
            fieldQuery.setReturnMessageText("");
        } else if (fieldQuery.isRenderNotFoundMessage()) {
            String messageTemplate = this.getConfigurationService().getPropertyValueAsString("query.dataNotFound");
            String message = MessageFormat.format(messageTemplate, inputField.getLabel());
            fieldQuery.setReturnMessageText(message.toLowerCase());
        }
        queryResult.setResultMessage(fieldQuery.getReturnMessageText());
        queryResult.setResultMessageStyleClasses(fieldQuery.getReturnMessageStyleClasses());
        return queryResult;
    }

    protected Object executeAttributeQueryMethod(View view, AttributeQuery attributeQuery, Map<String, String> queryParameters, boolean isSuggestQuery, String queryTerm) {
        String queryMethodToCall = attributeQuery.getQueryMethodToCall();
        MethodInvokerConfig queryMethodInvoker = attributeQuery.getQueryMethodInvokerConfig();
        if (queryMethodInvoker == null) {
            queryMethodInvoker = new MethodInvokerConfig();
        }
        if (StringUtils.isBlank((String)queryMethodInvoker.getTargetMethod())) {
            queryMethodInvoker.setTargetMethod(queryMethodToCall);
        }
        if (queryMethodInvoker.getTargetClass() == null && queryMethodInvoker.getTargetObject() == null) {
            queryMethodInvoker.setTargetObject(view.getViewHelperService());
        }
        ArrayList<String> arguments = new ArrayList<String>();
        if (attributeQuery.getQueryMethodArgumentFieldList() != null && !attributeQuery.getQueryMethodArgumentFieldList().isEmpty()) {
            Class[] argumentTypes;
            int numQueryMethodArguments = attributeQuery.getQueryMethodArgumentFieldList().size();
            if (isSuggestQuery) {
                ++numQueryMethodArguments;
            }
            if ((argumentTypes = queryMethodInvoker.getArgumentTypes()) == null || argumentTypes.length != numQueryMethodArguments) {
                throw new RuntimeException("Query method argument field list size does not match found number of method arguments");
            }
            for (int i = 0; i < attributeQuery.getQueryMethodArgumentFieldList().size(); ++i) {
                String methodArgumentFromField = attributeQuery.getQueryMethodArgumentFieldList().get(i);
                if (queryParameters.containsKey(methodArgumentFromField)) {
                    arguments.add(queryParameters.get(methodArgumentFromField));
                    continue;
                }
                arguments.add(null);
            }
        }
        if (isSuggestQuery) {
            arguments.add(queryTerm);
        }
        queryMethodInvoker.setArguments(arguments.toArray());
        try {
            queryMethodInvoker.prepare();
            return queryMethodInvoker.invoke();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke query method: " + queryMethodInvoker.getTargetMethod(), e);
        }
    }

    protected Collection<?> executeAttributeQueryCriteria(AttributeQuery attributeQuery, Map<String, String> queryParameters, Map<String, String> additionalCriteria) {
        Collection<?> results = null;
        HashMap<String, String> queryCriteria = new HashMap<String, String>();
        for (String fieldName : attributeQuery.getQueryFieldMapping().values()) {
            if (!queryParameters.containsKey(fieldName) || !StringUtils.isNotBlank((String)queryParameters.get(fieldName))) continue;
            queryCriteria.put(fieldName, queryParameters.get(fieldName));
        }
        for (String fieldName : attributeQuery.getAdditionalCriteria().keySet()) {
            queryCriteria.put(fieldName, attributeQuery.getAdditionalCriteria().get(fieldName));
        }
        if (additionalCriteria != null) {
            queryCriteria.putAll(additionalCriteria);
        }
        Class<?> queryClass = null;
        try {
            queryClass = Class.forName(attributeQuery.getDataObjectClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invalid data object class given for suggest query: " + attributeQuery.getDataObjectClassName(), e);
        }
        results = this.getLookupService().findCollectionBySearchUnbounded(queryClass, queryCriteria);
        if (!attributeQuery.getSortPropertyNames().isEmpty() && results != null && results.size() > 1) {
            Collections.sort((List)results, new BeanPropertyComparator(attributeQuery.getSortPropertyNames()));
        }
        return results;
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

